<?php
/**
 * @author wonli <wonli@live.com>
 * ModeManager.php
 */


namespace app\admin\modules\config\manager;


use app\admin\modules\config\ConfigAbstract;
use app\forum\modules\common\BaseModule;

/**
 * @author wonli <wonli@live.com>
 *
 * Class ModeManager
 * @package app\admin\modules\config\manager
 */
class ModeManager extends ConfigAbstract
{
    /**
     * 默认内容模型
     *
     * @var array
     */
    public static $defaultMode = array(
        'question' => array('name' => '问题', 'status' => 1),
        'posts' => array('name' => '帖子', 'status' => 1),
        'article' => array('name' => '文章', 'status' => 1),
    );

    /**
     * 分组名称
     *
     * @return mixed
     */
    function getGroupName()
    {
        return 'mode';
    }

    /**
     * 获取配置数据
     *
     * @param array $initConfigData
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function get($initConfigData = array())
    {
        $mode = $this->CONFIG->getAllConfig($this->groupName);
        if (empty($mode)) {
            $this->initSiteConfig($mode);
        }

        //默认模块不允许关闭
        if (!empty($initConfigData['default_mode'])) {
            $default_mode_name = BaseModule::$typeMap[$initConfigData['default_mode']];
        } else {
            $default_mode_name = 'question';
        }

        $mode['default_mode_name'] = $default_mode_name;
        return $mode;
    }

    /**
     * 保存配置数据
     *
     * @param array|string $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function save($data)
    {
        $default_mode = &$data['default_mode'];
        unset($data['default_mode']);

        $cleanData = array();
        if (!empty($data)) {
            foreach ($data as $mode => &$config) {
                if ($mode == $default_mode || isset($config['status'])) {
                    $config['status'] = 1;
                } else {
                    $config['status'] = 0;
                }
                $cleanData[$mode] = $config;
            }

            $saveData = array($this->groupName => $cleanData);
            return $this->CONFIG->saveConfig($saveData, $this->groupName);
        }

        return false;
    }

    /**
     * 初始化数据
     *
     * @param array $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function initSiteConfig(&$data = array())
    {
        $data = array($this->groupName => self::$defaultMode);
        return $this->save(self::$defaultMode);
    }
}