<?php
/**
 * @author wonli <wonli@live.com>
 * NavMenuManager.php
 */


namespace app\admin\modules\config\manager;


use app\admin\modules\config\ConfigAbstract;

/**
 * 导航菜单管理
 * @author wonli <wonli@live.com>
 *
 * Class NavMenuManager
 * @package app\admin\modules\config\manager
 */
class NavMenuManager extends ConfigAbstract
{
    /**
     * xs=[1|0]在移动模版下是否显示
     * type=[1|2]等于1时link参数格式为内部控制器:方法, 等于2时link参数为绝对路径
     * login_display [1|0]是否登录后才显示
     * target 默认在当前页面打开, 在新窗口打开请设置为_blank
     * current 控制器名称为当前值时设置选择状态
     *
     * @var array
     */
    private $defaultNavMenu = array(
        array(
            'xs' => 1,
            'name' => '动态',
            'type' => 1,
            'link' => 'main',
            'login_display' => 1,
            'new_window' => 0,
            'current' => 'main'
        ),
        array(
            'xs' => 1,
            'name' => '发现',
            'type' => 1,
            'link' => '',
            'login_display' => 0,
            'new_window' => 0,
            'current' => 'explore'
        ),
        array(
            'xs' => 1,
            'name' => '话题',
            'type' => 1,
            'link' => 'topics',
            'login_display' => 0,
            'new_window' => 0,
            'current' => 'topics'
        )
    );

    /**
     * 分组名称
     *
     * @return mixed
     */
    function getGroupName()
    {
        return 'nav';
    }

    /**
     * 获取配置数据
     *
     * @param array $initConfigData
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function get($initConfigData = array())
    {
        $savedConfig = $this->CONFIG->getAllConfig($this->groupName);
        if (empty($savedConfig)) {
            $this->initSiteConfig($savedConfig);
        }

        return $savedConfig;
    }

    /**
     * 保存配置数据
     *
     * @param array|string $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function save($data)
    {
        $saveData = array();
        $allowConfig = array('xs', 'name', 'type', 'current', 'link', 'new_window', 'login_display');

        if ($data && !empty($data['nav'])) {
            foreach ($data['nav'] as $k => $d) {
                foreach ($allowConfig as $defaultKey) {
                    switch ($defaultKey) {
                        case 'type':
                            if (!empty($d['link']) && $this->isAbsoluteLink($d['link'])) {
                                $d['type'] = 2;
                            } else {
                                $d['type'] = 1;
                            }
                            break;

                        case 'xs':
                        case 'login_display':
                        case 'new_window':
                            if (!isset($d[$defaultKey])) {
                                $d[$defaultKey] = 0;
                            } else {
                                $d[$defaultKey] = 1;
                            }
                    }
                }

                if (!empty($d['name'])) {
                    $saveData[] = $d;
                }
            }
        }

        return $this->CONFIG->saveConfig(array($this->groupName => $saveData), $this->groupName);
    }

    /**
     * 初始化
     *
     * @param array $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function initSiteConfig(&$data = array())
    {
        $data = $this->defaultNavMenu;
        return $this->CONFIG->saveConfig(array($this->groupName => $data), $this->groupName);
    }

    /**
     * 判断是否是一个绝对链接
     *
     * @param string $url
     * @return bool
     */
    private function isAbsoluteLink($url)
    {
        $url_info = parse_url($url);
        if (isset($url_info['host'])) {
            return true;
        } else {
            return false;
        }
    }
}