<?php
/**
 * @author wonli <wonli@live.com>
 * OauthManager.php
 */


namespace app\admin\modules\config\manager;


use app\admin\modules\config\ConfigAbstract;

/**
 * @author wonli <wonli@live.com>
 *
 * Class OauthManager
 * @package app\admin\modules\config\manager
 */
class OauthManager extends ConfigAbstract
{
    private $oauthDefaultOptions = array(
        'app_id' => '',
        'app_key' => '',
    );

    /**
     * 获取配置页所需数据
     *
     * @param array $siteConfig
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function get($siteConfig = array())
    {
        $oauthInfo = $this->CONFIG->getAllConfig($this->groupName);
        if (!empty($oauthInfo['oauth'])) {
            $oauth = $oauthInfo['oauth'];
        } else {
            $oauth = array(
                'qq' => $this->oauthDefaultOptions,
                'weibo' => $this->oauthDefaultOptions,
                'weixin' => $this->oauthDefaultOptions
            );
        }

        $rewrite_tip = false;
        $connectBaseUrl = $siteConfig['site_homepage'];
        if (empty($siteConfig['rewrite'])) {
            $rewrite_tip = true;
            $connectBaseUrl .= 'index.php?';
        }

        $data['oauth'] = $oauth;
        $data['rewrite_tip'] = $rewrite_tip;
        $data['connect_base_url'] = $connectBaseUrl;
        $data['oauth_config_name'] = array(
            'qq' => '腾讯QQ',
            'weibo' => '新浪微博',
            'weixin' => '微信',
        );

        return $data;
    }

    /**
     * 保存数据
     *
     * @param string|array $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function save($data)
    {
        return $this->CONFIG->saveConfig($data, $this->groupName);
    }

    /**
     * 分组名称
     *
     * @return mixed
     */
    function getGroupName()
    {
        return 'oauth';
    }
}