<?php
/**
 * @author wonli <wonli@live.com>
 * SiteManager.php
 */

namespace app\admin\modules\config\manager;

use app\admin\modules\config\ConfigAbstract;
use app\forum\modules\common\BaseModule;
use Cross\Http\Request;
use Cross\Core\Helper;

/**
 * @author wonli <wonli@live.com>
 *
 * Class SiteManager
 * @package app\admin\modules\config\manager
 */
class SiteManager extends ConfigAbstract
{
    private $defaultConfig = array(
        'site_name' => 'cpf',
        'site_homepage' => '',

        'title' => 'cpf社区',
        'keywords' => 'cpf-开源社区',
        'description' => 'cpf是一个以话题为中心，集论坛、问答、文章为一体的开源社区程序。',

        //网站一句话介绍
        'introduce' => '基于话题的SNS开源问答社区',

        //默认模式
        'default_mode' => 1,

        //服务器是否支持rewrite
        'rewrite' => 0,
        //是否开启邀请注册
        'invite' => 0,
        //帖子是否需要审核
        'verify' => 0,

        //加密相关
        'encrypt' => array(
            'uri' => '',
            'auth' => ''
        ),

        //默认模板文件夹
        'tpl_dir' => 'default',

        //邮件服务器
        'smtp' => array(
            'smtp_host' => '',
            'smtp_port' => 465,
            'username' => '',
            'password' => '',
            'use_ssl' => 1,
        )
    );

    /**
     * 分组名称
     *
     * @return mixed
     */
    function getGroupName()
    {
        return 'site';
    }

    /**
     * 获取配置页所需数据
     *
     * @param array $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function get($data = array())
    {
        $modeName = array();
        $contentMode = $this->CONFIG->getAllConfig('mode');
        if (!empty($contentMode)) {
            $contentMode = $contentMode['mode'];
        } else {
            $contentMode = ModeManager::$defaultMode;
        }

        $map = array_flip(BaseModule::$typeMap);
        foreach ($contentMode as $name => $config) {
            $modeName[$map[$name]] = $config['name'];
        }

        $result['config'] = $this->getSiteConfig($data);
        $result['modeName'] = $modeName;

        return $result;
    }

    /**
     * 保存数据
     *
     * @param $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function save($data)
    {
        $checkboxList = array(
            'rewrite', 'invite', 'verify'
        );

        foreach ($checkboxList as $checkbox) {
            if (!isset($data[$checkbox])) {
                $data[$checkbox] = 0;
            } else {
                $data[$checkbox] = 1;
            }
        }

        if(!empty($data['smtp']) && !empty($data['smtp']['use_ssl'])) {
            $data['smtp']['use_ssl'] = 1;
        } else {
            $data['smtp']['use_ssl'] = 0;
        }

        return $this->CONFIG->saveConfig($data, $this->groupName);
    }

    /**
     * 初始化
     *
     * @param array $data
     * @param bool $support_rewrite
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function initSiteConfig(&$data = array(), $support_rewrite = false)
    {
        $data = $this->defaultConfig;
        $data['encrypt']['uri'] = Helper::random(16);
        $data['encrypt']['auth'] = Helper::random(16);

        $data['rewrite'] = (int)$support_rewrite;

        $homepage = Request::getInstance()->getHostInfo() . trim(dirname(dirname($_SERVER['PHP_SELF'])), '\\');
        $data['site_homepage'] = rtrim($homepage, '/') . '/';

        return $this->save($data);
    }

    /**
     * 获取网站配置
     *
     * @param $siteConfig
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    private function getSiteConfig($siteConfig)
    {
        if (empty($siteConfig)) {
            $this->initSiteConfig($siteConfig);
        } else {
            $siteConfig = $this->CONFIG->getAllConfig('site');
        }

        return $siteConfig;
    }
}