<?php
/**
 * @author wonli <wonli@live.com>
 */

namespace app\admin\supervise;

use Cross\MVC\Module;

/**
 * cpa基类
 *
 * @author wonli <wonli@live.com>
 * Class AdminModule
 * @package modules\admin
 */
class AdminModule extends Module
{
    /**
     * 管理员表
     *
     * @var string
     */
    protected $t_admin = 'admin';

    /**
     * 角色表名
     *
     * @var string
     */
    protected $t_role = 'acl_role';

    /**
     * 操作日志
     *
     * @var string
     */
    protected $t_act_log = 'act_log';

    /**
     * 权限表
     *
     * @var string
     */
    protected $t_acl_menu = 'acl_menu';

    /**
     * 存储密保卡的表名
     *
     * @var string
     */
    protected $t_security_card = 'security_card';

    /**
     * AdminModule constructor.
     * @throws \Cross\Exception\CoreException
     */
    function __construct()
    {
        parent::__construct();
        $prefix = $this->getPrefix();

        $this->t_admin = $prefix . $this->t_admin;
        $this->t_role = $prefix . $this->t_role;
        $this->t_act_log = $prefix . $this->t_act_log;
        $this->t_acl_menu = $prefix . $this->t_acl_menu;
        $this->t_security_card = $prefix . $this->t_security_card;
    }
}

