<?php
/**
 * @author wonli <wonli@live.com>
 * index.tpl.php
 */

$logFiles = '{}';
if (!empty($data['logFiles'])) {
    $logFiles = json_encode($data['logFiles']);
}

$pageLess = json_encode(array(
    'totalPages' => 99999999,
    'currentPage' => 1,
    'url' => $this->url('log:read'),
    'loaderImage' => $this->res('images/load_content.gif'),
    'loaderMsg' => '内容加载中',
    'endMsg' => '没有更多了',
    'method' => 'post',
    'params' => array(
        'key' => '',
        'seek' => $data['seek'],
        'fileDir' => $data['file_dir'],
        'fileName' => $data['file_name']
    )
));

?>
<div class="row">
    <div class="col-md-3" style="min-width:300px;">
        <div class="box">
            <div class="box-body" id="tree"></div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="box">
            <div class="box-header with-border">
                <div class="col-md-12" style="padding:10px 0">
                    <div class="box-title">
                        <div id="key"></div>
                    </div>
                </div>

                <div class="col-md-12 col-xs-12 input-group input-group-lg">
                    <?php if (!empty($data['prefix_list'])) : ?>
                        <select id="lunch" class="form-control" style="width: 25%">
                            <?php
                            foreach ($data['prefix_list'] as $prefix) {
                                echo $this->wrap('option')->html($prefix);
                            }
                            ?>
                        </select>
                        <input type="text" id="id" style="width: 75%" class="form-control input-lg"
                               placeholder="搜索日志ID">
                    <?php else : ?>
                        <input type="text" id="id" class="form-control input-lg" placeholder="搜索日志ID">
                    <?php endif ?>

                    <span class="input-group-btn">
                        <button type="button" id="search" class="btn btn-primary btn-flat">
                            <i class="fa fa-search"></i>
                        </button>
                    </span>
                </div>
            </div>
            <div class="box-body" id="logContent">
                <?php
                $startDefaultPageLess = false;
                if (!empty($data['log_content'])) {
                    $startDefaultPageLess = true;
                    foreach ($data['log_content'] as $log) {
                        echo $this->wrap('pre')->html($log);
                    }
                } else {
                    echo '<p><h3 style="color:#eee;padding:50px 0;text-align: center">暂无日志</h3></p>';
                }
                ?>
            </div>
        </div>
    </div>
</div>
<div id="goTop">^</div>
<link rel="stylesheet" href="<?php echo $this->res('css/scrollbar-style.min.css') ?>">
<link rel="stylesheet" href="<?php echo $this->res('libs/bootstrap/tokenfield/css/bootstrap-tokenfield.css') ?>">
<script src="<?php echo $this->res('libs/bootstrap/treeview/bootstrap-treeview.min.js') ?>"></script>
<script src="<?php echo $this->res('libs/bootstrap/tokenfield/bootstrap-tokenfield.min.js') ?>"></script>
<script src="<?php echo $this->res('libs/jquery_pageless/jquery.pageless.js') ?>"></script>
<script>
    $(function () {
        var api = "<?php echo $this->url('log:read') ?>",
            pageLess = <?php echo $pageLess ?>,
            logFileList = <?php echo $logFiles ?>,
            goTop = $('#goTop'),
            logContent = $('#logContent');

        updateTag();

        function updateTag() {
            $('#key').html('<span class="label label-primary">' + pageLess.params.fileDir + '/' + pageLess.params.fileName + '</span>');
        }

        function startPageLess(params) {
            pageLess.totalPages = 99999999;
            pageLess.params = $.extend(pageLess.params, params);

            pageLess.scrape = function (dd) {
                if (typeof dd !== 'object') {
                    dd = $.parseJSON(dd);
                }

                if (dd.status !== 1) {
                    if (dd.status < 0) {
                        layer.msg(dd.message);
                    }

                    return false;
                } else {
                    if (dd.seek === pageLess.params.seek) {
                        layer.msg('没有更多的了');
                        pageLess.totalPages = 0;
                        return false;
                    }

                    pageLess.params.seek = dd.seek;
                    return dd.content;
                }
            };

            logContent.pageless(pageLess);
        }

        function getLogContent(params, spl) {
            $.post(api, params, function (d) {
                if (d.status !== 1) {
                    $('#logContent').html('');
                    layer.msg(d.message);
                } else {
                    pageLess.params.fileDir = d.fileDir;
                    pageLess.params.fileName = d.fileName;

                    updateTag();

                    logContent.html(d.content);
                    if (spl) {
                        params.seek = d.seek;
                        startPageLess(params);
                    }
                }
            })
        }

        <?php if($startDefaultPageLess): ?>
        startPageLess();
        <?php endif ?>

        $('#tree').treeview({
            data: logFileList,
            tags: ['available'],
            showTags: true,
            onNodeSelected: function (event, node) {
                getLogContent({key: '', fileDir: node.p, fileName: node.text}, 1);
            }
        });

        $('#search').on('click', function () {
            getLogContent({key: $('#id').val().trim(), prefix: $('#lunch').val()}, 0);
        });

        $(window).scroll(function () {
            if ($(this).scrollTop() != 0) {
                goTop.fadeIn();
            } else {
                goTop.fadeOut();
            }
        });

        goTop.click(function () {
            $('body, html').animate({
                scrollTop: 0
            }, 0);
        });
    });
</script>