<?php
/**
 * @author wonli <wonli@live.com>
 * site.tpl.php
 */

$modeList = &$data['mode'];
$defaultModeName = &$data['default_mode_name'];
?>

<div class="col-md-6">

    <p>话题模块开关, 影响话题详情页及发现频道</p>

    <table class="table table-bordered">
        <tr>
            <th style="min-width:160px; width:160px;">模块</th>
            <th style="min-width:280px;">模块名称</th>
            <th style="min-width:120px;">功能开关</th>
        </tr>

        <?php foreach ($modeList as $mode => $config) : ?>
            <tr>
                <td><?php echo $mode ?></td>
                <td>
                    <div class="row">
                        <div class="col-md-8">
                            <label for="<?php echo $mode ?>"></label>
                            <input type="hidden" name="default_mode" value="<?php echo $defaultModeName ?>">
                            <input type="text" class="form-control col-md-12" name="<?php echo $mode ?>[name]"
                                   id="<?php echo $mode ?>"
                                   value="<?php echo $config['name'] ?>">
                        </div>
                    </div>
                </td>
                <td>
                    <?php
                    $element_tags = array(
                        'name' => $mode . '[status]',
                        'data-toggle' => 'toggle',
                        'data-on' => '是',
                        'data-off' => '否',
                        'data-size' => 'small'
                    );

                    $label = array();
                    $label['class'] = 'checkbox-inline';
                    if ($mode == $defaultModeName) {
                        $element_tags['checked'] = true;
                        $element_tags['data-onstyle'] = 'success';
                        $element_tags['disabled'] = true;
                        $label['onclick'] = "layer.msg('不能关闭默认模型')";
                    } elseif ($config['status']) {
                        $element_tags['checked'] = 'checked';
                    }

                    echo $this->wrap('label', $label)->input('checkbox', $element_tags);
                    ?>
                </td>
            </tr>
        <?php endforeach ?>
    </table>
</div>

<div class="box-footer" style="clear: both">
    <button class="btn btn-primary">提交</button>
</div>
