<?php
/**
 * @author wonli <wonli@live.com>
 * site.tpl.php
 */
$config = &$data['config'];
$mode_options = &$data['modeName'];

$smtp = &$config['smtp'];
$smtp_use_ssl = &$smtp['use_ssl'];

$invite = &$config['invite'];
$verify = &$config['verify'];
$rewrite = &$config['rewrite'];
$encrypt = &$config['encrypt'];
?>

<table class="table table-bordered">
    <tr>
        <th style="width:260px;">配置项</th>
        <th style="min-width:480px;">
            <div class="row">
                <div class="col-md-12">值</div>
            </div>
        </th>
    </tr>

    <tr>
        <td colspan="2" class="title">基础配置</td>
    </tr>

    <tr>
        <td class="control-label">网站名称</td>
        <td>
            <div class="row">
                <div class="col-md-5">
                    <input type="text" class="form-control col-md-3" name="site_name"
                           value="<?php echo $this->e($config, 'site_name') ?>">
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td class="control-label">一句话介绍</td>
        <td>
            <div class="row">
                <div class="col-md-5">
                    <input type="text" class="form-control col-md-3" name="introduce"
                           value="<?php echo $this->e($config, 'introduce') ?>">
                </div>
                <div class="col-md-5 tips">
                    出现在登录和注册页面
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td class="control-label">前台访问路径</td>
        <td>
            <div class="row">
                <div class="col-md-5">
                    <input type="text" class="form-control col-md-3" name="site_homepage"
                           value="<?php echo $this->e($config, 'site_homepage') ?>">
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td class="control-label">默认标题(title)</td>
        <td>
            <div class="row">
                <div class="col-md-5">
                    <input type="text" class="form-control col-md-3" name="title"
                           value="<?php echo $this->e($config, 'title') ?>">
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td class="control-label">默认关键词(keywords)</td>
        <td>
            <div class="row">
                <div class="col-md-8">
                    <input type="text" class="form-control col-md-3" name="keywords"
                           value="<?php echo $this->e($config, 'keywords') ?>">
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td class="control-label">默认描述(description)</td>
        <td>
            <div class="row">
                <div class="col-md-8">
                    <input type="text" class="form-control col-md-3" name="description"
                           value="<?php echo $this->e($config, 'description') ?>">
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td colspan="2" class="title">REWRITE</td>
    </tr>

    <tr>
        <td>服务器是否支持rewrite</td>
        <td>
            <div class="row">
                <div class="col-md-1">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="rewrite" data-toggle="toggle" data-on="是" data-off="否"
                               data-size="small" <?php if ($rewrite) echo 'checked' ?>>
                    </label>
                </div>
                <div class="col-md-10 tips">
                    请确认服务器支持rewrite后再开启此配置
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td colspan="2" class="title">模式设置</td>
    </tr>

    <tr>
        <td>发现频道及话题默认模型</td>
        <td>
            <div class="row">
                <div class="col-md-3">
                    <?php echo $this->select($mode_options, $config['default_mode'], array(
                        'class' => 'form-control',
                        'name' => 'default_mode'
                    ))
                    ?>
                </div>
                <div class="col-md-9 tips">
                    指定默认模型, 影响发现频道及话题首页
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td colspan="2" class="title">默认模板</td>
    </tr>

    <tr>
        <td>默认模板</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <input type="text" class="form-control col-md-3" name="tpl_dir"
                           value="<?php echo $this->e($config, 'tpl_dir', 'default') ?>">
                </div>
                <div class="col-md-10 tips">
                    默认模板路径
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td colspan="2" class="title">邀请注册</td>
    </tr>

    <tr>
        <td>是否开启邀请注册</td>
        <td>
            <div class="row">
                <div class="col-md-1">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="invite" data-toggle="toggle" data-on="是" data-off="否"
                               data-size="small" <?php if ($invite) echo 'checked' ?>>
                    </label>
                </div>
                <div class="col-md-10 tips">
                    开启以后需要输入邀请码才能注册
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td colspan="2" class="title">内容审核</td>
    </tr>

    <tr>
        <td>是否开启内容审核</td>
        <td>
            <div class="row">
                <div class="col-md-1">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="verify" data-toggle="toggle" data-on="是" data-off="否"
                               data-size="small" <?php if ($verify) echo 'checked' ?>>
                    </label>
                </div>
                <div class="col-md-10 tips">
                    开启发布主题需要先审核(论坛编辑除外)
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td colspan="2" class="title">加密参数(留空时随机生成)</td>
    </tr>

    <tr>
        <td class="control-label">uri(加密key)</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <input type="text" class="form-control col-md-3" name="encrypt[uri]"
                           value="<?php echo $this->e($encrypt, 'uri') ?>">
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <td class="control-label">COOKIE加密key</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <input type="text" class="form-control col-md-3" name="encrypt[auth]"
                           value="<?php echo $this->e($encrypt, 'auth') ?>">
                </div>
                <div class="col-md-10 tips">
                    更改后已登录用户需重新登录
                </div>
            </div>
        </td>
    </tr>

    <tr>
        <td colspan="2" class="title">邮件服务器</td>
    </tr>

    <tr>
        <td class="control-label">SMTP服务器地址</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <input type="text" class="form-control col-md-3" name="smtp[smtp_host]"
                           value="<?php echo $this->e($smtp, 'smtp_host') ?>">
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <td class="control-label">SMTP服务器端口</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <input type="text" class="form-control col-md-3" name="smtp[smtp_port]"
                           value="<?php echo $this->e($smtp, 'smtp_port') ?>">
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <td class="control-label">SMTP用户名</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <input type="text" class="form-control col-md-3" name="smtp[username]"
                           value="<?php echo $this->e($smtp, 'username') ?>">
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <td class="control-label">SMTP密码</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <input type="text" class="form-control col-md-3" name="smtp[password]"
                           value="<?php echo $this->e($smtp, 'password') ?>">
                </div>
            </div>
        </td>
    </tr>
    <tr>
        <td class="control-label">是否使用SSL</td>
        <td>
            <div class="row">
                <div class="col-md-2">
                    <label class="checkbox-inline">
                        <input type="checkbox" name="smtp[use_ssl]" data-toggle="toggle" data-on="是" data-off="否"
                               data-size="small" <?php if ($smtp_use_ssl) echo 'checked' ?>>
                    </label>
                </div>
            </div>
        </td>
    </tr>
</table>


<div class="box-footer">
    <button class="btn btn-primary">提交</button>
</div>
