<?php
/**
 * @author wonli <wonli@live.com>
 * ForumView.php
 */

namespace app\admin\views;


use lib\XSS\Filter;

class ForumView extends AdminView
{
    /**
     * @var array
     */
    protected $siteConfig;

    /**
     * @param $siteConfig
     */
    function setSiteConfig($siteConfig)
    {
        $this->siteConfig = $siteConfig;
    }

    /**
     * 输出主站资源路径
     *
     * @param $src
     * @return string
     */
    function getResource($src)
    {
        if (substr($src, 0, 2) == '//' || substr($src, 0, 4) == 'http') {
            return $src;
        }

        return sprintf('%s/static/%s', rtrim($this->siteConfig['site_homepage'], '/'), $src);
    }

    /**
     * 文本中的图片转换为超链接
     *
     * @param string $txt
     * @param string $lightbox_flag
     * @return mixed
     */
    function imagesToLink($txt, $lightbox_flag = '')
    {
        $that = &$this;
        $txt = preg_replace_callback('~<img.*(src="(.*?)"|data-original="(.*?)").*>~i', function (&$match) use ($that, $lightbox_flag) {
            if (!empty($match[3])) {
                $imageUrl = $match[3];
            } else {
                $imageUrl = $match[2];
            }

            return $that->a('[图片]', $imageUrl, array('target' => '_blank', 'data-lightbox' => $lightbox_flag));
        }, $txt);

        $f = new Filter();
        $f->addAllowedTags('a');
        return $f->xss($txt);
    }

    /**
     * 将数组保存为一个文件
     *
     * @param string $file_name
     * @param array $data
     */
    function saveArrayToFile($file_name, array $data)
    {
        $content = $this->obRenderTpl('config/array_config', $data);
        file_put_contents($file_name, $content, LOCK_EX);
    }

    /**
     * @param string $msg
     */
    function alert($msg)
    {
        $this->renderTpl('common/alert', array('msg' => $msg));
    }
}
