<?php
/**
 * @author wonli <wonli@live.com>
 * SettingsView.php
 */

namespace app\admin\views;

/**
 * @author wonli <wonli@live.com>
 * Class SettingsView
 * @package app\admin\views
 */
class SettingsView extends ForumView
{
    /**
     * 网站设置
     *
     * @param $data
     */
    function index($data)
    {
        $this->renderTpl('settings/index', $data);
    }

    /**
     * 搜索引擎优化
     *
     * @param $data
     */
    function seo($data)
    {
        $this->renderTpl('settings/seo', $data);
    }

    /**
     * 所有邀请码
     *
     * @param $data
     */
    function inviteCode($data = array())
    {
        $this->renderTpl('settings/invite_code', $data);
    }

    /**
     * @param array $data
     */
    function friendsLink($data = array())
    {
        $this->renderTpl('settings/friendsLink', $data);
    }

    /**
     * 刷新seo缓存配置文件
     *
     * @param array $data
     */
    function updateSeoConfig($data)
    {
        $content = $this->obRenderTpl('settings/seo_config', $data);
        $cache_file = $this->getFilePath('config/seo.config.php');

        file_put_contents($cache_file, $content, LOCK_EX);
    }
}
