<?php
/**
 * @author wonli <wonli@live.com>
 * TabView.php
 */

namespace app\admin\views;


use Cross\MVC\View;

/**
 * 输出Tab视图
 *
 * @author wonli <wonli@live.com>
 * Class TabView
 * @package app\admin\views
 */
class TabView extends View
{
    private $tab = array();
    private $currentTabName = '';

    /**
     * 添加标签
     *
     * @param string $tabName
     * @param array $tabConfig 包含[title => 标题, tpl => 数据模版 data => 数据]
     * @return $this
     */
    function addTab($tabName, $tabConfig)
    {
        if (empty($this->tab)) {
            $this->currentTabName = $tabName;
        }

        $this->tab[$tabName] = $tabConfig;
        return $this;
    }

    /**
     * 输出Tab视图
     */
    function render()
    {
        ?>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                <?php $this->tabNav() ?>
            </ul>
            <div class="tab-content">
                <?php $this->tabContent() ?>
            </div>
        </div>
        <?php
    }

    /**
     * 输出Tab导航条
     */
    private function tabNav()
    {
        foreach ($this->tab as $n => $d) {
            if ($n == $this->currentTabName) {
                $class = 'active';
            } else {
                $class = '';
            }
            ?>
            <li class="<?php echo $class ?>">
                <a href="#<?php echo $n ?>" data-toggle="tab" aria-expanded="true">
                    <?php echo $d['title'] ?>
                </a>
            </li>
            <?php
        }
    }

    /**
     * 输出Tab内容块
     */
    private function tabContent()
    {
        foreach ($this->tab as $n => $d) {
            if ($n == $this->currentTabName) {
                $class = 'tab-pane active';
            } else {
                $class = 'tab-pane';
            }

            ?>
            <div class="<?php echo $class ?>" id="<?php echo $n ?>">
                <?php $this->renderTpl($d['tpl'], $d['data']) ?>
            </div>
            <?php
        }
    }
}
