<?php
/**
 * @author wonli <wonli@live.com>
 * Explore.php
 */

namespace app\forum\controllers;

use app\forum\modules\content\SideModule;
use app\forum\modules\title\TitleModule;

/**
 * 发现
 *
 * @author wonli <wonli@live.com>
 * Class Explore
 * @package app\forum\controllers
 */
class Explore extends Forum
{

    /**
     * 发现首页
     *
     * @cp_params type, order=time, p=1
     * @throws \Cross\Exception\CoreException
     */
    function index()
    {
        $type = $this->params['type'];
        if (empty($type)) {
            $type = $this->siteConfig->get('defaultModeName');
        }

        $mode = $this->isAvailableMode($type);
        if (!$mode) {
            $this->to('explore');
        }

        $order = $this->params['order'];
        $page = array(
            'p' => (int)$this->params['p'],
            'limit' => 50,
            'half' => 5,
            'link' => array('explore', array('type' => $type, 'order' => $order))
        );

        $TITLE = new TitleModule();
        $content_list = $TITLE->contentList($mode, $page, $order);

        $this->data['mode'] = $mode;
        $this->data['page'] = $page;
        $this->data['type'] = $type;
        $this->data['order'] = $order;
        $this->data['mode_name'] = $this->modeName[$type];
        $this->data['content_list'] = $content_list;

        if ($this->is_ajax_request()) {
            $fragment_type = 'explore/single';
            $this->view->contentListSection($content_list, $fragment_type);
        } else {
            $SM = new SideModule($type);
            $this->data['side_data'] = $SM->getData();

            $this->display($this->data);
        }
    }
}
