<?php
/**
 * @author wonli <wonli@live.com>
 * Info.php
 */


namespace app\forum\controllers;

use app\forum\modules\common\InfoModule;

/**
 * Class Info
 * @package app\forum\controllers
 */
class Info extends Forum
{

    /**
     * 文章列表
     *
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function index()
    {
        $this->detail();
        $this->display($this->data, 'detail');
    }

    /**
     * @param $name
     * @param $arguments
     * @throws \Cross\Exception\CoreException
     */
    function __call($name, $arguments)
    {
        $name = htmlentities(strip_tags(urldecode($name)));
        $this->detail($name);
        $this->display($this->data, 'detail');
    }

    /**
     * 获取数据
     *
     * @param string $name
     * @throws \Cross\Exception\CoreException
     */
    private function detail($name = '')
    {
        $IM = new InfoModule();
        $info = $IM->getAll('link_url, link_name', array('is_absolute_link' => 0));
        if (empty($info)) {
            $this->to();
        }

        if ('' == $name) {
            $name = &$info[0]['link_url'];
        }

        $title = $content = '';
        if (!empty($name)) {
            $data = $IM->getContentFromLinkUrl($name);
            if (!$data) {
                $this->to('info');
            }

            $title = $data['link_name'];
            $content = nl2br($data['content']);
        }

        $this->data['info'] = $info;
        $this->data['current'] = $name;

        $this->data['title'] = $title;
        $this->data['content'] = $content;
    }
}