<?php
/**
 * @author wonli <wonli@live.com>
 * Send.php
 */

namespace app\forum\controllers;

use app\forum\modules\common\SendEmailModule;
use app\forum\modules\account\AccountModule;
use Cross\Core\Helper;

/**
 * 发送邮件或手机验证码
 *
 * @author wonli <wonli@live.com>
 * Class Send
 * @package app\forum\controllers
 */
class Send extends Forum
{
    /**
     * 邮件发送间隔时间
     *
     * @var int
     */
    private $send_time_interval = 1800;

    /**
     * @return mixed
     */
    function index()
    {

    }

    /**
     * 发送邮件
     *
     * @cp_params type=validate
     */
    function email()
    {
        if ($this->is_post() && $this->is_ajax_request()) {

            $type = $this->params['type'];
            switch ($type) {
                case 'validate':
                    $this->validate();
                    break;

                case 'resetPassword':
                    $this->resetPassword();
                    break;

                default:
            }

        } else {
            $this->to();
        }
    }

    /**
     * 重置密码
     *
     * @throws \Cross\Exception\CoreException
     * @throws \phpmailerException
     */
    protected function resetPassword()
    {
        $account = &$_POST['account'];
        $AM = new AccountModule();
        $account_info = $AM->getAccountInfo(trim($account), 'uid, email, cellphone_number, validate, nickname');
        if (empty($account_info)) {
            $this->data['status'] = 200401;
            $this->displayJSON($this->data);
        }

        $validate_status = $AM->validateStatus($account_info['validate']);
        if ($validate_status['validate_email']) {
            //限制邮件发送频率(30分钟)
            $validateInfo = $AM->getUserValidateInfo($account_info['uid'], AccountModule::VALIDATE_RESET_PASSWORD);
            if ($validateInfo && TIME - $validateInfo['send_time'] < $this->send_time_interval) {
                $this->data['status'] = 200347;
                $this->displayJSON($this->data);
            }

            $validate_data = json_encode(array('type' => 'email', 'uid' => $account_info['uid'], 'nickname' => $account_info['nickname']));
            if ($validateInfo) {
                $validate_id = &$validateInfo['id'];
                $code = AccountModule::genValidateCode(AccountModule::VALIDATE_RESET_PASSWORD);
            } else {
                //生成校验信息,获取校验信息ID和校验码
                $validate_id = $AM->makeValidateCode($account_info['uid'], AccountModule::VALIDATE_RESET_PASSWORD, $validate_data, $code);
            }

            $validate_string = "{$validate_id}|{$code}";
            $validate_params = Helper::encodeParams($validate_string, $this->config->get('encrypt', 'uri'));
            $this->data['validate_url_params'] = $validate_params;
            $this->data['account_info'] = $account_info;

            //发送邮件
            $SEM = new SendEmailModule();
            $content = $this->view->renderResetPasswordTemplate($this->data);

            $send = $SEM->send($account_info['email'], '重置密码', $content);
            if ($send) {
                $this->data['status'] = 200345;
                $AM->updateValidateInfo($validate_id, array('code' => $code, 'send_time' => TIME, 'data' => $validate_data));
            } else {
                $this->data['status'] = 200346;
            }

            $this->displayJSON($this->data);
        } elseif ($validate_status['validate_cellphone']) {
            //短信验证
            $this->data['status'] = 200360;
        } else {
            $this->data['status'] = 200364;
        }

        $this->displayJSON($this->data);
    }

    /**
     * 邮箱验证
     */
    protected function validate()
    {
        if (!$this->isLogin) {
            $this->data['status'] = 200010;
            $this->displayJSON($this->data);
        }

        $email = &$_POST['email'];
        $email = trim($email);
        if (empty($email) || !Helper::validEmail($email)) {
            $this->data['status'] = 200306;
            $this->displayJSON($this->data);
        }

        $AM = new AccountModule();
        $validateAccount = array();
        //使用该邮箱的帐号列表
        $accountList = $AM->getAllAccountInfoByCondition(array('email' => $email), 'uid, validate');
        if (!empty($accountList)) {
            foreach ($accountList as $account) {
                $validateStatus = $AM->validateStatus($account['validate']);
                if ($validateStatus['validate_email']) {
                    $validateAccount = &$account;
                    break;
                }
            }

            if (!empty($validateAccount)) {
                if ($validateAccount['uid'] != $this->uid) {
                    //被占用
                    $this->data['status'] = 200340;
                    $this->displayJSON($this->data);
                } else {
                    //已认证
                    $this->data['status'] = 200344;
                    $this->displayJSON($this->data);
                }
            }
        }

        //限制邮件发送频率(30分钟)
        $validateInfo = $AM->getUserValidateInfo($this->uid, AccountModule::VALIDATE_EMAIL);
        if ($validateInfo && TIME - $validateInfo['send_time'] < $this->send_time_interval) {
            $this->data['status'] = 200347;
            $this->displayJSON($this->data);
        }

        if ($validateInfo) {
            $validate_id = &$validateInfo['id'];
            $code = AccountModule::genValidateCode(AccountModule::VALIDATE_EMAIL);
        } else {
            //生成校验信息,获取校验信息ID和校验码
            $validate_id = $AM->makeValidateCode($this->uid, AccountModule::VALIDATE_EMAIL, $email, $code);
        }

        //待加密的验证字符串
        $validate_string = json_encode(array(
            'i' => $validate_id, //验证信息ID
            'c' => $code //随机字符串
        ));

        $validate_data = Helper::encodeParams($validate_string, $this->config->get('encrypt', 'uri'));
        $this->data['validate_url_params'] = $validate_data;

        //调用视图控制器处理邮件模板
        $content = $this->view->renderValidateEmailTemplate($this->data);

        $SEM = new SendEmailModule();
        $send = $SEM->send($email, '邮箱验证', $content);
        if ($send) {
            $this->data['status'] = 200345;
            //更新发送时间
            $AM->updateValidateInfo($validate_id, array('code' => $code, 'data' => $email, 'send_time' => TIME));
        } else {
            $this->data['status'] = 200346;
        }

        $this->displayJSON($this->data);
    }
}
