<?php
/**
 * @author wonli <wonli@live.com>
 * Verify.php
 */

namespace app\forum\controllers;

use app\forum\modules\account\AccountModule;
use Cross\Core\Helper;

/**
 * 邮箱或手机验证
 *
 * @author wonli <wonli@live.com>
 * Class Verify
 * @package app\forum\controllers
 */
class Verify extends WantLogin
{
    /**
     * @return mixed
     */
    function index()
    {

    }

    /**
     * 验证邮箱
     *
     * @cp_params code
     */
    function email()
    {
        $code = &$this->params['code'];
        if (empty($code)) {
            $this->to();
        }

        $this->data['success'] = false;
        $data = Helper::encodeParams($code, $this->config->get('encrypt', 'uri'), 'decode');
        if (empty($data) || false === ($info = json_decode($data, true))) {
            $this->alertMessage(200341);
            $this->display($this->data);
        } else {
            $AM = new AccountModule();
            $validate_info = $AM->getValidateInfo($info['i']);
            if (empty($validate_info)) {
                $this->alertMessage(200342);
                $this->displayOver($this->data);
            }

            //基础数据校验
            if ($validate_info['uid'] != $this->uid || $validate_info['code'] != $info['c']) {
                $this->alertMessage(200342);
                $this->displayOver($this->data);
            }

            //已过期
            if (TIME - $validate_info['send_time'] > 86400) {
                $this->alertMessage(200351);
                $this->displayOver($this->data);
            }

            $validated_account_info = array();
            $email_account_list = $AM->getAllAccountInfoByCondition(array('email' => $validate_info['data']), 'uid, validate');
            if (!empty($email_account_list)) {
                foreach ($email_account_list as $account) {
                    $account_validate = $AM->validateStatus($account['validate']);
                    if ($account_validate['validate_email']) {
                        $validated_account_info = $account;
                        break;
                    }
                }
            }

            //邮箱已经被使用了
            if (!empty($validated_account_info)) {
                if ($validated_account_info['uid'] == $this->uid) {
                    $this->alertMessage(200344);
                } else {
                    $this->alertMessage(200340);
                }
            } else {
                $validate_status = $AM->validate($this->uid, $validate_info['id']);
                if ($validate_status) {
                    $this->data['success'] = true;
                    $this->alertMessage(200350, 'success');
                } else {
                    $this->alertMessage(200348);
                }
            }

            $this->displayOver($this->data);
        }
    }
}
