<?php
/**
 * @author wonli <wonli@live.com>
 * WantLogin.php
 */

namespace app\forum\controllers;

use app\forum\modules\account\AccountModule;
use Cross\Core\Helper;

/**
 * 验证登录权限
 *
 * @author wonli <wonli@live.com>
 * Class WantLogin
 * @package app\forum\controllers
 */
class WantLogin extends Forum
{
    /**
     * WantLogin constructor.
     * @throws \Cross\Exception\CoreException
     */
    function __construct()
    {
        parent::__construct();
        if (!$this->isLogin) {
            if ($this->is_ajax_request()) {
                $this->data['status'] = 200010;
                $this->display($this->data, 'JSON');
            } else {
                $back_url = Helper::encodeParams($this->request->getCurrentUrl(false), 's');
                $this->to('user:login', array('back' => $back_url));
            }
        } else {
            $AM = new AccountModule();
            $status = $AM->getUserStatus($this->uid);
            if (false === $status || $status == AccountModule::STATUS_BAN) {

                if ($this->is_ajax_request()) {
                    $this->data['status'] = 200330;
                    $this->display($this->data, 'JSON');
                } else {
                    $this->setAuth('u', null, -1);
                    $this->to('user:login');
                }

            } elseif ($status == AccountModule::STATUS_UNFINISHED) {
                if ($this->controller != 'Guide' && $this->controller != 'platform_register') {
                    $this->to('guide:platform_register');
                }
            }
        }
    }

    /**
     * @return mixed
     */
    function index()
    {

    }
}
