<?php
/**
 * @author wonli <wonli@live.com>
 * InfoModule.php
 */


namespace app\forum\modules\common;

use Cross\Core\Loader;

/**
 * Class InfoModule
 * @package app\forum\modules\common
 */
class InfoModule extends BaseModule
{
    /**
     * 获取文章列表
     *
     * @param string $fields
     * @param array $condition
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function getAll($fields = '*', $condition = array())
    {
        return $this->link->getAll($this->info, $fields, $condition, 'sort ASC');
    }

    /**
     * 根据URL连接获取内容
     *
     * @param string $link_url
     * @param string $fields
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function getContentFromLinkUrl($link_url, $fields = '*')
    {
        return $this->link->get($this->info, $fields, array(
            'link_url' => $link_url
        ));
    }

    /**
     * 获取信息内容
     *
     * @param int $id
     * @param string $fields
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function getInfoContent($id, $fields = '*')
    {
        return $this->link->get($this->info, $fields, array(
            'id' => (int)$id
        ));
    }

    /**
     * 保存页面底部文档数据
     *
     * @throws \Cross\Exception\CoreException
     */
    function updateNailData()
    {
        $nailData = $this->getAll('*', array('nail_footer' => 1));
        $nailData = json_encode($nailData);
        $file = $this->getFilePath('config::nail.config.json');
        file_put_contents($file, $nailData);
    }

    /**
     * 返回页面底部文档数据
     *
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function getNailData()
    {
        $file = $this->getFilePath('config::nail.config.json');
        if (file_exists($file)) {
            return Loader::read($file);
        }

        return array();
    }

    /**
     * 更新
     *
     * @param int $id
     * @param array $data
     * @return bool
     * @throws \Cross\Exception\CoreException
     */
    function update($id, $data)
    {
        $data['is_absolute_link'] = (int)$this->isAbsoluteLink($data['link_url']);
        return $this->link->update($this->info, $data, array(
            'id' => (int)$id
        ));
    }

    /**
     * 添加文章
     *
     * @param array $data
     * @return bool|mixed
     * @throws \Cross\Exception\CoreException
     */
    function add($data)
    {
        $data['is_absolute_link'] = (int)$this->isAbsoluteLink($data['link_url']);
        return $this->link->add($this->info, $data);
    }

    /**
     * 按id删除文章
     *
     * @param int $id
     * @return bool
     * @throws \Cross\Exception\CoreException
     */
    function del($id)
    {
        return $this->link->del($this->info, array(
            'id' => (int)$id
        ));
    }

    /**
     * 判断是否是一个绝对链接
     *
     * @param string $url
     * @return bool
     */
    private function isAbsoluteLink($url)
    {
        $url_info = parse_url($url);
        if (isset($url_info['host'])) {
            return true;
        } else {
            return false;
        }
    }
}