<?php
/**
 * @author wonli <wonli@live.com>
 * SendEmailModule.php
 */

namespace app\forum\modules\common;

use Cross\Core\Config;
use Cross\Core\Loader;
use PHPMailer;

/**
 * 发送邮件
 *
 * @author wonli <wonli@live.com>
 * Class SendEmailModule
 * @package app\forum\modules\common
 */
class SendEmailModule
{
    public $debug = false;

    /**
     * SendEmailModule constructor.
     *
     * @throws \Cross\Exception\CoreException
     */
    function __construct()
    {
        Loader::import('lib/PHPMailer-5.2.23/PHPMailerAutoload.php');
    }

    /**
     * 发送邮件到指定邮箱
     *
     * @param string $to 接受者
     * @param string $subject 邮件标题
     * @param string $content 邮件内容
     * @return bool
     * @throws \Cross\Exception\CoreException
     * @throws \phpmailerException
     */
    function send($to, $subject, $content)
    {
        $config = Config::load(PROJECT_REAL_PATH . 'config/site.config.php');
        $SMTPServerConfig = $config->get('smtp');

        $client = new PHPMailer();
        $client->isSMTP();

        if ($this->debug) {
            $client->SMTPDebug = 2;
            $client->Debugoutput = 'html';
        }

        $client->Host = &$SMTPServerConfig['smtp_host'];
        $client->Port = &$SMTPServerConfig['smtp_port'];

        //是否使用SSL
        if ($SMTPServerConfig['use_ssl']) {
            $client->SMTPSecure = 'ssl';
        }

        $client->SMTPAuth = true;
        $client->CharSet = 'utf-8';
        $client->isHTML();
        $client->Username = &$SMTPServerConfig['username'];
        $client->Password = &$SMTPServerConfig['password'];

        $client->setFrom($SMTPServerConfig['username'], $config->get('site_name'));
        $client->addAddress($to);
        $client->Subject = $subject;
        $client->msgHTML($content);

        if (!$client->send()) {
            return false;
        }
        return true;
    }

}
