<?php
/**
 * @author wonli <wonli@live.com>
 * SideModule.php
 */


namespace app\forum\modules\content;

use app\forum\modules\topic\TopicModule;

/**
 * 侧边栏数据管理
 * @author wonli <wonli@live.com>
 *
 * Class SideModule
 * @package app\forum\modules\content
 */
class SideModule extends ContentModule
{
    /**
     * @var string
     */
    protected $type;

    /**
     * SideModule constructor.
     *
     * @param $type
     * @throws \Cross\Exception\CoreException
     */
    function __construct($type)
    {
        parent::__construct();
        $this->type = $type;
    }

    /**
     * @return array
     * @throws \Cross\Exception\CoreException
     */
    function getData()
    {
        $data = array();
        switch ($this->type) {
            case 'question':
                $data = $this->getQuestionSideData();
                break;

            case 'article':
                $data = $this->getArticleSideData();
                break;
        }

        return $data;
    }

    /**
     * 推荐话题及答案点赞最多的前10个用户
     *
     * @return array
     * @throws \Cross\Exception\CoreException
     */
    private function getQuestionSideData()
    {
        $TOPIC = new TopicModule();
        $data['recommend_topic'] = $TOPIC->getRecommendTopicNewTopic(5);

        $QUESTION = new QuestionModule();
        $data['best_answer_user'] = $QUESTION->getBestAnswerUser(10);

        return $data;
    }

    /**
     * 热评文章列表
     *
     * @throws \Cross\Exception\CoreException
     */
    private function getArticleSideData()
    {
        $AM = new ArticleModule();
        $data['hot_comment'] = $AM->getHotCommentArticle(10);
        $data['hot_author'] = $AM->getHotAuthorList(10);

        return $data;
    }
}