<?php

namespace app\forum\modules\friendsLink;

use app\forum\modules\common\BaseModule;

/**
 * @author wonli <wonli@live.com>
 * FriendsLinkModule.php
 */
class FriendsLinkModule extends BaseModule
{
    /**
     * 获取友链列表
     *
     * @param array $page
     * @param array $condition
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function find(&$page = array('p' => 1, 'limit' => 20), $condition = array())
    {
        return $this->link->find($this->friendsLink, '*', $condition, "sort ASC", $page);
    }

    /**
     * 更新
     *
     * @param int $id
     * @param array $data
     * @return bool
     * @throws \Cross\Exception\CoreException
     */
    function update($id, $data)
    {
        return $this->link->update($this->friendsLink, $data, array(
            'id' => (int)$id
        ));
    }

    /**
     * 添加链接
     *
     * @param array $data
     * @return bool|mixed
     * @throws \Cross\Exception\CoreException
     */
    function add(array $data)
    {
        return $this->link->add($this->friendsLink, $data);
    }

    /**
     * 按id删除友链
     *
     * @param int $id
     * @return bool
     * @throws \Cross\Exception\CoreException
     */
    function del($id)
    {
        return $this->link->del($this->friendsLink, array(
            'id' => (int) $id
        ));
    }
}
