<?php
/**
 * @author wonli <wonli@live.com>
 * ExploreView.php
 */

namespace app\forum\views;


/**
 * 发现视图控制器
 *
 * @author wonli <wonli@live.com>
 * Class ExploreView
 * @package app\forum\views
 */
class ExploreView extends ForumView
{
    /**
     * 发现首页
     *
     * @param array $data
     */
    function index($data = array())
    {
        $data['explore_panel_class'] = 'panel-explore-' . $data['type'];
        $this->renderTpl("explore/{$data['type']}", $data);
    }

    /**
     * 发现内容导航
     */
    function categoryNavigation()
    {
        $validModeCount = count($this->modeName);
        if ($validModeCount > 1) {
            $menu_config = array();
            $current_type = &$this->data['type'];

            foreach ($this->modeName as $type => $type_name) {
                $is_current = 0;
                if ($type == $current_type) {
                    $is_current = 1;
                }

                $menu_config[] = array(
                    'type_name' => $type,
                    'is_current' => $is_current,
                    'name' => $type_name,
                );
            }

            $this->renderTpl('explore/category_navigation', array(
                'grid_split' => 12 / $validModeCount,
                'menu_config' => $menu_config
            ));
        }
    }
}
