<?php
/**
 * @author wonli <wonli@live.com>
 * SendView.php
 */

namespace app\forum\views;

/**
 * @author wonli <wonli@live.com>
 * Class SendView
 * @package app\forum\views
 */
class SendView extends ForumView
{
    /**
     * 处理邮件模板
     *
     * @param array $data
     * @return int
     * @throws \Cross\Exception\CoreException
     */
    function renderValidateEmailTemplate($data = array())
    {
        $siteConfig = $this->siteConfig->getAll();
        $tplData = array(
            'validate_url' => $this->url('verify:email', array('code' => $data['validate_url_params'])),
            'site_name' => &$siteConfig['site_name'],
            'site_homepage' => &$siteConfig['site_homepage'],
            'introduce' => &$siteConfig['introduce'],
            'username' => $data['loginUser']['nickname']
        );

        return $this->obRenderTpl("fragment/email/validate", $tplData);
    }

    /**
     * 处理重置密码邮件
     *
     * @param array $data
     * @return string
     * @throws \Cross\Exception\CoreException
     */
    function renderResetPasswordTemplate($data = array())
    {
        $siteConfig = $this->siteConfig->getAll();
        $tplData = array(
            'action_url' => $this->url('user:resetPassword', array('code' => $data['validate_url_params'])),
            'site_name' => &$siteConfig['site_name'],
            'site_homepage' => &$siteConfig['site_homepage'],
            'introduce' => &$siteConfig['introduce'],
            'username' => $data['account_info']['nickname']
        );

        return $this->obRenderTpl("fragment/email/reset_password", $tplData);
    }
}
