<?php
/**
 * @author wonli <wonli@live.com>
 * TopicsView.php
 */

namespace app\forum\views;

/**
 * 话题视图控制器
 *
 * @author wonli <wonli@live.com>
 * Class TopicsView
 * @package app\forum\views
 */
class TopicsView extends ForumView
{
    /**
     * 话题首页列表
     *
     * @param array $data
     */
    function index($data = array())
    {
        $this->renderTpl('topics/index', $data);
    }

    /**
     * @param array $data
     */
    function detail($data = array())
    {
        $this->renderTpl('topics/detail', $data);
    }

    /**
     * 话题子导航
     */
    function categoryNavigation()
    {
        $showAction = array('index' => 1, 'detail' => 1);
        $following_topic = &$this->data['following_topic'];
        if (!empty($following_topic) && isset($showAction[$this->action])) {
            $this->renderTpl('topics/category_navigation', array(
                'following_topic' => $following_topic
            ));
        }
    }
}
