<?php
/**
 * @author wonli <wonli@live.com>
 * UserView.php
 */

namespace app\forum\views;

use Cross\Core\Helper;

/**
 * 用户相关视图控制器
 *
 * @author wonli <wonli@live.com>
 * Class UserView
 * @package app\forum\views
 */
class UserView extends ForumView
{

    function index($data = array())
    {
        $this->renderTpl('user/index', $data);
    }

    /**
     * 个人资料
     *
     * @param array $data
     */
    function detail($data = array())
    {
        $this->renderTpl('user/detail', $data);
    }

    /**
     * 登录
     *
     * @param array $data
     */
    function login($data = array())
    {
        $this->set(array(
            'layer' => 'enter'
        ));

        $back = &$data['back'];
        $encrypt = &$data['encrypt'];
        if (!$encrypt && !empty($back)) {
            $back = Helper::encodeParams($back, 's');
        }

        $data['back'] = $back;
        $this->renderTpl('user/login', $data);
    }

    /**
     * 注册
     *
     * @param array $data
     */
    function register($data = array())
    {
        $this->set(array(
            'layer' => 'enter'
        ));

        $back = &$data['back'];
        $encrypt = &$data['encrypt'];
        if (!$encrypt && !empty($back)) {
            $back = Helper::encodeParams($back, 's');
        }

        $data['back'] = $back;
        $this->renderTpl('user/register', $data);
    }

    /**
     * 邀请注册
     *
     * @param array $data
     */
    function invite($data = array())
    {
        $this->set(array(
            'layer' => 'enter'
        ));

        if (!empty($data['inviteUserInfo']) && $data['status'] == 1) {
            $this->renderTpl('user/invite_register', $data);
        }
    }

    /**
     * 重置密码
     * @param array $data
     */
    function resetPassword($data = array())
    {
        if (!$data['hidden_form']) {
            switch ($data['form_type']) {
                case 'email':
                    $this->renderTpl('user/password/email_reset', $data);
                    break;

                default:
                    $this->renderTpl('user/reset_password', $data);
            }
        }
    }

    /**
     * 退出登录
     *
     * @param array $data
     */
    function logout($data = array())
    {
        $this->renderTpl('user/logout', $data);
    }
}
