CREATE TABLE IF NOT EXISTS `PREFIX@acl_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '0,系统 1,用户',
  `name` varchar(128) NOT NULL DEFAULT '',
  `link` varchar(64) NOT NULL DEFAULT '',
  `display` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '0,不显示 1,显示',
  `order` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@acl_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '角色名称',
  `behavior` mediumtext COMMENT '允许的行为',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色管理';

CREATE TABLE IF NOT EXISTS `PREFIX@act_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(32) NOT NULL,
  `controller` varchar(255) NOT NULL,
  `action` varchar(255) NOT NULL,
  `params` text,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `ip` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@admin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `nickname` varchar(255) NOT NULL DEFAULT '' COMMENT '对外显示名称',
  `real_name` varchar(255) NOT NULL DEFAULT '' COMMENT '真实姓名',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `cellphone` varchar(32) NOT NULL DEFAULT '' COMMENT '手机号',
  `password` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL DEFAULT '' COMMENT '授权访问时身份验证令牌',
  `theme` varchar(32) NOT NULL DEFAULT '' COMMENT '主题风格名称',
  `salt` char(16) NOT NULL,
  `usc` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '是否允许解绑密保卡',
  `last_login_date` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_login_ip` varchar(128) NOT NULL DEFAULT '',
  `rid` int(11) unsigned NOT NULL DEFAULT '1' COMMENT '角色ID',
  `t` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '0,禁用 1,正常',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@answers` (
  `answer_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `act_id` int(11) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL,
  `title_id` int(11) unsigned NOT NULL,
  `question_id` int(11) unsigned NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT '1' COMMENT '1,正常 -1,折叠, -2,屏蔽',
  `answer_content` text NOT NULL,
  `answer_ip` int(11) unsigned NOT NULL,
  `answer_time` int(11) NOT NULL,
  PRIMARY KEY (`answer_id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `title_id` (`title_id`) USING BTREE,
  KEY `question_id` (`question_id`) USING BTREE,
  KEY `uid_title_id` (`uid`,`title_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@answers_comment` (
  `comment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `answer_id` int(11) unsigned NOT NULL,
  `at_comment_id` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1,正常 -1,被折叠',
  `uid` int(11) unsigned NOT NULL,
  `comment_content` varchar(255) NOT NULL,
  `comment_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `comment_id` (`answer_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@answers_stand` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `answer_id` int(10) unsigned NOT NULL,
  `stand` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0,中立 1,赞同 2,反对',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_answer_id` (`uid`,`answer_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@answers_stat` (
  `answer_id` int(11) unsigned NOT NULL,
  `question_id` int(11) unsigned NOT NULL,
  `up_count` int(11) NOT NULL DEFAULT '0' COMMENT '点赞次数',
  PRIMARY KEY (`answer_id`),
  KEY `question_id_up_count` (`question_id`,`up_count`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@articles` (
  `article_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title_id` int(10) unsigned NOT NULL,
  `summary` text,
  `category_id` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `hits_update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`article_id`),
  KEY `title_id` (`title_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@articles_category` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `sort` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@articles_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `act_id` int(10) unsigned NOT NULL DEFAULT '0',
  `article_id` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '1,正常, -1,折叠, -2,屏蔽',
  `at_comment_id` int(10) unsigned NOT NULL DEFAULT '0',
  `comment_content` text NOT NULL,
  `comment_ip` int(11) unsigned NOT NULL,
  `comment_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `article_id` (`article_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@articles_content` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `article_id` int(11) unsigned NOT NULL,
  `content` longtext,
  `p` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `ct` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@articles_income` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '打赏',
  `article_id` int(10) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `income_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `article_id` (`article_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@articles_stand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `act_id` int(11) NOT NULL COMMENT '对应的动态id',
  `article_id` int(11) NOT NULL,
  `vote_time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `article_id` (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@coin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `router` varchar(128) NOT NULL,
  `change_type` char(1) NOT NULL DEFAULT '+',
  `change_value` int(10) unsigned NOT NULL,
  `change_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@collections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `title_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `collections_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_title_id` (`uid`,`title_id`) USING BTREE,
  KEY `category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@collections_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `category_name` varchar(255) NOT NULL,
  `sort` int(11) NOT NULL DEFAULT '1',
  `public` int(11) NOT NULL DEFAULT '1' COMMENT '0,私有, 1,公开',
  `create_time` int(11) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(32) NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `ct` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `key` (`key`),
  KEY `group_name` (`group_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@following_act` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `follow_id` int(11) NOT NULL,
  `act_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `following_id` (`follow_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@following_content` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `title_id` int(11) unsigned NOT NULL,
  `following_time` int(11) unsigned NOT NULL,
  `last_view_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_title_id` (`uid`,`title_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@following_topic` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `topic_id` int(11) unsigned NOT NULL,
  `following_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_topic_id` (`uid`,`topic_id`) USING BTREE,
  KEY `topic_id` (`topic_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@following_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `following_uid` int(10) unsigned NOT NULL,
  `following_type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1,主动关注, 2,系统推荐关注, 3, 点赞自动关注',
  `following_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_following_uid` (`uid`,`following_uid`) USING BTREE,
  KEY `following_uid` (`following_uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@friends_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '0,无效 1,正常',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@hits_articles` (
  `ip` int(11) unsigned NOT NULL,
  `article_id` int(11) unsigned NOT NULL,
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ip`,`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@hits_posts` (
  `ip` int(11) unsigned NOT NULL,
  `posts_id` int(11) unsigned NOT NULL,
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ip`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@hits_questions` (
  `ip` int(11) unsigned NOT NULL,
  `question_id` int(11) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ip`,`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nail_footer` tinyint(4) NOT NULL DEFAULT '0',
  `link_name` varchar(255) NOT NULL,
  `link_url` varchar(255) NOT NULL,
  `is_absolute_link` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否绝对地址',
  `content` text NOT NULL,
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `link_url` (`link_url`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@invite` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `title_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '1',
  `status` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '0:未处理 1:忽略',
  `invite_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_title_id` (`uid`,`title_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@invite_code` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `invite_code` varchar(50) NOT NULL,
  `use_count` int(11) unsigned NOT NULL DEFAULT '0',
  `comments` varchar(255) NOT NULL DEFAULT '' COMMENT '注释',
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '0,已失效 1,正常',
  `create_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '发送者id',
  `receiver_uid` int(11) NOT NULL DEFAULT '0' COMMENT '接受者id',
  `sender` int(11) NOT NULL DEFAULT '0' COMMENT '发送者',
  `receiver` int(11) NOT NULL DEFAULT '0' COMMENT '接受者',
  `message_type` tinyint(3) NOT NULL DEFAULT '0' COMMENT '1 普通消息 2 系统消息',
  `content` text,
  `send_time` int(11) NOT NULL DEFAULT '0',
  `read_time` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `read_time` (`read_time`) USING BTREE,
  KEY `uid_receiver_uid` (`uid`,`receiver_uid`) USING BTREE,
  KEY `receiver` (`receiver`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@posts` (
  `posts_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title_id` int(11) unsigned NOT NULL,
  `posts_type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1,普通帖 2,连载帖',
  `posts_status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1,已完结 2,连载中',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `hits_update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`posts_id`),
  KEY `title_id` (`title_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@posts_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `posts_id` int(10) unsigned NOT NULL,
  `content` longtext,
  `p` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `create_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_id` (`posts_id`) USING BTREE,
  KEY `p` (`p`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@questions` (
  `question_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title_id` int(11) unsigned NOT NULL,
  `question_content` text,
  `best_answer_id` int(11) unsigned NOT NULL,
  `hits` int(11) unsigned NOT NULL DEFAULT '0',
  `hits_update_time` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`question_id`),
  KEY `title_id` (`title_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@recommend_title` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title_id` int(11) NOT NULL,
  `sort` int(11) NOT NULL DEFAULT '1',
  `ct` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sort` (`sort`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@recommend_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@reply` (
  `reply_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `act_id` int(11) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL,
  `posts_id` int(11) unsigned NOT NULL,
  `up_count` int(11) unsigned NOT NULL DEFAULT '0',
  `at_reply_id` int(11) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '1' COMMENT '1,正常 -1,折叠, -2,屏蔽',
  `reply_content` text NOT NULL,
  `reply_ip` int(11) unsigned NOT NULL,
  `reply_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`reply_id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `topic_id` (`posts_id`) USING BTREE,
  KEY `posts_id_up_count` (`posts_id`,`up_count`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@reply_comment` (
  `comment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reply_id` int(11) unsigned NOT NULL,
  `at_reply_id` int(11) unsigned NOT NULL,
  `status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1,正常 -1,被折叠',
  `uid` int(11) unsigned NOT NULL,
  `comment_content` varchar(255) NOT NULL,
  `comment_time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`comment_id`),
  KEY `comment_id` (`reply_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@reply_up` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reply_id` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `ct` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `reply_id_uid` (`reply_id`,`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@report` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `report_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL,
  `report_id` int(10) unsigned NOT NULL,
  `rt` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type_report_id` (`type`,`report_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@security_card` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `card_data` text NOT NULL,
  `bind_user` varchar(255) NOT NULL,
  `ext_time` tinyint(4) NOT NULL DEFAULT '0' COMMENT '已过期,-1',
  PRIMARY KEY (`id`),
  KEY `bind_user` (`bind_user`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@seo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `controller` varchar(64) NOT NULL,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `controller` (`controller`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@title` (
  `title_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `act_id` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_ids` varchar(255) NOT NULL DEFAULT '' COMMENT '所属话题',
  `type` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '1,问答 2,帖子 3,文章',
  `uid` int(11) unsigned NOT NULL,
  `up_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '被赞次数',
  `interact_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '回复,答案或评论次数',
  `status` tinyint(3) NOT NULL DEFAULT '1' COMMENT '-1,已屏蔽 0,待审核 1,正常',
  `post_ip` int(11) unsigned NOT NULL,
  `post_time` int(11) unsigned NOT NULL,
  `last_interact_time` int(11) unsigned NOT NULL COMMENT '最后发生交互时间',
  PRIMARY KEY (`title_id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `up_count` (`up_count`) USING BTREE,
  KEY `type` (`type`) USING BTREE,
  KEY `topic_ids_interact_count` (`topic_ids`,`interact_count`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@title_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title_id` int(10) unsigned NOT NULL,
  `origin_url` varchar(255) NOT NULL DEFAULT '',
  `image_url` varchar(255) NOT NULL,
  `image_url_md5` char(50) NOT NULL,
  `location` tinyint(4) NOT NULL DEFAULT '1',
  `sync_status` tinyint(4) NOT NULL DEFAULT '0',
  `p` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `title_id_p` (`title_id`,`p`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@topic` (
  `topic_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `as_recommend` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_name` varchar(255) NOT NULL,
  `topic_url` varchar(255) NOT NULL,
  `topic_image` varchar(255) NOT NULL DEFAULT 'images/topics/default.png',
  `topic_description` varchar(255) NOT NULL DEFAULT '',
  `enable_question` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '开启问答',
  `enable_posts` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '开启帖子',
  `enable_article` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '开启文章分类',
  `create_time` int(10) unsigned NOT NULL,
  `sort` mediumint(8) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`topic_id`),
  UNIQUE KEY `topic_url` (`topic_url`) USING BTREE,
  KEY `as_recommend` (`as_recommend`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE,
  KEY `topic_name` (`topic_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@topic_editor` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL,
  `editor_uid` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `topic_id` (`topic_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@topic_score` (
  `id` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `topic_id` int(10) unsigned NOT NULL,
  `title_id` int(10) unsigned NOT NULL,
  `score` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid_topic_id` (`uid`,`topic_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@topic_title_id` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL COMMENT '模型类型',
  `topic_id` int(10) unsigned NOT NULL,
  `title_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `topic_id_title_id` (`topic_id`,`title_id`) USING BTREE,
  KEY `type_topic_id` (`topic_id`,`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@user` (
  `uid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(50) NOT NULL,
  `nickname` varchar(50) NOT NULL,
  `from_platform` tinyint(4) unsigned NOT NULL DEFAULT '1' COMMENT '1,本地 2,QQ, 3,微博, 4,微信',
  `email` varchar(255) NOT NULL DEFAULT '' COMMENT '电子邮件',
  `cellphone_number` varchar(50) NOT NULL DEFAULT '' COMMENT '手机号码',
  `introduce` varchar(255) NOT NULL DEFAULT '',
  `qr` varchar(255) NOT NULL DEFAULT '' COMMENT '收款二维码',
  `validate` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '认证状态',
  `invite_code_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '邀请码ID',
  `password` varchar(50) NOT NULL,
  `avatar` varchar(255) NOT NULL DEFAULT 'avatar/default.png',
  `gender` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0,未知 1,男 2,女',
  `salt` char(16) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT '-1,被封号 0,未完成 1,正常',
  `last_login_ip` int(11) unsigned NOT NULL DEFAULT '0',
  `last_login_time` int(11) unsigned NOT NULL DEFAULT '0',
  `register_ip` int(11) unsigned NOT NULL,
  `register_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`uid`),
  KEY `nickname` (`nickname`) USING BTREE,
  KEY `account` (`account`) USING BTREE,
  KEY `register_time` (`register_time`) USING BTREE,
  KEY `invite_code_id` (`invite_code_id`) USING BTREE,
  KEY `email` (`email`) USING BTREE,
  KEY `cellphone_number` (`cellphone_number`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@user_act_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `action_type` tinyint(3) unsigned NOT NULL,
  `title_id` int(11) unsigned NOT NULL,
  `relation_id` int(11) unsigned NOT NULL,
  `act_time` int(11) unsigned NOT NULL,
  `act_ip` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@user_openid` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `platform` tinyint(3) unsigned NOT NULL,
  `openid` varchar(64) NOT NULL,
  `unionid` varchar(64) NOT NULL DEFAULT '',
  `nickname` varchar(64) NOT NULL DEFAULT '',
  `gender` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0,未知 1,男 2,女',
  `avatar` varchar(255) NOT NULL DEFAULT '',
  `access_token` varchar(255) NOT NULL,
  `refresh_token` varchar(255) NOT NULL DEFAULT '',
  `bind_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `platform` (`platform`) USING BTREE,
  KEY `openid` (`openid`) USING BTREE,
  KEY `unionid` (`unionid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `PREFIX@user_validate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `type` tinyint(3) unsigned NOT NULL COMMENT '0,密码重置 1,email 2,手机 4,身份证',
  `code` char(12) NOT NULL,
  `data` varchar(255) NOT NULL COMMENT '验证数据',
  `send_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发送时间',
  `ct` int(10) unsigned NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid_type` (`uid`,`type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
