function followingUser(self, uid, ta_follow, follow_ta) {
    var gsi = (ta_follow || follow_ta) ? 1 : 0;
    $.post(window.cpf.api.followingUser, {'uid': uid, 'get_statistics_info': gsi}, function (d) {
        if (d.status === 1) {
            console.log(d);
            if (d.data.act === 'follow') {
                $(self).html('已关注');
            } else {
                $(self).html('关注TA');
            }

            if (ta_follow) {
                $(ta_follow).html(d.data.statistics.me_follow_count);
            }

            if (follow_ta) {
                $(follow_ta).html(d.data.statistics.follow_me_count);
            }
        } else {
            layer.msg(d.message);
        }
    });
}

function message(uid) {
    var width = $(document).width() < 860 ? '80%' : '43%';
    layer.open({
        type: 2,
        title: '',
        shadeClose: true,
        shade: 0.6,
        area: [width, '80%'],
        content: window.cpf.api.message.replace('::UID::', uid)
    });
}

$(function () {
    $("img.lazy").lazyload();

    $(".navbar-fixed-top").autoHidingNavbar();

    $('#goTop').click(function () {
        $("html, body").animate({scrollTop: 0}, 200);
    });

    //登录标识
    $('.login-flag').on('click', function () {
        window.location.href = window.cpf.url.login;
    });

    //搜索
    $('#search-form, #xs-search-form').on('submit', function () {
        var q = $(this).find('.search-flag').val();
        if (!q) {
            layer.msg('请输入关键词');
        } else {
            window.location.href = window.cpf.api.search.replace('::Q::', q);
        }

        return false;
    });

    if (window.cpf.isLogin) {
        $.jheartbeat = {
            options: {delay: 1},
            beatFunction: function () {
            },
            timeoutObj: {id: -1},
            set: function (options, onBeatFunction) {
                if (this.timeoutObj.id > -1) {
                    clearTimeout(this.timeoutObj);
                }
                if (options) {
                    $.extend(this.options, options);
                }
                if (onBeatFunction) {
                    this.beatFunction = onBeatFunction;
                }

                this.timeoutObj.id = setTimeout("$.jheartbeat.beat();", 1000 * this.options.delay);
            },

            beat: function () {
                this.timeoutObj.id = setTimeout("$.jheartbeat.beat();", 1000 * this.options.delay);
                this.beatFunction();
            }
        };

        var newMessage = $('.new-message-flag'), newMessageCount = $('.new-message-count-flag');
        $.jheartbeat.set({delay: 30}, function () {
            $.get(window.cpf.api.newMessageCount, function (d) {
                if (d.data.count > 0) {
                    newMessage.show();
                    newMessageCount.html(d.data.count);
                }
            })
        });
        newMessage.on('click', function () {
            location.href = window.cpf.url.message;
        });
    }

    var lastScrollTop = 0;
    $(window).bind("scroll", function () {
        var st = $(document).scrollTop();
        if (st > 150) {
            $('#goTop').show();
        } else {
            $('#goTop').hide();
        }

        lastScrollTop = st;
    });
});