/**
 * Created by ideaa on 2016/5/9.
 */
wangEditor.config.printLog = false;
var config = {
    menus: {
        simple: [
            'source', '|',
            'ahead', 'quote', '|',
            'bold', 'italic', '|',
            'link', 'img', '|',
            'table', '|',
            'fullscreen'
        ],
        mobile: [
            'ahead', 'quote', '|',
            'bold', 'italic', '|',
            'link', 'img', '|',
            'fullscreen'
        ]
    },
    uploadAction: function (editor) {
        return {
            onload: function (result, xhr) {
                // result 服务器端返回的text
                // xhr 是 xmlHttpRequest 对象，IE8、9中不支持
                if (typeof result != "object") {
                    result = $.parseJSON(result);
                }

                if (result.status != 1) {
                    var notice = result.message;
                    if (result.data) {
                        notice = notice + "<br>" + result.data;
                    }
                    layer.msg(notice);
                } else {
                    var storage = result.data.storage, origin = result.data.origin, src = storage + origin;
                    editor.command(null, 'insertHtml', '<img src="' + src + '" storage="' + storage + '" origin="' +
                        origin + '" style="max-width:780px;" local="' + result.data.local + '" alt="upload image"/>');
                }
            },
            onerror: function (xhr) {
                layer.msg('上传超时');
            },
            ontimeout: function (xhr) {
                layer.msg('上传错误');
            }
        }
    }
};

//标题插件
(function (E, $) {
    E.createMenu(function (check) {
        var menuId = 'ahead';
        if (!check(menuId)) {
            return;
        }
        var editor = this, lang = editor.config.lang, data = {'<h3>': '标题', '<h4>': '子标题'}, ids = [],
            isOrderedList, tpl = '<div style="margin:5px 10px 10px 0">{#commandValue}{#title}</div>',
            menu = new E.Menu({
                editor: editor,
                id: menuId,
                title: lang.head,
                commandName: 'formatBlock'
            });

        E.UI.menus.ahead = {
            normal: '<a href="#" tabindex="-1"><i class="wangeditor-menu-img-header"></i></a>',
            selected: '.selected'
        };

        menu.dropList = new E.DropList(editor, menu, {
            data: data,
            tpl: tpl,
            beforeEvent: function beforeEvent(e) {
                if (editor.queryCommandState('InsertOrderedList')) {
                    isOrderedList = true;
                    editor.command(e, 'InsertOrderedList');
                } else {
                    isOrderedList = false;
                }
            },
            afterEvent: function afterEvent(e) {
                if (isOrderedList) {
                    editor.command(e, 'InsertOrderedList');
                }
            }
        });

        menu.updateSelectedEvent = function () {
            var rangeElem = editor.getRangeElem();
            rangeElem = editor.getSelfOrParentByName(rangeElem, 'h3,h4');
            return !!rangeElem;
        };
        editor.menus[menuId] = menu;
    });

})(window.wangEditor, window.jQuery);

/**
 * 是否移动设备
 *
 * @returns {boolean}
 */
window.isMobile = function () {
    var check = false;
    (function (a) {
        if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(a) || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(a.substr(0, 4))) check = true;
    })(navigator.userAgent || navigator.vendor || window.opera);
    return check;
}();

//移动设备下的图片上传控件
if (window.isMobile) {
    (function (E, $) {
        E.createMenu(function (check) {
            var menuId = 'img';
            if (!check(menuId)) {
                return;
            }

            var editor = this;
            var lang = editor.config.lang;

            // 创建 menu 对象
            var menu = new E.Menu({
                editor: editor,
                id: menuId,
                title: lang.img
            });

            // 创建 panel content
            var $panelContent = $('<div class="panel-tab"></div>');
            var $tabContainer = $('<div class="tab-container"></div>');
            var $contentContainer = $('<div class="content-container"></div>');
            $panelContent.append($tabContainer).append($contentContainer);

            // tab
            var $uploadTab = $('<a href="#">' + lang.uploadImg + '</a>');
            var $linkTab = $('<a href="#">' + lang.linkImg + '</a>');
            $tabContainer.append($uploadTab).append($linkTab);

            // 上传图片 content
            var $uploadContent = $('<div class="content"></div>');
            $contentContainer.append($uploadContent);

            // 网络图片 content
            var $linkContent = $('<div class="content"></div>');
            $contentContainer.append($linkContent);

            // 添加panel
            menu.dropPanel = new E.DropPanel(editor, menu, {
                $content: $panelContent,
                width: 160,
                onRender: function () {
                    // 渲染后的回调事件，用于执行自定义上传的init
                    // 因为渲染之后，上传面板的dom才会被渲染到页面，才能让第三方空间获取到
                    var init = editor.config.customUploadInit;
                    init && init.call(editor);
                }
            });

            // 增加到editor对象中
            editor.menus[menuId] = menu;

            // 隐藏上传图片
            function hideUploadImg() {
                $tabContainer.remove();
                $uploadContent.remove();
                $linkContent.addClass('selected');
            }

            // 隐藏网络图片
            function hideLinkImg() {
                $tabContainer.remove();
                $linkContent.remove();
                $uploadContent.addClass('selected');
            }

            // 判断用户是否配置了上传图片
            editor.ready(function () {
                var editor = this;
                var config = editor.config;
                var uploadImgUrl = config.uploadImgUrl;
                var customUpload = config.customUpload;
                var linkImg = config.hideLinkImg;
                var $uploadImgPanel;

                if (uploadImgUrl || customUpload) {
                    // 第一，暴露出 $uploadContent 以便用户自定义 ！！！重要
                    editor.$uploadContent = $uploadContent;

                    if (linkImg) {
                        // 隐藏网络图片
                        hideLinkImg();
                    }
                } else {
                    // 未配置上传图片功能
                    hideUploadImg();
                }

                // 点击 $uploadContent 立即隐藏 dropPanel
                // 为了兼容IE8、9的上传，因为IE8、9使用 modal 上传
                // 这里使用异步，为了不妨碍高级浏览器通过点击 $uploadContent 选择文件
                function hidePanel() {
                    menu.dropPanel.hide();
                }

                $uploadContent.click(function () {
                    setTimeout(hidePanel);
                });
            });
        });

    })(window.wangEditor, window.jQuery);
}

/**
 * 初始化编辑器
 *
 * @param documentID
 * @param uploadUrl
 * @param enable
 * @returns {wangEditor}
 */
function editor(documentID, uploadUrl, enable) {
    var editor = new wangEditor(documentID), is_enable = enable || 1;
    editor.config.uploadImgUrl = uploadUrl;
    editor.config.uploadImgFns = config.uploadAction(editor);

    if (window.isMobile) {
        editor.config.hideLinkImg = true;
        editor.config.menus = config.menus.mobile;
    } else {
        editor.config.menus = config.menus.simple;
    }

    editor.create();
    if (is_enable == 1) {
        return editor;
    } else {
        editor.disable();
    }
}
