<?php
/**
 * @author wonli <wonli@live.com>
 * article.tpl.php
 */

$page = &$data['page'];
$article = &$data['article_info'];
$comment = &$data['comment_list'];
$user_home_url = $this->url('user:detail', array('account' => $article['account']));
$user_home_link = $this->a($article['nickname'], $user_home_url, array('class' => 'ia'));
$editor_data = array('title_id' => $article['title_id'], 'isLogin' => $data['isLogin'], 'loginUser' => $data['loginUser']);
$article_page = array();
if ($article['content_page'] > 1) {
    $article_page = array(
        'p' => $article['p'],
        'half' => 5,
        'link' => array('content:article', array('article_id' => $article['article_id'])),
        'total_page' => $article['content_page']
    );
}

$zClass = 'z2';
if (!empty($article['stand'])) {
    $zClass = 'z1';
}

$hasPraise = false;
$praiseTitle = '快来点个赞吧!';
if (!empty($data['praise_list'])) {
    $hasPraise = true;
    $praiseTitle = '他们赞了这篇文章';
}

$attr = array(
    'href' => 'javascript:void(0)',
    'class' => 'praise nice-article-flag',
    'article-id' => $article['article_id'],
);

//用户是否赞过
if ($article['stand']) {
    $attr['class'] = 'praised nice-article-flag';
}

$praiseButton = $this->a('<i class="iconfont icon-hand-up"></i>', 'javascript:void(0)', $attr);

//content_action仅输出button
$article['onlyButton'] = true;
?>
<div class="article-content">
    <div class="container">
        <div class="row">
            <ul class="nav nav-stacked hidden-xs article-content-act bdsharebuttonbox"
                data-spy="affix" data-tag="share_1">
                <li><a href="javascript:void(0)" class="qq" data-cmd="qzone"></a></li>
                <li><a href="javascript:void(0)" class="weibo" data-cmd="tsina"></a></li>
                <li><a href="javascript:void(0)" class="weixin" data-cmd="weixin"></a></li>
            </ul>
            <div class="col-md-9 col-centered">
                <div class="panel panel-cpf-content">
                    <div class="panel-heading">
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo $this->contentTopics($article['topics'], 'article') ?>
                            </div>
                            <div class="col-md-12">
                                <h3 class="media-heading title text-center"><?php echo $article['title'] ?></h3>

                                <div class="text-center">
                                    <?php $this->renderTpl('fragment/slide/content_action', $article) ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel-body">
                        <div class="content">
                            <?php echo $article['content'] ?>
                        </div>

                        <?php if (!empty($article['qr'])) : ?>
                            <div class="author-qr text-center small">
                                <?php echo $this->img($this->res($article['qr'])) ?>
                                <br/> 请作者喝杯咖啡
                            </div>
                        <?php endif ?>
                    </div>

                    <?php if ($article['content_page'] > 1) : ?>
                        <div class="panel-footer">
                            <div class="row" style="margin: 20px 0">
                                <div class="col-md-9 col-centered tac">
                                    <?php $this->page($article_page, 'title') ?>
                                </div>
                            </div>
                        </div>
                    <?php endif ?>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-9 col-centered">
                <div class="panel panel-cpf-content">
                    <div class="panel-heading text-center">

                        <div class="panel-heading text-center">
                            <a href="<?php echo $user_home_url ?>">
                                <?php echo $this->userAvatar($article['avatar'], '62px') ?>
                            </a>
                            <div style="padding:10px 0 15px 0">
                                <div class="col-md-12 text-center">
                                    <?php
                                    echo $this->userFollowButton($article['uid'], (bool)$article['follow_user_id'], '', '', array(
                                        'style' => 'padding:3px 5px'
                                    ));
                                    ?>
                                </div>
                            </div>
                        </div>


                        <div class="text-center">
                            <div class="small text-left praise-title">
                                <?php echo $praiseTitle ?>
                            </div>
                            <div class="praise-list text-left">
                                <?php
                                if (!empty($data['praise_list'])) {
                                    foreach ($data['praise_list'] as $p) {
                                        $attr = array(
                                            'href' => $this->url('user:detail', array('account' => $p['account'])),
                                            'target' => '_blank'
                                        );

                                        echo $this->wrap('a', $attr)
                                            ->html($this->userAvatar($p['avatar'], '32px'), false);
                                    }
                                }
                                echo $praiseButton;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-9 col-centered">
                <div class="panel panel-cpf-content">
                    <div class="panel-heading">
                        <?php $this->renderTpl('fragment/editor/article_form', $editor_data) ?>
                    </div>
                </div>
            </div>
        </div>

        <?php if ($page['result_count'] > 0) : ?>
            <div class="row">
                <div class="col-md-9 col-centered">
                    <div class="panel panel-cpf-content">
                        <div class="panel-heading">
                            <div class="row">
                                <div class="col-xs-4 ft18">
                                    <?php echo $page['result_count'] ?> 条评论
                                </div>
                                <div class="col-xs-8 text-right pull-right">
                                    <?php echo $this->page($page, 'title') ?>
                                </div>
                            </div>
                        </div>
                        <div class="panel-body">
                            <?php
                            if (!empty($comment)) {
                                foreach ($comment as $d) {
                                    $this->renderTpl('content/segment/comment', $d);
                                }
                            }

                            //最后一页显示被屏蔽的评论数
                            if ($data['page']['p'] >= $data['page']['total_page'] && $data['blocked_comment_count'] > 0) {
                                echo $this->wrap('div', array('class' => 'blocked-content-list'))
                                    ->a("有{$data['blocked_comment_count']}条评论被折叠或屏蔽, 点击查看", 'javascript:void(0)', array(
                                        'id' => 'loadBlockComment', 'article-id' => $article['article_id']
                                    ));
                            }
                            ?>
                            <div id="blockContentArea"></div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>
    </div>
</div>

<div class="container-fluid" style="margin-top:20px;">
    <div class="container">
        <div class="row">
            <div class="col-md-9 col-centered">
                <?php
                if (!empty($data['correlation_content'])) {
                    $this->renderTpl('fragment/article/recommend_content', $data['correlation_content']);
                }
                ?>
            </div>
        </div>
    </div>
</div>

<script>
    $(function () {
        $('.comment-list-flag').hover(function () {
            $(this).find('.reply-control-panel').show();
        }, function () {
            $(this).find('.reply-control-panel').hide();
        });

        //举报
        $('.report-flag').on('click', function () {
            var report_id = $(this).attr('report-id'), report_type = $(this).attr('report-type');
            $.post('<?php echo $this->url('action:report') ?>', {'type': report_type, 'id': report_id});
            layer.msg('我们已收到您的举报');
        });

        //编辑
        $('.edit-flag').on('click', function () {
            var type = $(this).attr('type'), id = $(this).attr('data-id');
            $.post('<?php echo $this->url('action:getInteract') ?>', {'type': type, 'id': id}, function (d) {
                if (d.status && d.status !== 1) {
                    layer.msg(d.message);
                } else {
                    $('#editor').val(d.data.content);
                    $("#comment_id").val(id);
                }
            });
        });

        //折叠和屏蔽
        $('.block-flag, .hide-flag').on('click', function () {
            var type = $(this).attr('type'), id = $(this).attr('data-id'), act = $(this).attr('act');
            $.post('<?php echo $this->url('action:blockInteract') ?>', {
                'type': type,
                'act': act,
                'id': id
            }, function (d) {
                if (d.status === 1) {
                    if (act === 'hide') {
                        layer.msg('折叠成功');
                    } else {
                        layer.msg('屏蔽成功');
                    }

                    setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                } else {
                    layer.msg(d.message);
                }
            });
        });

        //删除
        $('.del-flag').on('click', function () {
            var type = $(this).attr('type'), id = $(this).attr('data-id');
            $.post('<?php echo $this->url('action:delInteract') ?>', {'type': type, 'id': id}, function (d) {
                if (d.status === 1) {
                    layer.msg('删除成功');
                    setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                } else {
                    layer.msg(d.message);
                }
            });
        });

        $('.nice-article-flag').on('click', function () {
            var vm = $(this),
                voteUrl = "<?php echo $this->url('action:articleVote') ?>",
                articleID = $(this).attr('article-id');

            $.post(voteUrl, {'article_id': articleID}, function (d) {
                if (d.status !== 1) {
                    layer.msg(d.message);
                } else {
                    if (d.data.action === 1) {
                        vm.removeClass('praise').addClass('praised');
                    } else {
                        vm.removeClass('praised').addClass('praise');
                    }
                }
            });
        });

        //显示被屏蔽或折叠的答案
        $('#loadBlockComment').on('click', function () {
            var article_id = $(this).attr('article-id'), loaded = $(this).attr('loaded'), that = $(this);
            if (loaded) {
                $('#blockContentArea').toggle()
            } else {
                $.post('<?php echo $this->url('action:loadBlockComment') ?>', {'article_id': article_id}, function (d) {
                    that.attr('loaded', 1);
                    $('#blockContentArea').html(d);
                });
            }
        });
    });
</script>
<script>
    window._bd_share_config = {
        common: {
            bdText: '<?php echo $article['title'] ?>',
            bdDesc: '<?php echo $article['title'] ?>',
            bdUrl: '<?php echo $data['share_data']['url'] ?>'
        },
        share: [{
            tag: 'share_1',
            bdCustomStyle: '<?php echo $this->res('css/bds.css') ?>'
        }],
        slide: 0
    };
    with (document) 0[(getElementsByTagName('head')[0] || body).appendChild(createElement('script')).src = '//bdimg.share.baidu.com/static/api/js/share.js?cdnversion=' + ~(-new Date() / 36e5)];
</script>