<?php
/**
 * @author wonli <wonli@live.com>
 * article.tpl.php
 */

$page = &$data['page'];
$article = &$data['article_info'];
$comment = &$data['comment_list'];
$user_home_url = $this->url('user:detail', array('account' => $article['account']));
$user_home_link = $this->a($article['nickname'], $user_home_url, array('class' => 'ia'));
$editor_data = array('title_id' => $article['title_id'], 'isLogin' => $data['isLogin'], 'loginUser' => $data['loginUser']);
$article_page = array();
if ($article['content_page'] > 1) {
    $article_page = array(
        'p' => $article['p'],
        'half' => 5,
        'link' => array('content:article', array('article_id' => $article['article_id'])),
        'total_page' => $article['content_page']
    );
}

//content_action仅输出button
$article['onlyButton'] = true;
?>
<div class="article-content">
    <div class="container article-heading">
        <div class="row">
            <div class="col-md-9">

                <div class="row">

                    <div class="col-md-12">
                        <div class="panel panel-cpf-content content-box">
                            <div class="panel-heading">
                                <p>
                                    <?php echo $this->contentTopics($article['topics'], 'article') ?>
                                </p>
                                <h3 class="title"><?php echo $article['title'] ?></h3>
                            </div>
                            <div class="panel-body">
                                <?php echo $article['content'] ?>
                            </div>
                            <?php if ($article['content_page'] > 1) : ?>
                                <div class="panel-footer text-center" style="padding:20px 0">
                                    <?php $this->page($article_page, 'title') ?>
                                </div>
                            <?php endif ?>
                        </div>
                    </div>

                </div>

                <div class="row">
                    <div class="col-md-12 col-centered">
                        <div class="panel">
                            <div class="panel-body">
                                <?php $this->renderTpl('fragment/editor/article_form', $editor_data) ?>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($page['result_count'] > 0) : ?>
                    <div class="row" style="margin-top:5px;line-height:35px;">
                        <div class="col-md-12 col-centered">

                            <div class="panel panel-cpf-content">

                                <div class="panel-heading">
                                    <div class="row">
                                        <div class="col-xs-4 ft18">
                                            <?php echo $page['result_count'] ?> 条评论
                                        </div>
                                        <div class="col-xs-8 text-right pull-right">
                                            <?php echo $this->page($page, 'title') ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="panel-body">
                                    <?php
                                    if (!empty($comment)) {
                                        foreach ($comment as $d) {
                                            $this->renderTpl('content/segment/comment', $d);
                                        }
                                    }

                                    //最后一页显示被屏蔽的评论数
                                    if ($data['page']['p'] >= $data['page']['total_page'] && $data['blocked_comment_count'] > 0) {
                                        echo $this->wrap('div', array('class' => 'blocked-content-list'))
                                            ->a("有{$data['blocked_comment_count']}条评论被折叠或屏蔽, 点击查看", 'javascript:void(0)', array(
                                                'id' => 'loadBlockComment', 'article-id' => $article['article_id']
                                            ));
                                    }
                                    ?>
                                    <div id="blockContentArea"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                <?php endif ?>
            </div>


            <div class="col-md-3">

                <div class="row">
                    <div class="col-md-12 tac">
                        <div class="panel panel-cpf-slide">
                            <div class="panel-heading">
                                <a href="<?php echo $user_home_url ?>">
                                    <?php echo $this->userAvatar($article['avatar'], '68px') ?>
                                </a>
                                <p>
                                    <?php echo $user_home_link ?>
                                </p>
                            </div>
                            <div class="panel-body">
                                <?php $this->renderTpl('fragment/slide/content_action', $article) ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-cpf-slide">
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-xs-6 text-center">
                                        <a href="javascript:void(0)" class="nice-article-flag"
                                           article-id="<?php echo $article['article_id'] ?>">
                                            <img src="<?php echo $this->res('images/nice.png') ?>" alt="赞"/><br/>
                                            <span><?php echo !empty($article['stand']) ? '已赞' : '赞' ?></span>
                                        </a>
                                    </div>
                                    <div class="col-xs-6 text-center">
                                        <a href="javascript:void(0)" class="reward-flag"
                                           author-uid="<?php echo $article['uid'] ?>">
                                            <img src="<?php echo $this->res('images/reward.png') ?>" alt="打赏"/><br/>
                                            <span>赏</span>
                                        </a>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 col-centered">
                        <?php
                        if (!empty($data['correlation_content'])) {
                            $this->renderTpl('fragment/article/recommend_content', $data['correlation_content']);
                        }
                        ?>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>

<script>
    $(function () {
        $('.comment-list-flag').hover(function () {
            $(this).find('.reply-control-panel').show();
        }, function () {
            $(this).find('.reply-control-panel').hide();
        });

        //举报
        $('.report-flag').on('click', function () {
            var report_id = $(this).attr('report-id'), report_type = $(this).attr('report-type');
            $.post('<?php echo $this->url('action:report') ?>', {'type': report_type, 'id': report_id});
            layer.msg('我们已收到您的举报');
        });

        //编辑
        $('.edit-flag').on('click', function () {
            var type = $(this).attr('type'), id = $(this).attr('data-id');
            $.post('<?php echo $this->url('action:getInteract') ?>', {'type': type, 'id': id}, function (d) {
                if (d.status && d.status !== 1) {
                    layer.msg(d.message);
                } else {
                    $('#editor').val(d.data.content);
                    $("#comment_id").val(id);
                }
            });
        });

        //折叠和屏蔽
        $('.block-flag, .hide-flag').on('click', function () {
            var type = $(this).attr('type'), id = $(this).attr('data-id'), act = $(this).attr('act');
            $.post('<?php echo $this->url('action:blockInteract') ?>', {
                'type': type,
                'act': act,
                'id': id
            }, function (d) {
                if (d.status === 1) {
                    if (act === 'hide') {
                        layer.msg('折叠成功');
                    } else {
                        layer.msg('屏蔽成功');
                    }

                    setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                } else {
                    layer.msg(d.message);
                }
            });
        });

        //删除
        $('.del-flag').on('click', function () {
            var type = $(this).attr('type'), id = $(this).attr('data-id');
            $.post('<?php echo $this->url('action:delInteract') ?>', {'type': type, 'id': id}, function (d) {
                if (d.status === 1) {
                    layer.msg('删除成功');
                    setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                } else {
                    layer.msg(d.message);
                }
            });
        });

        $('.nice-article-flag').on('click', function () {
            var n = $(this).find('span'),
                voteUrl = "<?php echo $this->url('action:articleVote') ?>",
                articleID = $(this).attr('article-id');

            $.post(voteUrl, {'article_id': articleID}, function (d) {
                if (d.status != 1) {
                    layer.msg(d.message);
                } else {
                    if (d.data.action == 1) {
                        n.html('已赞');
                    } else {
                        n.html('赞');
                    }
                }
            });
        });

        //显示被屏蔽或折叠的答案
        $('#loadBlockComment').on('click', function () {
            var article_id = $(this).attr('article-id'), loaded = $(this).attr('loaded'), that = $(this);
            if (loaded) {
                $('#blockContentArea').toggle()
            } else {
                $.post('<?php echo $this->url('action:loadBlockComment') ?>', {'article_id': article_id}, function (d) {
                    that.attr('loaded', 1);
                    $('#blockContentArea').html(d);
                });
            }
        });

        $('.reward-flag').on('click', function () {
            var rewardUrl = "<?php echo $this->url('action:reward', array('author_uid' => '::AUTHOR_UID::', 'full' => '::FULL::')) ?>",
                authorUid = $(this).attr('author-uid'),
                full = $(document).width() < 500 ? '1' : '0',
                rewardApiUrl = rewardUrl.replace('::AUTHOR_UID::', authorUid).replace('::FULL::', full);

            $.get(rewardApiUrl, function (d) {
                if (d.status != 1) {
                    layer.msg(d.message);
                } else {
                    layer.open({
                        type: 1,
                        title: false,
                        area: d.data.layer_size,
                        closeBtn: 0,
                        shadeClose: true,
                        content: d.data.img
                    });
                }
            });
        });
    });
</script>



