<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title><?php echo $this->getSeoInfo('title') ?></title>
    <meta name="Keywords" content="<?php echo $this->getSeoInfo('keywords') ?>"/>
    <meta name="Description" content="<?php echo $this->getSeoInfo('description') ?>"/>

    <!-- Bootstrap -->
    <link href="<?php echo $this->res('libs/bootstrap/3.3.7/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('icon/default/icon.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('css/main.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('theme/classic.css') ?>" rel="stylesheet">
    <?php echo $this->loadRes('header') ?>

    <!--[if lt IE 9]>
    <script src="<?php echo $this->res('libs/html5shiv/3.7.2/html5shiv.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/respond.js/1.4.2/respond.min.js') ?>"></script>
    <![endif]-->

    <script>window.cpf = <?php echo $this->getJSConfig() ?></script>

    <script src="<?php echo $this->res('libs/jquery/1.11.1/jquery.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/bootstrap/3.3.7/js/bootstrap.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/layer/2.2/layer.js') ?>"></script>
    <script src="<?php echo $this->res('js/cpf.js') ?>"></script>
</head>
<body>

<div id="topNav" class="navbar navbar-default navbar-static-top">
    <div class="container">
        <div class="navbar-header">
            <?php if ($this->data['isLogin']) : ?>
                <a href="javascript:void(0)"
                   style="padding:7px 15px;" type="button" class="navbar-toggle xs-navbar-toggle visible-xs"
                   data-toggle="collapse"
                   data-target=".navbar-collapse">
                    <?php echo $this->userAvatar($this->data['loginUser']['avatar'], '36px') ?>
                    <span class="nickname"><?php echo $this->data['loginUser']['nickname'] ?></span>
                </a>
            <?php else : ?>
                <span class="btn-group btn-group-theme navbar-toggle xs-navbar-toggle visible-xs" role="group">
                    <a href="<?php echo $this->url('user:login') ?>" class="btn btn-default ">登录</a>
                    <a href="<?php echo $this->url('user:register') ?>" class="btn btn-default ">注册</a>
                </span>
            <?php endif ?>

            <a class="navbar-brand" href="<?php echo $this->url() ?>">
                <img src="<?php echo $this->res('images/navbar_logo.png') ?>" alt="logo"/>
            </a>
        </div>

        <div class="navbar-collapse collapse">
            <ul class="nav navbar-nav hidden-xs" style="position: relative">
                <?php $this->contentNavMenu() ?>
            </ul>

            <?php if ($this->data['isLogin']) : ?>
                <ul class="nav navbar-nav navbar-right">
                    <li class="dropdown user user-menu hidden-xs">
                        <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown"
                           style="padding:7px 15px;">
                            <?php echo $this->userAvatar($this->data['loginUser']['avatar'], '36px') ?>
                            <span><?php echo $this->data['loginUser']['nickname'] ?></span>
                        </a>

                        <ul class="dropdown-menu">
                            <?php $this->renderTpl('user/nav_menu') ?>
                        </ul>
                    </li>
                </ul>

                <ul class="nav navbar-nav navbar-right visible-xs">
                    <?php $this->renderTpl('user/nav_menu') ?>
                </ul>
            <?php else : ?>
                <div class="nav navbar-nav navbar-right hidden-xs navbar-nav-op">
                    <span class="btn-group btn-group-theme" role="group">
                        <a href="<?php echo $this->url('user:login') ?>" class="btn btn-default navbar-btn">
                            登录
                        </a>
                        <a href="<?php echo $this->url('user:register') ?>" class="btn btn-default navbar-btn">
                            注册
                        </a>
                    </span>
                </div>
            <?php endif ?>

            <div class="nav navbar-right hidden-xs">
                <div class="input-group">
                    <form id="search-form" class="navbar-form " role="search">
                        <input type="text" class="search-input form-control search-flag" placeholder="搜索关键词">
                        <span class="input-group-btn">
                            <button type="submit" class="btn search-btn btn-default">
                                <span class="glyphicon glyphicon-search search-icon" aria-hidden="true"></span>
                            </button>
                        </span>
                    </form>
                </div>
            </div>

            <ul class="nav navbar-nav navbar-right hidden-xs">
                <li class="dropdown">
                    <?php if ($this->data['isLogin']) : ?>
                        <a href="javascript:void(0)" class="dropdown-toggle" data-toggle="dropdown" role="button"
                           aria-haspopup="true"
                           aria-expanded="false">
                            发布
                        </a>
                        <ul class="dropdown-menu">
                            <?php $this->publishMenu() ?>
                        </ul>
                    <?php else: ?>
                        <a href="<?php echo $this->url('user:login') ?>" class="dropdown-toggle">发布</a>
                    <?php endif ?>
                </li>
            </ul>
        </div>
    </div>
</div>
<?php $this->categoryNavigation() ?>
<div class="navbar navbar-xs-bottom navbar-fixed-bottom visible-xs">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul class="nav navbar-nav navbar-xs-ul" style="display: inline-block">
                    <?php $this->contentNavMenu('li', true) ?>
                </ul>
                <ul class="nav navbar-nav navbar-right navbar-xs-ul" style="display: inline-block;float:right">
                    <li>
                        <?php if ($this->data['isLogin']) : ?>
                            <a href="javascript:void(0)" data-toggle="modal" data-target="#xs-publish-modal"
                               class="dropdown-toggle">发布</a>
                        <?php else: ?>
                            <a href="<?php echo $this->url('user:login') ?>" class="dropdown-toggle">发布</a>
                        <?php endif ?>
                    </li>
                    <li>
                        <a data-toggle="modal" data-target="#xs-search-form-modal">搜索</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>

<!-- xs search Modal -->
<div class="modal fade" id="xs-search-form-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <form id="xs-search-form" role="search">
        <div class="container xs-search">
            <div class="row">
                <div class="col-md-12">
                    <div class="input-group">
                        <input type="text" class="form-control input-lg search-flag" placeholder="搜索关键词">
                        <span class="input-group-btn">
                            <button type="submit" class="btn btn-lg btn-default btn-lg-line-fix">
                             <span class="glyphicon glyphicon-search" aria-hidden="true"></span>
                            </button>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="xs-publish-modal" tabindex="-1" role="form">
    <div class="container xs-publish">
        <div class="row col-centered tac">
            <?php $this->publishMenu('xs') ?>
        </div>
    </div>
</div>

<div class="mainWrap">
    <?php
    if (!empty($alertMessage)) {
        echo $this->block($alertMessage, array('class' => 'container', 'style' => 'margin-top:30px;'));
    }

    echo empty($content) ? "" : $content
    ?>
</div>

<div class="footWrap hidden-xs hidden-sm">
    <div class="container cpf-helper">
        <div class="row">
            <div class="col-md-12 cpf-helper-link">
                <ul class="list-inline">
                    <li>
                        <a href="<?php echo $this->url('link') ?>" class="ia">友情链接</a>
                        <?php $this->infoLink() ?>
                    </li>
                </ul>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 cpf-boot-introduce">
                <?php echo $this->siteConfig->get('introduce') ?>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12 cpf-version">
                Powered by <a href="//cpf.crossphp.com" class="ia" target="_blank"><b>CPF</b></a>
                <?php echo $this->data['version'] ?>
            </div>
        </div>
    </div>
    <div class="container">
        <div class="row" style="position:relative">
            <div id="goTop">
                <img src="<?php echo $this->res('images/gotop.png') ?>" border="0" alt="gotop"/>
            </div>
            <div id="newMessage" class="new-message-flag">
                <span class="badge new-message-badge new-message-count-flag">0</span>
                <img src="<?php echo $this->res('images/new_message.png') ?>" border="0" alt="new message tips">
            </div>

            <div id="titleList">
                <div id="titleListContent" class="hidden-xs">
                    <div id="af" style="width:500px;"></div>
                </div>
                <img src="<?php echo $this->res('images/list.png') ?>" border="0" alt="title list">
            </div>
        </div>
    </div>
</div>
<script src="<?php echo $this->res('libs/jquery_lazyload/1.9.7/jquery.lazyload.min.js') ?>"></script>
<script src="<?php echo $this->res('js/jquery.bootstrap-autohidingnavbar.min.js') ?>"></script>
<?php echo empty($statistics_code) ? '' : $statistics_code; ?>
</body>
</html>
