<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title><?php echo $this->getSeoInfo('title') ?></title>
    <meta name="Keywords" content="<?php echo $this->getSeoInfo('keywords') ?>"/>
    <meta name="Description" content="<?php echo $this->getSeoInfo('description') ?>"/>

    <!-- Bootstrap -->
    <link href="<?php echo $this->res('libs/bootstrap/3.3.7/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('css/main.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('css/enter.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('icon/default/icon.css') ?>" rel="stylesheet">
    <?php echo $this->loadRes('header') ?>

    <script src="<?php echo $this->res('libs/jquery/1.11.1/jquery.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/bootstrap/3.3.7/js/bootstrap.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/nice-validator/0.10.11/jquery.validator.min.js?local=zh-CN') ?>"></script>
    <script src="<?php echo $this->res('libs/layer/2.2/layer.js') ?>"></script>

    <script src="<?php echo $this->res('libs/gsap/1.19.1/TweenMax.min.js') ?>"></script>
    <script src="<?php echo $this->res('js/jquery.wavify.js') ?>"></script>

    <!--[if lt IE 9]>
    <script src="<?php echo $this->res('libs/html5shiv/3.7.2/html5shiv.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/respond.js/1.4.2/respond.min.js') ?>"></script>
    <![endif]-->
</head>
<body>
<div id="particles">
    <div class="intro">
        <div class="container" style="margin-bottom: 20px; z-index: 999;">
            <div class="row">
                <div class="col-md-12 col-centered tac">
                    <img src="<?php echo $this->res('images/logo.png') ?>" alt="logo"/>
                </div>
                <div class="col-md-12 col-centered tac" style="margin-top:20px;">
                    <h4><?php echo $this->siteConfig->get('introduce') ?></h4>
                </div>
            </div>
        </div>
        <?php
        if (!empty($alertMessage)) {
            echo $this->wrap('div', array('class' => 'container', 'style' => 'margin-top:30px;'))
                ->wrap('div', array('class' => 'row'))->wrap('div', array('class' => 'col-md-4 col-sm-8 col-centered'))
                ->html($alertMessage);
        }

        echo empty($content) ? "" : $content
        ?>
    </div>
    <svg width="100%" height="50%" class="wave" version="1.1" xmlns="http://www.w3.org/2000/svg">
        <path id="wave" d=""></path>
    </svg>
</div>
<?php echo empty($statistics_code) ? '' : $statistics_code; ?>
<div class="modal fade" id="myModal" tabindex="-1" style="text-align: left" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">用户协议</h4>
            </div>
            <div class="modal-body" id="agreementContent"></div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('#wave').wavify({
            height: 1,
            bones: 2,
            amplitude: 50,
            color: 'rgba(50, 120, 180, 0.10)',
            speed: .25
        });

        $('#userAgreement').on('click', function () {
            $.get('<?php echo $this->url('action:getAgreement') ?>', function (d) {
                $('#agreementContent').html(d);
                $('#myModal').modal();
            })
        });
    });
</script>
</body>
</html>
