<?php
/**
 * @author wonli <wonli@live.com>
 * index.tpl.php
 */
$page = &$data['page'];
$friends_link = &$data['friends_link'];
$link_params = $page['link'][1];
$side = &$data['side_data'];
?>
<div class="container">
    <div class="row">
        <div class="col-md-9">
            <div class="panel panel-cpf-default panel-explore-article">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-5 content-menu-title">
                            <img src="<?php echo $this->res('images/explore.png') ?>" alt="explore"/>
                            <h4><?php echo $this->e($data, 'mode_name', '发现') ?></h4>
                        </div>
                        <div class="col-xs-7 heading-right order-menu">
                            <?php $this->orderMenu('explore:index', $link_params, $data['order']); ?>
                        </div>
                    </div>
                </div>
                <div id="explore-list-wrap">
                    <?php
                    if (!empty($data['content_list'])) {
                        $this->contentListSection($data['content_list'], 'explore/single', array(
                            'class' => "content-list content-{$data['type']}-list"
                        ));
                    } else {
                        echo $this->block('暂无', array('style' => 'padding:20px 15px;background:#fff'));
                    }
                    ?>
                </div>
                <div class="panel-footer">
                    <?php $this->page($data['page']) ?>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-cpf-slide">
                        <div class="panel-heading">
                            <h4>热评文章</h4>
                        </div>
                        <div class="panel-body">
                            <ul class="correlation-list">
                                <?php
                                if (!empty($side['hot_comment'])) {
                                    foreach ($side['hot_comment'] as $d) {
                                        ?>
                                        <li>
                                            <a class="ia"
                                               href="<?php echo $content_link = $this->url('content:article', array('article_id' => $d['article_id'])) ?>">
                                                <?php echo $d['title'] ?>
                                            </a>
                                        </li>
                                        <?php
                                    }
                                } else {
                                    echo $this->block('暂无', array('style' => 'padding:5px 15px;background:#fff'));
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <?php if (!empty($side['hot_comment'])) : ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-cpf-slide">
                            <div class="panel-heading">
                                <h4>作家排行</h4>
                            </div>
                            <div class="panel-body">
                                <ul class="correlation-list">
                                    <?php
                                    foreach ($side['hot_author'] as $d) {
                                        $this->sideUserList($d);
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif ?>
        </div>
    </div>
</div>


