<?php
/**
 * @author wonli <wonli@live.com>
 * index.tpl.php
 */
$page = &$data['page'];
$friends_link = &$data['friends_link'];
$link_params = $page['link'][1];
?>
<div class="container">
    <div class="row explore-list">
        <div class="col-md-12">
            <div class="panel panel-cpf-default panel-explore-posts">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-5 content-menu-title">
                            <img src="<?php echo $this->res('images/explore.png') ?>" alt="explore"/>
                            <h4><?php echo $this->e($data, 'mode_name', '发现') ?></h4>
                        </div>
                        <div class="col-xs-7 heading-right order-menu">
                            <?php $this->orderMenu('explore:index', $link_params, $data['order']); ?>
                        </div>
                    </div>
                </div>
                <div id="explore-list-wrap">
                    <?php
                    if (!empty($data['content_list'])) {
                        $this->contentListSection($data['content_list'], 'explore/single', array(
                                'class' => "content-list content-{$data['type']}-list"
                        ));
                    } else {
                        echo $this->block('暂无', array('style' => 'padding:20px 15px'));
                    }
                    ?>
                </div>
                <div class="panel-footer">
                    <?php $this->page($data['page']) ?>
                </div>
            </div>
        </div>

        <?php if (!empty($friends_link)) : ?>
            <div class="col-md-12">
                <div class="panel panel-cpf-min-gap">
                    <div class="panel-heading">
                        <h4>友情链接</h4>
                    </div>
                    <div class="panel-body friends-link">
                        <?php
                        foreach ($friends_link as $v) {
                            if($v['logo']) {
                                $content = $this->img($v['logo'], array('alt' => $v['site_name']));
                            } else {
                                $content = $v['site_name'];
                            }

                            echo $this->a($content, $v['url'], array('target' => '_blank'));
                        }
                        ?>
                    </div>
                </div>
            </div>
        <?php endif ?>
    </div>
</div>


