<?php
/**
 * @author wonli <wonli@live.com>
 * index.tpl.php
 */
$page = &$data['page'];
$link_params = $page['link'][1];
$side = &$data['side_data'];
?>
<div class="container">
    <div class="row">
        <div class="col-md-9">
            <div class="panel panel-cpf-default panel-explore-question">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-5 content-menu-title">
                            <img src="<?php echo $this->res('images/explore.png') ?>" alt="explore"/>
                            <h4><?php echo $this->e($data, 'mode_name', '发现') ?></h4>
                        </div>
                        <div class="col-xs-7 heading-right order-menu">
                            <?php $this->orderMenu('explore:index', $link_params, $data['order']); ?>
                        </div>
                    </div>
                </div>
                <div id="explore-list-wrap">
                    <?php
                    if (!empty($data['content_list'])) {
                        $this->contentListSection($data['content_list'], 'explore/single', array(
                            'class' => "content-list content-question-list"
                        ));
                    } else {
                        echo $this->block('暂无内容', array('style' => 'padding:20px 15px;background:#fff'));
                    }
                    ?>
                </div>
            </div>
            <div class="text-center">
                <?php $this->page($data['page']) ?>
            </div>
        </div>

        <div class="col-md-3">
            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-cpf-slide">
                        <div class="panel-heading">
                            <h4>推荐话题</h4>
                        </div>
                        <div class="panel-body">
                            <?php
                            if (!empty($side['recommend_topic'])) {
                                foreach ($side['recommend_topic'] as $topic) {
                                    $url = $this->url('topics:detail', array('topic_url' => $topic['topic_url']));
                                    echo $this->a($topic['topic_name'], $url, array('class' => 'btn btn-topic-show'));
                                }
                            } else {
                                echo $this->block('暂无', array('style' => 'padding:5px 15px;background:#fff'));
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <?php if (!empty($side['best_answer_user'])) : ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-cpf-slide">
                            <div class="panel-heading">
                                <h4>热门用户</h4>
                            </div>
                            <div class="panel-body">
                                <?php
                                foreach ($side['best_answer_user'] as $user)
                                {
                                    $this->sideUserList($user);
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif ?>
        </div>

    </div>
</div>


