<div class="container">
    <div class="row">
        <div class="col-md-9">
            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-cpf-default content-box">
                        <div class="panel-heading content-menu-title">
                            <img src="<?php echo $this->res('images/topic.png') ?>" alt="topic"/>
                            <h4>话题列表</h4>
                            <div style="padding-top:10px;">
                                <?php
                                foreach ($data['rootTopics'] as $t) {
                                    $class = 'btn btn-default btn-topic';
                                    if ($t['topic_id'] == $data['parent_topic_id']) {
                                        $class = $class . ' btn-topic-active';
                                    }

                                    $topicSpan = $this->htmlTag('span', array('@content' => $t['topic_name'], 'class' => $class));
                                    echo $this->a($topicSpan, $this->url('topics:index', array('topic_url' => $t['topic_url'])));
                                }
                                ?>
                            </div>
                        </div>

                        <div class="panel-body">
                            <?php
                            if (!empty($data['topicsList'])) {
                                foreach ($data['topicsList'] as $d) {

                                    if ($d['is_following']) {
                                        $url = $this->url('topics:unFollowing', array('topic_url' => $data['topic_url'], 'topic_id' => $d['topic_id']));
                                        $spanAttr = array('class' => 'btn btn-sm btn-followed', '@content' => '取消关注');
                                    } else {
                                        $url = $this->url('topics:following', array('topic_url' => $data['topic_url'], 'topic_id' => $d['topic_id']));
                                        $spanAttr = array('class' => 'btn btn-sm btn-un-follow', '@content' => '关注话题');
                                    }

                                    $followButton = $this->a($this->htmlTag('span', $spanAttr), $url);
                                    ?>
                                    <div class="child-topic-list">
                                        <div class="media">
                                            <div class="media-left">
                                                <a href="<?php echo $this->url('topics:detail', array('topic_url' => $d['topic_url'])) ?>">
                                                    <?php echo $this->topicSigns($d['topic_image']) ?>
                                                </a>
                                            </div>
                                            <div class="media-body">

                                                <div class="media">
                                                    <div class="media-body">
                                                        <h5 class="media-heading">
                                                            <a href="<?php echo $this->url('topics:detail', array('topic_url' => $d['topic_url'])) ?>">
                                                                <?php echo $d['topic_name'] ?>
                                                            </a>
                                                        </h5>
                                                        <div class="topic-description">
                                                            <?php echo !empty($d['topic_description']) ? $this->substr($d['topic_description'], 60) : '暂无描述'; ?>
                                                        </div>

                                                        <div class="visible-xs">
                                                            <div class="xs-topic-list-follow">
                                                                <?php echo $followButton ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="media-right media-middle hidden-xs">
                                                        <div class="topic-list-follow">
                                                            <?php echo $followButton ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                }
                            } else {
                                echo $this->block('暂无话题', array('style' => 'padding:5px'));
                            }
                            ?>
                        </div>

                        <div class="panel-footer">
                            <?php echo $this->page($data['page']) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-cpf-slide">
                <div class="panel-heading">
                    <h4>热门话题</h4>
                </div>
                <div class="panel-body">
                    <?php
                    if (!empty($data['hot_topic'])) {
                        foreach ($data['hot_topic'] as $d) {
                            $topic_name = $this->htmlTag('span', array('class' => '', '@content' => $d['topic_name']));
                            $topic_url = $this->url('topics:detail', array('topic_url' => $d['topic_url']));
                            ?>
                            <div class="row" style="padding:6px 0;">
                                <div class="col-xs-12">
                                    <div class="media">
                                        <a class="media-left media-middle" href="<?php echo $topic_url ?>">
                                            <?php echo $this->topicSigns($d['topic_image'], '42px') ?>
                                        </a>
                                        <div class="media-body">
                                            <div class="hot-topic-title">
                                                <a href="<?php echo $topic_url ?>" class="ia">
                                                    <?php echo $topic_name ?>
                                                </a>
                                            </div>
                                            <div class="small" style="color:#b9b9b9">
                                                关注: <?php echo $d['follow_count'] ?>
                                                主题: <?php echo $d['content_count'] ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    } else {
                        echo $this->block('暂无', array('style' => 'padding:0px'));
                    }
                    ?>
                </div>
            </div>
        </div>

    </div>
</div>
<?php
/**
 * @author wonli <wonli@live.com>
 * index.tpl.php
 */
