<?php
/**
 * @author wonli <wonli@live.com>
 * detail.tpl.php
 */
$page = &$data['page'];
$userInfo = &$data['account_info'];
$statistics = &$data['follow_statistics'];
$selfView = $data['uid'] == $userInfo['uid'];
$tab_data = &$data['tab_data'];
?>
<div class="userWrap">
    <div class="container">
        <div class="row">
            <div class="col-md-9 col-centered">
                <div class="row">
                    <div class="col-md-12 tac">
                        <?php echo $this->userAvatar($userInfo['avatar'], '96px') ?>
                        <h3><?php echo $userInfo['nickname'] ?></h3>
                        <p>
                            <?php echo $this->e($userInfo, 'introduce') ?>
                        </p>
                    </div>
                    <div class="col-md-12 tac">
                        <div class="row">
                            <div class="col-xs-6">
                                <div style="float:right">
                                    TA关注的
                                    <p id="ta_follow"><?php echo $this->e($statistics, 'me_follow_count') ?></p>
                                </div>
                            </div>
                            <div class="col-xs-6">
                                <div style="float:left">
                                    关注TA的
                                    <p id="follow_ta"><?php echo $this->e($statistics, 'follow_me_count') ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if (!$selfView) : ?>
                        <div class="col-md-12 tac">
                            <div class="row">
                                <div class="col-xs-6">
                                    <div style="float:right">
                                        <?php echo $this->userFollowButton($userInfo['uid'], $data['is_follow'], '#ta_follow', '#follow_ta') ?>
                                    </div>
                                </div>
                                <div class="col-xs-6">
                                    <div style="float:left">
                                        <?php echo $this->messageButton($userInfo['uid']) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif ?>
                </div>

                <div class="row tac">
                    <div class="col-md-12 user-content-tab">
                        <?php
                        $tab_data_count = count($tab_data);
                        $grid_split = 12 / $tab_data_count;
                        foreach ($tab_data as $action => $name) {
                            if ($action == $data['content_type']) {
                                $class = "tab col-xs-{$grid_split} current";
                            } else {
                                $class = "tab col-xs-{$grid_split}";
                            }

                            $a = $this->wrap('div', array('class' => $class))->html("<h3>{$name}</h3>");
                            echo $this->a($a, $this->url('user:detail', array(
                                'account' => $userInfo['account'],
                                'content_type' => $action
                            )), array('class' => ''));
                        }
                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <?php
                        if (!empty($data['content_list'])) {
                            $this->contentListSection($data['content_list'], 'user/segment');
                        } else {
                            $this->renderTpl('user/segment/empty');
                        }
                        ?>

                        <?php echo $this->page($page) ?>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
