<?php
/**
 * @author wonli <wonli@live.com>
 * reset-password.tpl.php
 */
$fields_config = array(
    'account' => array(
        'rule' => 'required;account;remote(' . $this->url('action:checkAccount') . ')',
        'tip' => '英文字母数字或下划线'
    ),
    'password' => array(
        'rule' => 'required;length(6~16)',
        'tip' => '请设置您的密码（6-16个字符）'
    ),
    'repeat_password' => array(
        'rule' => 'required;match(password)',
        'tip' => '请再输入一次密码',
    )
);
?>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-cpf-default">
                <div class="panel-heading">
                    <h4>重置登录密码</h4>
                </div>
                <div class="panel-body" style="min-height:200px;">
                    <form id="reset_password_form" class="form-horizontal" method="post" autocomplete="off">
                        <div class="form-group">
                            <label for="introduce" class="col-sm-2 control-label tal"></label>
                            <div class="col-sm-4 col-md-3 form-control-static">
                                <?php echo $data['nickname'] ?>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="password" class="col-sm-2 control-label tal">密码</label>
                            <div class="col-sm-4 col-md-3">
                                <input type="password" class="form-control" id="password"
                                       name="password" placeholder="请输入您的密码">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="repeat_password" class="col-sm-2 control-label tal">重复密码</label>
                            <div class="col-sm-4 col-md-3">
                                <input type="password" class="form-control" id="repeat_password"
                                       name="repeat_password" placeholder="请再次输入您的密码">
                            </div>
                        </div>

                        <div class="form-group" style="margin-bottom: 5px;margin-top: -10px;">
                            <div class="col-sm-2"></div>
                            <div class="col-sm-10 small validator-tips" style="margin:5px 0" id="validator-tips">
                                &nbsp;
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="col-sm-offset-2 col-sm-10">
                                <button type="submit" id="send" class="btn btn-primary">保存</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo $this->res('libs/nice-validator/0.10.11/jquery.validator.min.js?local=zh-CN') ?>"></script>
<script>
    $(function () {
        $('#reset_password_form').validator({
            msgMaker: function (opt) {
                $('#validator-tips').html('<span class="' + opt.type + '">' + opt.msg + "</span>");
            },
            fields: <?php echo json_encode($fields_config) ?>
        });
    })
</script>
