<!DOCTYPE html>
<html lang="zh-cn">
<head>
    <meta charset="utf-8">
    <meta name="renderer" content="webkit">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title><?php echo $this->getSeoInfo('title') ?></title>
    <meta name="Keywords" content="<?php echo $this->getSeoInfo('keywords') ?>"/>
    <meta name="Description" content="<?php echo $this->getSeoInfo('description') ?>"/>

    <!-- Bootstrap -->
    <link href="<?php echo $this->res('libs/bootstrap/3.3.7/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('icon/default/icon.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('css/main.css') ?>" rel="stylesheet">
    <link href="<?php echo $this->res('css/error.css') ?>" rel="stylesheet">
    <?php echo $this->loadRes('header') ?>

    <script src="<?php echo $this->res('libs/jquery/1.11.1/jquery.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/bootstrap/3.3.7/js/bootstrap.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/particleground/1.1.0/jquery.particleground.min.js') ?>"></script>

    <!--[if lt IE 9]>
    <script src="<?php echo $this->res('libs/html5shiv/3.7.2/html5shiv.min.js') ?>"></script>
    <script src="<?php echo $this->res('libs/respond.js/1.4.2/respond.min.js') ?>"></script>
    <![endif]-->
</head>
<body>
<div id="particles">
    <div class="intro">
        <div class="container">
            <div class="contentWrap">
                <div class="row">
                    <div class="col-md-12 col-centered tac">
                        <img src="<?php echo $this->res('images/logo.png') ?>" alt="logo"/>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 col-centered tac">
                        <h4><?php echo $this->siteConfig->get('introduce') ?></h4>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 col-centered tac exception-nav">
                        <?php $this->contentNavMenu('span', false, array('class' => 'ft18')) ?>
                    </div>
                </div>

                <div class="row" style="margin-top: 20px;">
                    <div class="col-md-12 col-centered tac">
                        <?php echo empty($content) ? "" : $content ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo empty($statistics_code) ? '' : $statistics_code; ?>
<script>
    $(document).ready(function () {
        $('#particles').particleground({
            dotColor: 'rgba(2, 134, 205, 0.5)',
            lineColor: 'rgba(230, 230, 230, 0.1)',
            density: 130000,
            proximity: 300,
            lineWidth: 1
        })
    });
</script>
</body>
</html>
