<?php
namespace app\index\controller;
use app\common\controller\HomeBase;

use app\admin\controller\Callback;


class Topic extends  HomeBase
{
	
	
	public function _initialize()
	{
		parent::_initialize();
	
	
		
	}


	public function index(){
	//获取话题页面
		 
	
		if(empty($this->param['name'])){
			$this->error('非法参数',es_url('index/index'));
		}
		$name = urldecode($this->param['name']);
		$groupinfo=self::$datalogic->setname('group')->getDataInfo(['name'=>$name]);
		
		if(!$groupinfo){
			$this->error('该话题已被删除',es_url('index/index'));
		}
		
		$this->assign('groupinfo',$groupinfo);
		
		//关注该话题的用户
		$memberlist=self::$datalogic->setname('user_focus')->getDataList(['m.sid'=>$groupinfo['id']],'m.*,user.nickname,user.userhead,user.grades','m.create_time desc',false,[['user|user','user.id=m.uid','LEFT']],'',20);
		$this->assign('memberlist',$memberlist);
		$focuscount = self::$datalogic->setname('user_focus')->getStat(['sid'=>$groupinfo['id']]);
		$this->assign('focuscount',$focuscount);
		
		//相似话题
		$grouplist=self::$datalogic->setname('group')->getDataList(['name|~'=>$name,'id|!'=>$groupinfo['id']],true,'create_time desc',false);
		$this->assign('grouplist',$grouplist);
		

		
		$uid=is_login();
		$this->assign('uid',$uid);
	
	


		return $this->fetch();
	
	}
	public function dongtai(){
		
		return $this->fetch();
		
	}
	
	public function gview(){
		if(empty($this->param['id'])){
			$this->error('非法参数',es_url('index/index'));
		}
		$id=$this->param['id'];
		$topicinfo=self::$datalogic->setname('topic')->getDataInfo(['m.id'=>$id],'m.*,user.nickname,user.statusdes,user.userhead,user.grades',[['user|user','user.id=m.uid','LEFT']],'','',false,'m');
		if(!$topicinfo){
			$this->error('该帖子已被删除',es_url('index/index'));
		}
		
		$uid=is_login();
		$this->assign('uid',$uid);
		self::$datalogic->setname('topic')->setIncOrDec(['id'=>$id],'view',1);//浏览数+1
		homeaction_log($uid, 2, $id);
		
		if($topicinfo['gidtext']){
		
			$htlist = explode(',', $topicinfo['gidtext']);//话题数组
			$this->assign('htlist',$htlist);
		}
		$topicinfo['hassc'] = user_has_focus($uid,$topicinfo['id'],1)?1:0;
		
		$focusinfo = db('user_focus','m')->where(['type'=>1,'sid'=>$topicinfo['id']])->field('m.*,user.nickname,user.userhead')->join(['user|user','user.id=m.uid','INNER'])->getList();
		
		$this->assign('focusinfo',$focusinfo);
		
		if($focusinfo){
		$topicinfo['focuscount'] = count($focusinfo);
		}else{
			$topicinfo['focuscount'] =0;
		}
		
		//智能推荐，目前非人工智能
		$znlist = db('topic')->where(['id|!'=>$topicinfo['id'],'choice'=>1])->order('update_time desc,create_time desc')->getList();
		$this->assign('znlist',$znlist);
		
		
		$topicinfo['commentcount'] = db('comment')->where(['pid'=>0,'fid'=>$topicinfo['id']])->count();
	
		$this->assign('topicinfo',$topicinfo);

	    
		$topicuserinfo =db('user')->where(['id'=>$topicinfo['uid']])->getRow();
		$topicuserinfo['fscount'] = db('user_focus')->where(['type'=>3,'sid'=>$topicinfo['uid']])->count();
		
		$rzuserinfo = db('rzuser')->where(['status'=>1,'uid'=>$topicinfo['uid']])->getRow();
		if($rzuserinfo){
			$topicuserinfo['rzuser'] =$rzuserinfo;
			if($rzuserinfo['type']==1){
				$topicuserinfo['rzicon'] = 'icon-myvip';
				
			}else{
				$topicuserinfo['rzicon'] = 'icon-myvip i-ve';
				
			}
		
		}else{
			$topicuserinfo['rzicon'] =1;
		}
		
		$this->assign('topicuserinfo',$topicuserinfo);



		
		
		//按照赞成数、关注人的评论和时间升序降序排列评论
		
		 
		empty($this->param['ctype']) ? $ctype =1 : $ctype = $this->param['ctype'];
		empty($this->param['asc']) ? $asc = 1 : $asc = $this->param['asc'];
		
		
	
		$where['m.pid']=0;
		$where['m.fid']=$id;

	
		if($ctype==1){
			if($asc==1){
				$asc=2;
				$order='m.create_time asc';
			}else{
				$asc=1;
				$order='m.create_time desc';
			}
			
		}elseif($ctype==2){
			
			if($asc==1){
				$asc=2;
				$order='m.ding asc';
			}else{
				$asc=1;
				$order='m.ding desc';
			}
		}else{
			
			$cidarr = db('user_focus')->where(['type'=>3,'uid'=>$uid])->column('sid');
			if($cidarr){
				$where['m.uid']=$cidarr;
			}else{
					$where['m.uid']=$cidarr;
			}
			
			$order='m.create_time desc';
			
		}
		$this->assign('ctype',$ctype);
		$this->assign('asc',$asc);
	
		$commentlist=self::$datalogic->setname('comment')->getDataList($where,'m.*,user.nickname,user.userhead,user.grades',$order,10,[['user|user','user.id=m.uid','LEFT']]);
	
		foreach ($commentlist['data'] as $k =>$v){
			
			$commentlist['data'][$k]['dinguser']= db('homeaction_log','m')->where(['sid'=>$v['id'],'type'=>9])->field('m.uid,user.nickname')->join(['user|user','user.id=m.uid'])->getList();
			
			$commentlist['data'][$k]['subcount'] = db('comment')->where(['pid'=>$v['id']])->count();
			 
		}
	
		$this->assign('commentlist',$commentlist['data']);
		$this->assign('commentlistpage',$commentlist['page']);
		$this->assign('commentlistcount',$commentlist['total']);

		return $this->fetch();
		 
	}
	
	
	public function commentadd(){
		
			$uid=is_login();
			$data=$this->param;
			$topicinfo=self::$datalogic->setname('topic')->getDataInfo(['id'=>$data['fid']]);
	
	
			if(empty($topicinfo)){
				$this->jump([RESULT_ERROR,'传参错误']);
			}
			if($uid==0){
				$this->jump([RESULT_ERROR,'您还未登录']);
			}
	
			$where['uid']=$uid;
			$where['fid']=$data['fid'];
	
	
			$cinfo = self::$datalogic->setname('comment')->getStat($where,'max','create_time');
			 
			if(time()-$cinfo<60){
				$this->jump([RESULT_ERROR,'两次评论时间过短']);
			}
			$data['uid']=$uid;
		
			$data['content']=htmlspecialchars_decode($data['content']);
	
			$data['floor']=0;
	
			if($data['pid']>0){
				self::$datalogic->setname('comment')->setIncOrDec(['id'=>$data['pid']],'reply',1);
				 
				if($this->param['pidcontent']!=0){
					$data['content']=$this->param['pidcontent'].$data['content'];
				}
				 
				 
			}else{
				 
				$floor=self::$datalogic->setname('comment')->getDataList(['pid'=>0,'fid'=>$data['fid']],true,'floor desc',false,'','',1);
				if($floor){
					$data['floor']=$floor[0]['floor']+1;
				}else{
					$data['floor']=2;
				}
			}
			
	
			$this->jump(self::$datalogic->setname('comment')->dataAdd($data,true,'','评论成功','',function($result,$data){
				homeaction_log($data['uid'], 12, $result);
		if($data['pid']==0){
			self::$datalogic->setname('topic')->setIncOrDec(['id'=>$data['fid']],'reply',1);
		}
	
	
	}));
		
	
	
	}


   
	public function topicadd() {
		if (IS_POST) {
			$uid = is_login ();
			
			$data = $this->param;
			if ($uid == 0) {
				
				$this->jump ( [ 
						RESULT_ERROR,
						'请先登录' 
				] );
			}
			if (self::$datalogic->setname ( 'user' )->getDataValue ( [ 
					'id' => $uid 
			], 'status' ) == 6) {
				
				$this->jump ( [ 
						RESULT_ERROR,
						'您已被禁言' 
				] );
			}
			$where['uid'] = $uid;
			$cinfo = self::$datalogic->setname('topic')->getStat($where,'max','create_time');
			
			if(time()-$cinfo<60){
			   $this->jump([RESULT_ERROR,'两次发帖时间过短']);
			}
			
			$data['content'] = htmlspecialchars_decode($data['content']);
			
			if(webconfig('bd_image')==1){
				$data ['content'] = getImageToLocal($data['content']);
			}
			
			
			
			$data ['uid'] = $uid;
			
			$htlist = $data ['gidtext'];
			
			if (! empty ( $htlist )) {
				
				$htarr = explode ( ',', $htlist );
				foreach ( $htarr as $key => $vo ) {
					
					$ginfo = db ( 'group' )->where ( [ 
							'name' => $vo 
					] )->getRow ();
					if ($ginfo) {
						self::$datalogic->setname ( 'group' )->setIncOrDec ( [ 
								'id' => $ginfo ['id'] 
						], 'topiccount', 1 );
					} else {
						
						$htdata ['status'] = 1;
						$htdata ['create_time'] = time ();
						$htdata ['name'] = $vo;
						$htdata ['topiccount'] = 1;
						$htdata ['uid'] = $uid;
						
						$result = db ( 'group' )->insert ( $htdata );
						
						
						
					}
				}
			}
			
			$this->jump ( self::$datalogic->setname ( 'topic' )->dataAdd ( $data, true, '', '帖子发布成功','',function($result,$data){
				
				homeaction_log($data['uid'], 11, $result);
				
			}) );
		} else {
			
			$cateinfo=self::$datalogic->setname('group')->getDataList(['status'=>1],true,'choice desc,sort desc,create_time asc',false,'','',20);
			$this->assign ( 'cateinfo', $cateinfo );
			$emotionlist = parse_config_attr ( webconfig ( 'emot_list' ) );
			$name='';
			!empty($this->param['name'])&&$name=urldecode($this->param['name']);
			$this->assign ( 'name', $name );
			
			$this->assign ( 'emotionlist', $emotionlist );
		}
		
		return $this->fetch ();
	}
	public function topicedit() {
		$uid = is_login ();
		
		if (IS_POST) {
			
			$data = $this->param;
			
			if ($uid == 0) {
				
				$this->jump ( [ 
						RESULT_ERROR,
						'请先登录' 
				] );
			}
			if (self::$datalogic->setname ( 'user' )->getDataValue ( [ 
					'id' => $uid 
			], 'status' ) == 6) {
				
				$this->jump ( [ 
						RESULT_ERROR,
						'您已被禁言' 
				] );
			}
			$info = self::$datalogic->setname ( 'topic' )->getDataInfo ( [ 
					'id' => $data ['id'] 
			] );
			$topic_limit_time = webconfig ( 'topic_limit_time' );
			switch ($topic_limit_time) {
				case 1 :
					$time = 'nolimit';
					break;
				case 2 :
					$time = 10 * 60;
					break;
				case 3 :
					$time = 24 * 60 * 60;
					break;
				case 4 :
					$time = 7 * 24 * 60 * 60;
					break;
				case 5 :
					$time = 30 * 24 * 60 * 60;
					break;
				default :
					$time = 'nolimit';
					break;
			}
			if ($info ['create_time'] > time () - $time || $time == 'nolimit') {
			} else {
				$this->jump ( [ 
						RESULT_ERROR,
						'已超过编辑时间' 
				] );
			}
			
			$data ['content'] = htmlspecialchars_decode ( $data ['content'] );
			if(webconfig('bd_image')==1){
				$data ['content'] = getImageToLocal($data['content']);
			}
			$nowhtlist = $info ['gidtext'];
			
			if (! empty ( $nowhtlist )) {
				$nowhtarr = explode ( ',', $nowhtlist );
				foreach ( $nowhtarr as $k => $v ) {
				
					
						self::$datalogic->setname ( 'group' )->setIncOrDec ( [
								'name' => $v
						], 'topiccount', 1, '-' );
					
				}
				
				
				
				
			} 
			
			$htlist = $data ['gidtext'];
			
			if (! empty ( $htlist )) {
				
				$htarr = explode ( ',', $htlist );
				foreach ( $htarr as $key => $vo ) {
					
						$ginfo = db ( 'group' )->where ( [ 
								'name' => $vo 
						] )->getRow ();
						if ($ginfo) {
							self::$datalogic->setname ( 'group' )->setIncOrDec ( [ 
									'id' => $ginfo ['id'] 
							], 'topiccount', 1 );
						} else {
							
							$htdata ['status'] = 1;
							$htdata ['create_time'] = time ();
							$htdata ['name'] = $vo;
							$htdata ['topiccount'] = 1;
							$htdata ['uid'] = $uid;
							
							db ( 'group' )->insert ( $htdata );
						}
					
				}
		
			}
			
			$this->jump ( self::$datalogic->setname ( 'topic' )->dataEdit ( $data, [ 
					'id' => $data ['id'] 
			] ) );
		} else {
			if (empty ( $this->param ['id'] )) {
				$this->error ( '非法参数', es_url ( 'index/index' ) );
			}
			$id = $this->param ['id'];
			
			$info = self::$datalogic->setname ( 'topic' )->getDataInfo ( [ 
					'id' => $id 
			] );
			if ($uid != $info ['uid']) {
			
				$this->error ( '无编辑权限', es_url ( 'index/index' ) );
			}
			$topic_limit_time = webconfig ( 'topic_limit_time' );
			
			switch ($topic_limit_time) {
				case 1 :
					$time = 'nolimit';
					break;
				case 2 :
					$time = 10 * 60;
					break;
				case 3 :
					$time = 24 * 60 * 60;
					break;
				case 4 :
					$time = 7 * 24 * 60 * 60;
					break;
				case 5 :
					$time = 30 * 24 * 60 * 60;
					break;
				default :
					$time = 'nolimit';
					break;
			}
			
			if ($info ['create_time'] > time () - $time || $time == 'nolimit') {
			} else {
				$this->jump ( [ 
						RESULT_ERROR,
						'已超过编辑时间' 
				] );
			}
			
			$cateinfo=self::$datalogic->setname('group')->getDataList(['status'=>1],true,'choice desc,sort desc,create_time asc',false,'','',20);
			$this->assign ( 'cateinfo', $cateinfo );
			
			$this->assign ( 'info', $info );
		}
		
		return $this->fetch ();
	}
public function topicsettop(){
	$id=$this->param['id'];
	$val=$this->param['val'];
	$groupid=$this->param['groupid'];
	
	$uid=is_login();
	
	if($uid==0){
		$this->jump(([RESULT_ERROR, '请登录后操作']));
	}else{
		$usergroupinfo = self::$datalogic->setname('user_group')->getDataInfo(['group_id'=>$groupid,'uid'=>$uid]);
		if($usergroupinfo['grade']>0){
			if($usergroupinfo['grade']==1&&$usergroupinfo['settop']!=1){
				//副组长根据权限进行编辑
				$this->jump(([RESULT_ERROR, '无操作权限']));
					
			}
		}else{
			$this->jump(([RESULT_ERROR, '无操作权限']));
		}
		$this->jump(self::$datalogic->setname('topic')->setDataValue(['id' => $id],'settop',$val));
	}
	
}
public function topicdele(){
	
	$id=$this->param['id'];
	$val=$this->param['val'];
	$groupid=$this->param['groupid'];

	$uid=is_login();
	
	if($uid==0){
		$this->jump(([RESULT_ERROR, '请登录后操作']));
	}else{
		$usergroupinfo = self::$datalogic->setname('user_group')->getDataInfo(['group_id'=>$groupid,'uid'=>$uid]);
		if($usergroupinfo['grade']>0){
			if($usergroupinfo['grade']==1&&$usergroupinfo['dele']!=1){
				//副组长根据权限进行编辑
				$this->jump(([RESULT_ERROR, '无操作权限']));
			
			}
		}else{
			$this->jump(([RESULT_ERROR, '无操作权限']));
		}
		
		//删除之前一定要更新小组的帖子数量
		self::$datalogic->setname('group')->setIncOrDec(['id'=>$groupid],'topiccount',1,'-');
		$this->jump(self::$datalogic->setname('topic')->dataDel(['id' => $id],'删除成功',true));
	}

}
public function mytopicdele(){
	$id=$this->param['id'];
	$info=self::$datalogic->setname('topic')->getDataInfo(['id'=>$id]);
	$uid=is_login();
	
	if($uid!=$info['uid']){
		$this->error('无编辑权限',es_url('user/index'));
	}
	
	if($info['gidtext']){
	
		$nn = explode(',', $info['gidtext']);
		foreach ($nn as $k =>$v){
			 
			self::$datalogic->setname('group')->setIncOrDec(['name'=>$v],'topiccount',1,'-');
			 
			 
			 
		}
	
	
	
	}
	homeaction_log($uid, 14, $id);
	
	$this->jump(self::$datalogic->setname('topic')->dataDel(['id' => $id],'删除成功',true));
}
public function topicsetchoice(){
	$id=$this->param['id'];
	$val=$this->param['val'];
	$groupid=$this->param['groupid'];
	
	$uid=is_login();
	
	if($uid==0){
		$this->jump(([RESULT_ERROR, '请登录后操作']));
	}else{
		$usergroupinfo = self::$datalogic->setname('user_group')->getDataInfo(['group_id'=>$groupid,'uid'=>$uid]);
		if($usergroupinfo['grade']>0){
			if($usergroupinfo['grade']==1&&$usergroupinfo['choice']!=1){
				//副组长根据权限进行编辑
				$this->jump(([RESULT_ERROR, '无操作权限']));
					
			}
		}else{
			$this->jump(([RESULT_ERROR, '无操作权限']));
		}
		$this->jump(self::$datalogic->setname('topic')->setDataValue(['id' => $id],'choice',$val));
	}

}

 
   public function htlist(){
   
   	empty($this->param['keyword'])?$keyword='':$keyword=$this->param['keyword'];
   	
   	$this->assign('keyword',$keyword);

   	
   	$groupcatelist=self::$datalogic->setname('groupcate')->getDataList(['pid'=>0,'status'=>1],true,'sort desc',false);
   	 
   	$this->assign('groupcatelist',$groupcatelist);
   	
   
   	empty($this->param['pid'])?$pid=0:$pid=$this->param['pid'];
   	$this->assign('pid',$pid);
   	
   	$where['status']=1;
   	$where['name|~']='%'.$keyword.'%';
   	
   	if($pid==0){
   		
   	}else{
   		$where['pid']=$pid;
   	}
   	$newhtlist=self::$datalogic->setname('group')->getDataList(['status'=>1,'create_time|>'=>time()-3600*24],true,'create_time desc',false,'','',10);
   	
   	$grouplist=self::$datalogic->setname('group')->getDataList($where,true,'choice desc,sort desc');
   	$this->assign('newhtlist',$newhtlist);
   
   	$this->assign('grouplist',$grouplist['data']);
   	$this->assign('grouplistpage',$grouplist['page']);
   	
   	return $this->fetch();
   
   }
  
}
