<?php

/*
* @package   s9e\TextFormatter
* @copyright Copyright (c) 2010-2016 The s9e Authors
* @license   http://www.opensource.org/licenses/mit-license.php The MIT License
*/
namespace s9e\TextFormatter\Plugins\MediaEmbed\Configurator\Collections;
class CachedDefinitionCollection extends SiteDefinitionCollection
{
	protected $items = array(
		'abcnews'=>array('extract'=>'!abcnews\\.go\\.com/[^/]+/video/[^/]+-(?\'id\'\\d+)!','host'=>'abcnews.go.com','iframe'=>array('height'=>'360','src'=>'//abcnews.go.com/video/embed?id={@id}','width'=>'640'),'name'=>'ABC News','tags'=>array('news')),
		'amazon'=>array('extract'=>array('#/(?:dp|gp/product)/(?\'id\'[A-Z0-9]+)#','#amazon\\.(?:co\\.)?(?\'tld\'ca|de|es|fr|it|jp|uk)#'),'host'=>array('amazon.ca','amazon.co.uk','amazon.co.jp','amazon.com','amazon.de','amazon.es','amazon.fr','amazon.it'),'iframe'=>array('height'=>'240','src'=>'//<xsl:choose><xsl:when test="@tld=\'es\'or@tld=\'it\'">rcm-eu.amazon-adsystem.com/e/cm?lt1=_blank&amp;bc1=FFFFFF&amp;bg1=FFFFFF&amp;fc1=000000&amp;lc1=0000FF&amp;p=8&amp;l=as1&amp;f=ifr&amp;asins=<xsl:value-of select="@id"/>&amp;o=<xsl:choose><xsl:when test="@tld=\'es\'">30</xsl:when><xsl:otherwise>29</xsl:otherwise></xsl:choose>&amp;t=<xsl:choose><xsl:when test="@tld=\'es\'and$AMAZON_ASSOCIATE_TAG_ES"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_ES"/></xsl:when><xsl:when test="@tld=\'it\'and$AMAZON_ASSOCIATE_TAG_IT"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_IT"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose></xsl:when><xsl:otherwise>ws-<xsl:choose><xsl:when test="@tld=\'jp\'">fe</xsl:when><xsl:when test="@tld and contains(\'desfrituk\',@tld)">eu</xsl:when><xsl:otherwise>na</xsl:otherwise></xsl:choose>.amazon-adsystem.com/widgets/q?ServiceVersion=20070822&amp;OneJS=1&amp;Operation=GetAdHtml&amp;MarketPlace=<xsl:choose><xsl:when test="@tld"><xsl:value-of select="translate(@tld,\'acdefijkprstu\',\'ACDEFIJBPRSTG\')"/></xsl:when><xsl:otherwise>US</xsl:otherwise></xsl:choose>&amp;ad_type=product_link&amp;tracking_id=<xsl:choose><xsl:when test="@tld=\'ca\'and$AMAZON_ASSOCIATE_TAG_CA"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_CA"/></xsl:when><xsl:when test="@tld=\'de\'and$AMAZON_ASSOCIATE_TAG_DE"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_DE"/></xsl:when><xsl:when test="@tld=\'fr\'and$AMAZON_ASSOCIATE_TAG_FR"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_FR"/></xsl:when><xsl:when test="@tld=\'jp\'and$AMAZON_ASSOCIATE_TAG_JP"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_JP"/></xsl:when><xsl:when test="@tld=\'uk\'and$AMAZON_ASSOCIATE_TAG_UK"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG_UK"/></xsl:when><xsl:when test="$AMAZON_ASSOCIATE_TAG"><xsl:value-of select="$AMAZON_ASSOCIATE_TAG"/></xsl:when><xsl:otherwise>_</xsl:otherwise></xsl:choose>&amp;marketplace=amazon&amp;region=<xsl:choose><xsl:when test="@tld"><xsl:value-of select="translate(@tld,\'acdefijkprstu\',\'ACDEFIJBPRSTG\')"/></xsl:when><xsl:otherwise>US</xsl:otherwise></xsl:choose>&amp;asins=<xsl:value-of select="@id"/>&amp;show_border=true&amp;link_opens_in_new_window=true</xsl:otherwise></xsl:choose>','width'=>'120'),'name'=>'Amazon Product'),
		'audioboom'=>array('extract'=>'!audioboo(?:\\.f|m\\.co)m/boos/(?\'id\'\\d+)!','host'=>array('audioboo.fm','audioboom.com'),'iframe'=>array('height'=>'150','max-width'=>'700','src'=>'//audioboom.com/boos/{@id}/embed/v3','width'=>'100%'),'name'=>'audioBoom','tags'=>array('podcasts')),
		'audiomack'=>array('choose'=>array('otherwise'=>array('iframe'=>array('height'=>'110','max-width'=>'900','src'=>'//www.audiomack.com/embed4/{@id}','width'=>'100%')),'when'=>array('iframe'=>array('height'=>'340','max-width'=>'900','src'=>'//www.audiomack.com/embed4-album/{@id}','width'=>'100%'),'test'=>'@mode=\'album\'')),'extract'=>'!audiomack\\.com/(?\'mode\'album|song)/(?\'id\'[-\\w]+/[-\\w]+)!','host'=>'audiomack.com','name'=>'Audiomack','tags'=>array('music')),
		'bandcamp'=>array('host'=>'bandcamp.com','iframe'=>array('height'=>'400','src'=>'//bandcamp.com/EmbeddedPlayer/size=large/minimal=true/<xsl:choose><xsl:when test="@album_id">album=<xsl:value-of select="@album_id"/><xsl:if test="@track_num">/t=<xsl:value-of select="@track_num"/></xsl:if></xsl:when><xsl:otherwise>track=<xsl:value-of select="@track_id"/></xsl:otherwise></xsl:choose>','width'=>'400'),'name'=>'Bandcamp','scrape'=>array(array('extract'=>'!/album=(?\'album_id\'\\d+)!','match'=>'!bandcamp\\.com/album/.!'),array('extract'=>array('!"album_id":(?\'album_id\'\\d+)!','!"track_num":(?\'track_num\'\\d+)!','!/track=(?\'track_id\'\\d+)!'),'match'=>'!bandcamp\\.com/track/.!')),'tags'=>array('music')),
		'bbcnews'=>array('host'=>'bbc.com','iframe'=>array('src'=>'//www.bbc.com<xsl:choose><xsl:when test="starts-with(@playlist,\'/news/\')and contains(@playlist,\'A\')"><xsl:value-of select="substring-before(@playlist,\'A\')"/></xsl:when><xsl:otherwise>/news/<xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>/embed'),'name'=>'BBC News','scrape'=>array('extract'=>'!bbc\\.com\\\\/news\\\\/(?\'id\'[-\\w]+)\\\\/embed!','match'=>'!bbc\\.com/news/\\w+!'),'tags'=>array('news')),
		'blab'=>array('extract'=>'#blab\\.im/(?!about$|live$|replay$|scheduled$|search\\?)(?\'id\'[-\\w]+)#','host'=>'blab.im','iframe'=>array('height'=>'400','src'=>'https://blab.im/{@id}','width'=>'400'),'name'=>'Blab','tags'=>array('social')),
		'bleacherreport'=>array('host'=>'bleacherreport.com','iframe'=>array('height'=>'360','src'=>'//bleacherreport.com/video_embed?id={@id}','width'=>'640'),'name'=>'Bleacher Report videos','scrape'=>array('extract'=>'!id="video-(?\'id\'[-\\w]+)!','match'=>'!/articles/.!'),'tags'=>array('sports')),
		'break'=>array('extract'=>'!break\\.com/video/.*-(?\'id\'\\d+)$!','host'=>'break.com','iframe'=>array('height'=>'280','src'=>'//break.com/embed/{@id}','width'=>'464'),'name'=>'Break','tags'=>array('entertainment')),
		'brightcove'=>array('host'=>array('bcove.me','link.brightcove.com'),'iframe'=>array('src'=>'https://link.brightcove.com/services/player/bcpid{@bcpid}?bckey={@bckey}&bctid={@bctid}&secureConnections=true&secureHTMLConnections=true&autoStart=false&height=100%25&width=100%25'),'name'=>'Brightcove','scrape'=>array('extract'=>'!meta name="twitter:player" content=".*?bcpid(?\'bcpid\'\\d+).*?bckey=(?\'bckey\'[-,~\\w]+).*?bctid=(?\'bctid\'\\d+)!','match'=>array('!bcove\\.me/.!','!link\\.brightcove\\.com/services/player/!')),'tags'=>array('videos')),
		'cbsnews'=>array('attributes'=>array('id'=>array('required'=>'false')),'choose'=>array('otherwise'=>array('flash'=>array('flashvars'=>'si=254&contentValue={@id}','padding-height'=>'40','src'=>'//i.i.cbsi.com/cnwk.1d/av/video/cbsnews/atlantis2/cbsnews_player_embed.swf')),'when'=>array('flash'=>array('flashvars'=>'pType=embed&si=254&pid={@pid}','padding-height'=>'38','src'=>'//www.cbsnews.com/common/video/cbsnews_player.swf'),'test'=>'@pid')),'extract'=>'#cbsnews\\.com/video/watch/\\?id=(?\'id\'\\d+)#','host'=>'cbsnews.com','name'=>'CBS News Video','scrape'=>array('extract'=>'#"pid":"(?\'pid\'\\w+)"#','match'=>'#cbsnews\\.com/videos/(?!watch/)#'),'tags'=>array('news')),
		'cnbc'=>array('extract'=>'!cnbc\\.com/gallery/\\?video=(?\'id\'\\d+)!','flash'=>array('height'=>'380','src'=>'//plus.cnbc.com/rssvideosearch/action/player/id/{@id}/code/cnbcplayershare','width'=>'400'),'host'=>'video.cnbc.com','name'=>'CNBC','tags'=>array('news')),
		'cnn'=>array('extract'=>array('!cnn.com/videos/(?\'id\'.*\\.cnn)!','!cnn\\.com/video/data/2\\.0/video/(?\'id\'.*\\.cnn)!'),'host'=>'cnn.com','iframe'=>array('src'=>'//edition.cnn.com/video/api/embed.html#/video/{@id}'),'name'=>'CNN','tags'=>array('news')),
		'cnnmoney'=>array('extract'=>'!money\\.cnn\\.com/video/(?\'id\'.*\\.cnnmoney)!','host'=>'money.cnn.com','iframe'=>array('height'=>'360','src'=>'//money.cnn.com/.element/ssi/video/7.0/players/embed.player.html?videoid=video/{@id}&width=560&height=360','width'=>'560'),'name'=>'CNNMoney','tags'=>array('news')),
		'collegehumor'=>array('extract'=>'!collegehumor\\.com/(?:video|embed)/(?\'id\'\\d+)!','host'=>'collegehumor.com','iframe'=>array('height'=>'369','src'=>'//www.collegehumor.com/e/{@id}','width'=>'600'),'name'=>'CollegeHumor','tags'=>array('entertainment')),
		'comedycentral'=>array('host'=>array('cc.com','comedycentral.com'),'iframe'=>array('height'=>'360','src'=>'//media.mtvnservices.com/embed/{@id}','width'=>'640'),'name'=>'Comedy Central','scrape'=>array('extract'=>'!(?\'id\'mgid:arc:(?:episode|video):[.\\w]+:[-\\w]+)!','match'=>'!c(?:c|omedycentral)\\.com/(?:full-episode|video-clip)s/!'),'tags'=>array('entertainment')),
		'coub'=>array('extract'=>'!coub\\.com/view/(?\'id\'\\w+)!','host'=>'coub.com','iframe'=>array('src'=>'//coub.com/embed/{@id}'),'name'=>'Coub','tags'=>array('videos')),
		'dailymotion'=>array('extract'=>'!dailymotion\\.com/(?:live/|swf/|user/[^#]+#video=|(?:related/\\d+/)?video/)(?\'id\'[A-Za-z0-9]+)!','host'=>'dailymotion.com','iframe'=>array('src'=>'//www.dailymotion.com/embed/video/{@id}'),'name'=>'Dailymotion','tags'=>array('videos')),
		'democracynow'=>array('extract'=>'!democracynow.org/(?:embed/)?(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)!','host'=>'democracynow.org','iframe'=>array('height'=>'360','src'=>'//www.democracynow.org/embed/<xsl:choose><xsl:when test="contains(@id,\'/headlines\')">headlines/<xsl:value-of select="substring-before(@id,\'/headlines\')"/></xsl:when><xsl:when test="starts-with(@id,\'2\')">story/<xsl:value-of select="@id"/></xsl:when><xsl:when test="starts-with(@id,\'shows/\')">show/<xsl:value-of select="substring-after(@id,\'/\')"/></xsl:when><xsl:otherwise><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>','width'=>'640'),'name'=>'Democracy Now!','scrape'=>array('extract'=>'!democracynow\\.org/(?\'id\'(?:\\w+/)?\\d+/\\d+/\\d+(?:/\\w+)?)\' rel=\'canonical!','match'=>'!m\\.democracynow\\.org/stories/\\d!')),
		'dumpert'=>array('extract'=>'!dumpert\\.nl/mediabase/(?\'id\'\\d+[/_]\\w+)!','host'=>'dumpert.nl','iframe'=>array('src'=>'//www.dumpert.nl/embed/{translate(@id,\'_\',\'/\')}/'),'name'=>'dumpert','tags'=>array('.nl','entertainment')),
		'eighttracks'=>array('extract'=>'!8tracks\\.com/[-\\w]+/(?\'id\'\\d+)(?=#|$)!','host'=>'8tracks.com','iframe'=>array('height'=>'400','src'=>'//8tracks.com/mixes/{@id}/player_v3_universal','width'=>'400'),'name'=>'8tracks','scrape'=>array('extract'=>'!eighttracks://mix/(?\'id\'\\d+)!','match'=>'!8tracks\\.com/[-\\w]+/[-\\w]+!'),'tags'=>array('music')),
		'espn'=>array('extract'=>'#video/(?:clip(?:\\?id=|/_/id/))?(?\'id\'\\d+)#','host'=>array('espn.com','espn.go.com'),'iframe'=>array('src'=>'//www.espn.com/core/video/iframe?id={@id}'),'name'=>'ESPN','tags'=>array('sports')),
		'facebook'=>array('extract'=>array('@/(?!(?:apps|developers|graph)\\.)[-\\w.]*facebook\\.com/(?:[/\\w]+/permalink|(?!pages/|groups/).*?)(?:/|fbid=|\\?v=)(?\'id\'\\d+)(?=$|[/?&#])@','#/(?\'type\'video)s?/#'),'host'=>'facebook.com','iframe'=>array('onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/facebook.min.html#{@type}{@id}'),'name'=>'Facebook','tags'=>array('social')),
		'flickr'=>array('extract'=>'!flickr\\.com/photos/[^/]+/(?\'id\'\\d+)!','host'=>'flickr.com','iframe'=>array('height'=>'500','src'=>'https://www.flickr.com/photos/_/{@id}/player/','width'=>'500'),'name'=>'Flickr','tags'=>array('images')),
		'foratv'=>array('host'=>'fora.tv','iframe'=>array('src'=>'//library.fora.tv/embed?id={@id}&type=c'),'name'=>'FORA.tv','scrape'=>array('extract'=>'!embed\\?id=(?\'id\'\\d+)!','match'=>'!fora\\.tv/\\d+/\\d+/\\d+/.!')),
		'foxnews'=>array('extract'=>'!video\\.foxnews\\.com/v/(?\'id\'\\d+)!','host'=>'video.foxnews.com','iframe'=>array('src'=>'//video.foxnews.com/v/video-embed.html?video_id={@id}'),'name'=>'Fox News','tags'=>array('news')),
		'funnyordie'=>array('extract'=>'!funnyordie\\.com/videos/(?\'id\'[0-9a-f]+)!','host'=>'funnyordie.com','iframe'=>array('height'=>'360','src'=>'//www.funnyordie.com/embed/{@id}','width'=>'640'),'name'=>'Funny or Die','tags'=>array('entertainment')),
		'gamespot'=>array('extract'=>'!gamespot\\.com.*?/(?:events|videos)/.*?-(?\'id\'\\d+)/(?:[#?].*)?$!','host'=>'gamespot.com','iframe'=>array('height'=>'400','src'=>'//www.gamespot.com/videos/embed/{@id}/','width'=>'640'),'name'=>'Gamespot','tags'=>array('gaming')),
		'gametrailers'=>array('host'=>'gametrailers.com','iframe'=>array('height'=>'360','src'=>'<xsl:choose><xsl:when test="starts-with(@id,\'mgid:\')">//media.mtvnservices.com/embed/<xsl:value-of select="@id"/></xsl:when><xsl:otherwise>//embed.gametrailers.com/embed/<xsl:value-of select="@id"/>?embed=1&amp;suppressBumper=1</xsl:otherwise></xsl:choose>','width'=>'640'),'name'=>'GameTrailers','scrape'=>array('extract'=>'!embed/(?\'id\'\\d+)!','match'=>'!gametrailers\\.com/(?:full-episode|review|video)s/!'),'tags'=>array('gaming')),
		'getty'=>array('attributes'=>array('height'=>array('defaultValue'=>'360'),'width'=>array('defaultValue'=>'640')),'extract'=>array('!gty\\.im/(?\'id\'\\d+)!','!gettyimages\\.[.\\w]+/detail(?=/).*?/(?\'id\'\\d+)!','!#[-\\w]*picture-id(?\'id\'\\d+)$!'),'host'=>array('gettyimages.be','gettyimages.cn','gettyimages.co.jp','gettyimages.co.uk','gettyimages.com','gettyimages.com.au','gettyimages.de','gettyimages.dk','gettyimages.es','gettyimages.fr','gettyimages.ie','gettyimages.it','gettyimages.nl','gettyimages.pt','gettyimages.se','gty.im'),'iframe'=>array('height'=>'{@height}','padding-height'=>'49','src'=>'//embed.gettyimages.com/embed/{@id}?et={@et}&sig={@sig}','width'=>'{@width}'),'name'=>'Getty Images','scrape'=>array('extract'=>array('!"height":[ "]*(?\'height\'\\d+)!','!"width":[ "]*(?\'width\'\\d+)!','!et=(?\'et\'[-=\\w]+)!','!sig=(?\'sig\'[-=\\w]+)!'),'url'=>'http://embed.gettyimages.com/preview/{@id}'),'tags'=>array('images')),
		'gfycat'=>array('attributes'=>array('height'=>array('defaultValue'=>'315'),'width'=>array('defaultValue'=>'560')),'extract'=>'!gfycat\\.com/(?\'id\'\\w+)!','host'=>'gfycat.com','iframe'=>array('height'=>'{@height}','src'=>'//gfycat.com/iframe/{@id}','width'=>'{@width}'),'name'=>'Gfycat','scrape'=>array('extract'=>array('!video:height" content="(?\'height\'\\d+)!','!video:width" content="(?\'width\'\\d+)!'),'url'=>'http://gfycat.com/{@id}'),'tags'=>array('images')),
		'gist'=>array('extract'=>'!gist\\.github\\.com/(?\'id\'(?:\\w+/)?[\\da-f]+(?:/[\\da-f]+)?)!','host'=>'github.com','iframe'=>array('height'=>'180','onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','scrolling'=>'','src'=>'https://s9e.github.io/iframe/gist.min.html#{@id}','width'=>'100%'),'name'=>'GitHub Gist (via custom iframe)'),
		'globalnews'=>array('extract'=>'!globalnews\\.ca/video/(?\'id\'\\d+)!','host'=>'globalnews.ca','iframe'=>array('height'=>'377','src'=>'//globalnews.ca/video/embed/{@id}/','width'=>'560'),'name'=>'Global News','tags'=>array('.ca','news')),
		'gofundme'=>array('extract'=>'@gofundme\\.com/(?\'id\'\\w+)(?![^#?])@','flash'=>array('flashvars'=>'page={@id}','height'=>'338','src'=>'//funds.gofundme.com/Widgetflex.swf','width'=>'258'),'host'=>'gofundme.com','name'=>'GoFundMe','tags'=>array('fundraising')),
		'googledrive'=>array('extract'=>'!drive\\.google\\.com/.*?file/d/(?\'id\'[-\\w]+)!','host'=>'drive.google.com','iframe'=>array('height'=>'480','src'=>'//drive.google.com/file/d/{@id}/preview','width'=>'640'),'name'=>'Google Drive','tags'=>array('documents','images','videos')),
		'googleplus'=>array('attributes'=>array('name'=>array('postFilter'=>'urldecode')),'extract'=>'!//plus\\.google\\.com/(?:u/\\d+/)?(?:\\+(?\'name\'[^/]+)|(?\'oid\'\\d+))/posts/(?\'pid\'\\w+)!','host'=>'plus.google.com','iframe'=>array('height'=>'240','onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/googleplus.min.html#<xsl:choose><xsl:when test="@oid"><xsl:value-of select="@oid"/></xsl:when><xsl:otherwise>+<xsl:value-of select="@name"/></xsl:otherwise></xsl:choose>/posts/<xsl:value-of select="@pid"/>','width'=>'450'),'name'=>'Google+','tags'=>array('social')),
		'googlesheets'=>array('extract'=>'!docs\\.google\\.com/spreadsheet(?:/ccc\\?key=|s/d/)(?\'id\'[-\\w]+)[^#]*(?:#gid=(?\'gid\'\\d+))?!','host'=>'docs.google.com','iframe'=>array('height'=>'500','src'=>'https://docs.google.com/spreadsheet/ccc?key={@id}&widget=true&headers=false&rm=minimal#gid={@gid}','style'=>array('resize'=>'vertical'),'width'=>'100%'),'name'=>'Google Sheets','tags'=>array('documents')),
		'healthguru'=>array('host'=>'healthguru.com','iframe'=>array('src'=>'//www.healthguru.com/embed/{@id}'),'name'=>'Healthguru','scrape'=>array('extract'=>'!healthguru\\.com/embed/(?\'id\'\\w+)!','match'=>'!healthguru\\.com/(?:content/)?video/.!'),'tags'=>array('health')),
		'hudl'=>array('extract'=>array('!hudl\\.com/athlete/(?\'athlete\'\\d+)/highlights/(?\'highlight\'[\\da-f]+)!','!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!'),'host'=>'hudl.com','iframe'=>array('height'=>'360','src'=>'//www.hudl.com/embed/athlete/{@athlete}/highlights/{@highlight}','width'=>'640'),'name'=>'Hudl','scrape'=>array('extract'=>'!hudl\\.com/video/\\d+/(?\'athlete\'\\d+)/(?\'highlight\'[\\da-f]+)!','match'=>'!hudl\\.com/v/!'),'tags'=>array('sports')),
		'hulu'=>array('host'=>'hulu.com','iframe'=>array('height'=>'360','src'=>'https://secure.hulu.com/embed/{@id}','width'=>'640'),'name'=>'Hulu','scrape'=>array('extract'=>'!eid=(?\'id\'[-\\w]+)!','match'=>'!hulu\\.com/watch/!')),
		'humortvnl'=>array('extract'=>'!humortv\\.vara\\.nl/\\w+\\.(?\'id\'[-.\\w]+)\\.html!','host'=>'humortv.vara.nl','iframe'=>array('src'=>'//humortv.vara.nl/embed.{@id}.html'),'name'=>'HumorTV','tags'=>array('.nl','entertainment')),
		'ign'=>array('extract'=>'!(?\'id\'https?://.*?ign\\.com/videos/.+)!','host'=>'ign.com','iframe'=>array('height'=>'263','src'=>'//widgets.ign.com/video/embed/content.html?url={@id}','width'=>'468'),'name'=>'IGN','tags'=>array('gaming')),
		'imdb'=>array('extract'=>'!imdb\\.com/[/\\w]+/vi(?\'id\'\\d+)!','host'=>'imdb.com','iframe'=>array('src'=>'//www.imdb.com/video/imdb/vi{@id}/imdb/embed?autoplay=false&width=640'),'name'=>'IMDb','tags'=>array('movies')),
		'imgur'=>array('attributes'=>array('type'=>array('type'=>'alnum')),'extract'=>'@imgur\\.com/(?!r/|user/)(?:gallery/)?(?\'id\'(?:a/)?\\w+)(?!\\w|\\.(?:pn|jp)g)@','host'=>'imgur.com','iframe'=>array('height'=>'450','onload'=>'var b=Math.random();window.addEventListener(\'message\',function(a){{a.data.id==b&&(style.height=a.data.height+\'px\',style.width=a.data.width+\'px\')}});contentWindow.postMessage(\'s9e:\'+b,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/imgur.min.html#<xsl:if test="@type=\'album\'and not(starts-with(@id,\'a/\'))">a/</xsl:if><xsl:value-of select="@id"/>','width'=>'568'),'name'=>'Imgur','scrape'=>array('extract'=>array('!image\\s*:\\s*.*?"is_(?\'type\'album)":true!','!<div id="(?\'type\'album)-!','!class="(?\'type\'album)-image!'),'match'=>'@imgur\\.com/gallery/\\w@'),'tags'=>array('images')),
		'indiegogo'=>array('extract'=>'!indiegogo\\.com/projects/(?\'id\'[-\\w]+)!','host'=>'indiegogo.com','iframe'=>array('height'=>'445','src'=>'//www.indiegogo.com/project/{@id}/embedded','width'=>'222'),'name'=>'Indiegogo','tags'=>array('fundraising')),
		'instagram'=>array('extract'=>'!instagram\\.com/p/(?\'id\'[-\\w]+)!','host'=>'instagram.com','iframe'=>array('height'=>'640','onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/instagram.min.html#{@id}','width'=>'640'),'name'=>'Instagram','tags'=>array('social')),
		'internetarchive'=>array('attributes'=>array('height'=>array('defaultValue'=>'360'),'width'=>array('defaultValue'=>'640')),'host'=>'archive.org','iframe'=>array('height'=>'{@height}','src'=>'https://archive.org/embed/{@id}','width'=>'{@width}'),'name'=>'Internet Archive','scrape'=>array('extract'=>array('!meta property="twitter:player" content="https://archive.org/embed/(?\'id\'[^/"]+)!','!meta property="og:video:width" content="(?\'width\'\\d+)!','!meta property="og:video:height" content="(?\'height\'\\d+)!'),'match'=>'!archive\\.org/details/!')),
		'izlesene'=>array('extract'=>'!izlesene\\.com/video/[-\\w]+/(?\'id\'\\d+)!','host'=>'izlesene.com','iframe'=>array('src'=>'//www.izlesene.com/embedplayer/{@id}'),'name'=>'İzlesene','tags'=>array('.tr')),
		'jwplatform'=>array('extract'=>'!jwplatform\\.com/\\w+/(?\'id\'[-\\w]+)!','host'=>'jwplatform.com','iframe'=>array('src'=>'//content.jwplatform.com/players/{@id}.html'),'name'=>'JW Platform','tags'=>array('videos')),
		'khl'=>array('host'=>'video.khl.ru','iframe'=>array('src'=>'//video.khl.ru/iframe/feed/start/{@id}?type_id=18&width=560&height=315'),'name'=>'Kontinental Hockey League (КХЛ)','scrape'=>array('extract'=>'!/feed/start/(?\'id\'[/\\w]+)!','match'=>'!video\\.khl\\.ru/(?:event|quote)s/\\d!'),'tags'=>array('.ru','sports')),
		'kickstarter'=>array('choose'=>array('otherwise'=>array('iframe'=>array('height'=>'420','src'=>'//www.kickstarter.com/projects/{@id}/widget/card.html','width'=>'220')),'when'=>array('iframe'=>array('height'=>'360','src'=>'//www.kickstarter.com/projects/{@id}/widget/video.html','width'=>'480'),'test'=>'@video')),'extract'=>'!kickstarter\\.com/projects/(?\'id\'[^/]+/[^/?]+)(?:/widget/(?:(?\'card\'card)|(?\'video\'video)))?!','host'=>'kickstarter.com','name'=>'Kickstarter','tags'=>array('fundraising')),
		'kissvideo'=>array('extract'=>'!kissvideo\\.click/[^_]*_(?\'id\'[0-9a-f]+)!','host'=>'kissvideo.click','iframe'=>array('height'=>'360','src'=>'//www.kissvideo.click/embed.php?vid={@id}','width'=>'640'),'name'=>'Kiss Video','tags'=>array('videos')),
		'libsyn'=>array('host'=>'libsyn.com','iframe'=>array('height'=>'45','max-width'=>'900','src'=>'//html5-player.libsyn.com/embed/episode/id/{@id}/height/45/width/900/theme/standard/direction/no/autoplay/no/autonext/no/thumbnail/no/preload/no/no_addthis/no/','width'=>'100%'),'name'=>'Libsyn','scrape'=>array('extract'=>'!embed/episode/id/(?\'id\'\\d+)!','match'=>'@(?!\\.mp3)....$@'),'tags'=>array('podcasts')),
		'livecap'=>array('extract'=>'!livecap.tv/[st]/(?\'channel\'\\w+)/(?\'id\'\\w+)!','host'=>'livecap.tv','iframe'=>array('height'=>'360','src'=>'https://www.livecap.tv/s/embed/{@channel}/{@id}','width'=>'640'),'name'=>'LiveCap','tags'=>array('gaming')),
		'liveleak'=>array('extract'=>'!liveleak\\.com/view\\?i=(?\'id\'[a-f_0-9]+)!','host'=>'liveleak.com','iframe'=>array('height'=>'360','src'=>'//www.liveleak.com/ll_embed?i={@id}','width'=>'640'),'name'=>'LiveLeak','tags'=>array('videos')),
		'livestream'=>array('extract'=>array('!livestream\\.com/accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!','!/videos/(?\'video_id\'\\d+)!','!original\\.livestream\\.com/(?\'channel\'\\w+)/video\\?clipId=(?\'clip_id\'[-\\w]+)!'),'host'=>array('livestre.am','livestream.com'),'iframe'=>array('height'=>'360','src'=>'<xsl:choose><xsl:when test="@clip_id">//cdn.livestream.com/embed/<xsl:value-of select="@channel"/>?layout=4&amp;autoplay=false&amp;clip=<xsl:value-of select="@clip_id"/></xsl:when><xsl:otherwise>//livestream.com/accounts/<xsl:value-of select="@account_id"/>/events/<xsl:value-of select="@event_id"/><xsl:if test="@video_id">/videos/<xsl:value-of select="@video_id"/></xsl:if>/player?autoPlay=false</xsl:otherwise></xsl:choose>','width'=>'640'),'name'=>'Livestream','scrape'=>array(array('extract'=>'!accounts/(?\'account_id\'\\d+)/events/(?\'event_id\'\\d+)!'),array('extract'=>'!//original\\.livestream\\.com/(?\'channel\'\\w+)/video/(?\'clip_id\'[-\\w]+)!','match'=>'!livestre.am!')),'tags'=>array('videos')),
		'mailru'=>array('host'=>'my.mail.ru','iframe'=>array('height'=>'342','src'=>'//videoapi.my.mail.ru/videos/embed/{@id}.html','width'=>'560'),'name'=>'Mail.Ru','scrape'=>array('extract'=>'!mail\\.ru/video/(?\'id\'[/\\w]+)\\.html!','match'=>'!my\\.mail\\.ru/\\w+/\\w+/video/\\w+/\\d!'),'tags'=>array('.ru')),
		'medium'=>array('extract'=>'!medium\\.com/[^/]*/(?:[-\\w]+-)?(?\'id\'[\\da-f]+)!','host'=>'medium.com','iframe'=>array('height'=>'400','onload'=>'window.addEventListener(\'message\',function(a){{a=a.data.split(\'::\');\'m\'===a[0]&&0<src.indexOf(a[1])&&a[2]&&(style.height=a[2]+\'px\')}})','src'=>'https://api.medium.com/embed?type=story&path=%2F%2F{@id}&id={translate(@id,\'abcdef\',\'111111\')}','style'=>array('border'=>'1px solid','border-color'=>'#eee #ddd #bbb','border-radius'=>'5px','box-shadow'=>'rgba(0,0,0,.15) 0 1px 3px'),'width'=>'400'),'name'=>'Medium','tags'=>array('blogging')),
		'metacafe'=>array('extract'=>'!metacafe\\.com/watch/(?\'id\'\\d+)!','host'=>'metacafe.com','iframe'=>array('src'=>'//www.metacafe.com/embed/{@id}/'),'name'=>'Metacafe','tags'=>array('videos')),
		'mixcloud'=>array('extract'=>'@mixcloud\\.com/(?!categories|tag)(?\'id\'[-\\w]+/[^/&]+)/@','host'=>'mixcloud.com','iframe'=>array('height'=>'400','src'=>'//www.mixcloud.com/widget/iframe/?feed=http%3A%2F%2Fwww.mixcloud.com%2F{@id}%2F&embed_type=widget_standard','width'=>'400'),'name'=>'Mixcloud','tags'=>array('music')),
		'mlb'=>array('extract'=>array('#mlb\\.com/[\\w/]*/v(?\'id\'\\d+)#','#mlb\\.com/r/video\\?content_id=(?\'id\'\\d+)#'),'host'=>'mlb.com','iframe'=>array('src'=>'//m.mlb.com/shared/video/embed/embed.html?content_id={@id}&width=640&height=360'),'name'=>'MLB','tags'=>array('sports')),
		'mrctv'=>array('host'=>'mrctv.org','iframe'=>array('src'=>'https://www.mrctv.org/embed/{@id}'),'name'=>'MRCTV','scrape'=>array('extract'=>'!mrctv\\.org/embed/(?\'id\'\\d+)!','match'=>'!mrctv\\.org/videos/.!')),
		'msnbc'=>array('host'=>'msnbc.com','iframe'=>array('height'=>'440','src'=>'//player.theplatform.com/p/2E2eJC/EmbeddedOffSite?guid={@id}','width'=>'635'),'name'=>'MSNBC','scrape'=>array('extract'=>'@guid="?(?\'id\'\\w+)@','match'=>array('@msnbc\\.com/[-\\w]+/watch/@','@on\\.msnbc\\.com/.@')),'tags'=>array('news')),
		'natgeochannel'=>array('extract'=>'@channel\\.nationalgeographic\\.com/(?\'id\'[-/\\w]+/videos/[-\\w]+)@','host'=>'channel.nationalgeographic.com','iframe'=>array('src'=>'//channel.nationalgeographic.com/{@id}/embed/'),'name'=>'National Geographic Channel'),
		'natgeovideo'=>array('host'=>'video.nationalgeographic.com','iframe'=>array('src'=>'//player.d.nationalgeographic.com/players/ngsvideo/share/?guid={@id}'),'name'=>'National Geographic Video','scrape'=>array('extract'=>'@guid="(?\'id\'[-\\w]+)"@','match'=>'@video\\.nationalgeographic\\.com/(?:tv|video)/\\w@'),'tags'=>array('documentaries')),
		'nbcnews'=>array('extract'=>'!nbcnews\\.com/(?:widget/video-embed/|video/[-\\w]+?-)(?\'id\'\\d+)!','host'=>'nbcnews.com','iframe'=>array('src'=>'//www.nbcnews.com/widget/video-embed/{@id}'),'name'=>'NBC News','tags'=>array('news')),
		'nbcsports'=>array('host'=>'nbcsports.com','iframe'=>array('src'=>'//vplayer.nbcsports.com/p/BxmELC/nbcsports_embed/select/media/{@id}?parentUrl='),'name'=>'NBC Sports','scrape'=>array('extract'=>'!select/media/(?\'id\'\\w+)!','match'=>'!nbcsports\\.com/video/.!'),'tags'=>array('sports')),
		'nhl'=>array('attributes'=>array('id'=>array('required'=>'false')),'extract'=>array('#nhl\\.com/videocenter/.*?\\Wid=(?\'id\'[-\\w]+)#','#nhl\\.com/(?:\\w+/)?video(?:/(?![ct]-)[-\\w]+)?(?:/t-(?\'t\'\\d+))?(?:/c-(?\'c\'\\d+))?#'),'host'=>'nhl.com','iframe'=>array('height'=>'360','src'=>'<xsl:choose><xsl:when test="@c or@t">//www.nhl.com/video/embed<xsl:if test="@t">/t-<xsl:value-of select="@t"/></xsl:if><xsl:if test="@c">/c-<xsl:value-of select="@c"/></xsl:if>?autostart=false</xsl:when><xsl:otherwise>//video.nhl.com/videocenter/embed?playlist=<xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>','width'=>'640'),'name'=>'NHL Videos and Highlights','tags'=>array('sports')),
		'npr'=>array('host'=>array('npr.org','n.pr'),'iframe'=>array('height'=>'228','max-width'=>'800','src'=>'//www.npr.org/player/embed/{@i}/{@m}','width'=>'100%'),'name'=>'NPR','scrape'=>array('extract'=>'!player/embed/(?\'i\'\\d+)/(?\'m\'\\d+)!','match'=>array('!npr\\.org/[/\\w]+/\\d+!','!n\\.pr/\\w!')),'tags'=>array('podcasts')),
		'nytimes'=>array('extract'=>array('!nytimes\\.com/video/[a-z]+/(?:[a-z]+/)?(?\'id\'\\d+)!','!nytimes\\.com/video/\\d+/\\d+/\\d+/[a-z]+/(?\'id\'\\d+)!'),'host'=>'nytimes.com','iframe'=>array('height'=>'400','src'=>'//graphics8.nytimes.com/video/players/offsite/index.html?videoId={@id}','width'=>'585'),'name'=>'The New York Times Video','scrape'=>array('extract'=>'!/video/movies/(?\'id\'\\d+)!','match'=>'!nytimes\\.com/movie(?:s/movie)?/(?\'playlist\'\\d+)/[-\\w]+/trailers!','url'=>'http://www.nytimes.com/svc/video/api/playlist/{@playlist}?externalId=true'),'tags'=>array('movies','news')),
		'oddshot'=>array('extract'=>'!oddshot.tv/shot/(?\'id\'[-\\w]+)!','host'=>'oddshot.tv','iframe'=>array('src'=>'//oddshot.tv/shot/{@id}/embed'),'name'=>'Oddshot','tags'=>array('gaming')),
		'pastebin'=>array('extract'=>'@pastebin\\.com/(?!u/)(?:\\w+(?:\\.php\\?i=|/))?(?\'id\'\\w+)@','host'=>'pastebin.com','iframe'=>array('height'=>'300','scrolling'=>'','src'=>'//pastebin.com/embed_iframe.php?i={@id}','style'=>array('resize'=>'vertical'),'width'=>'100%'),'name'=>'Pastebin'),
		'playstv'=>array('extract'=>'!plays\\.tv/video/(?\'id\'\\w+)!','host'=>'plays.tv','iframe'=>array('src'=>'//plays.tv/embeds/{@id}'),'name'=>'Plays.tv','scrape'=>array('extract'=>'!plays\\.tv/video/(?\'id\'\\w+)!','match'=>'!plays\\.tv/s/!'),'tags'=>array('gaming')),
		'podbean'=>array('extract'=>'!podbean\\.com/site/player/index/pid/\\d+/eid/(?\'id\'\\d+)!','host'=>'podbean.com','iframe'=>array('height'=>'100','max-width'=>'900','src'=>'//www.podbean.com/media/player/audio/postId/{@id}','width'=>'100%'),'name'=>'Podbean','scrape'=>array('extract'=>'!embed/postId/(?\'id\'\\d+)!','match'=>'!podbean\\.com/e/!'),'tags'=>array('podcasts')),
		'prezi'=>array('extract'=>'#//prezi\\.com/(?!(?:a(?:bout|mbassadors)|c(?:o(?:llaborate|mmunity|ntact)|reate)|exp(?:erts|lore)|ip(?:ad|hone)|jobs|l(?:ear|ogi)n|m(?:ac|obility)|pr(?:es(?:s|ent)|icing)|recommend|support|user|windows|your)/)(?\'id\'\\w+)/#','host'=>'prezi.com','iframe'=>array('height'=>'400','src'=>'//prezi.com/embed/{@id}/','width'=>'550'),'name'=>'Prezi','tags'=>array('presentations')),
		'reddit'=>array('extract'=>'!(?\'path\'/r/\\w+/comments/\\w+/(?:\\w+/\\w+)?)!','host'=>'reddit.com','iframe'=>array('height'=>'165','onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/reddit.min.html#{@path}','width'=>'800'),'name'=>'Reddit threads and comments','tags'=>array('social')),
		'rutube'=>array('extract'=>'!rutube\\.ru/tracks/(?\'id\'\\d+)!','host'=>'rutube.ru','iframe'=>array('height'=>'405','src'=>'//rutube.ru/play/embed/{@id}','width'=>'720'),'name'=>'Rutube','scrape'=>array('extract'=>'!rutube\\.ru/play/embed/(?\'id\'\\d+)!','match'=>'!rutube\\.ru/video/[0-9a-f]{32}!'),'tags'=>array('.ru')),
		'scribd'=>array('extract'=>'!scribd\\.com/(?:mobile/)?doc(?:ument)?/(?\'id\'\\d+)!','host'=>'scribd.com','iframe'=>array('height'=>'500','src'=>'https://www.scribd.com/embeds/{@id}/content?view_mode=scroll&show_recommendations=false','style'=>array('resize'=>'vertical'),'width'=>'100%'),'name'=>'Scribd','tags'=>array('documents','presentations')),
		'slideshare'=>array('extract'=>'!slideshare\\.net/[^/]+/[-\\w]+-(?\'id\'\\d{6,})$!','host'=>'slideshare.net','iframe'=>array('height'=>'356','src'=>'//www.slideshare.net/slideshow/embed_code/{@id}','width'=>'427'),'name'=>'SlideShare','scrape'=>array('extract'=>'!"presentationId":(?\'id\'\\d+)!','match'=>'!slideshare\\.net/[^/]+/\\w!'),'tags'=>array('presentations')),
		'soundcloud'=>array('extract'=>array('@(?\'id\'https?://(?:api\\.)?soundcloud\\.com/(?!pages/)[-/\\w]+/[-/\\w]+|^[^/]+/[^/]+$)@','@api\\.soundcloud\\.com/playlists/(?\'playlist_id\'\\d+)@','@api\\.soundcloud\\.com/tracks/(?\'track_id\'\\d+)(?:\\?secret_token=(?\'secret_token\'[-\\w]+))?@','@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/(?=s-)(?\'secret_token\'[-\\w]+)@'),'host'=>'soundcloud.com','iframe'=>array('height'=>'<xsl:choose><xsl:when test="@playlist_id or contains(@id,\'/sets/\')">450</xsl:when><xsl:otherwise>166</xsl:otherwise></xsl:choose>','max-width'=>'900','src'=>'https://w.soundcloud.com/player/?url=<xsl:choose><xsl:when test="@playlist_id">https%3A//api.soundcloud.com/playlists/<xsl:value-of select="@playlist_id"/></xsl:when><xsl:when test="@track_id">https%3A//api.soundcloud.com/tracks/<xsl:value-of select="@track_id"/>&amp;secret_token=<xsl:value-of select="@secret_token"/></xsl:when><xsl:otherwise><xsl:if test="not(contains(@id,\'://\'))">https%3A//soundcloud.com/</xsl:if><xsl:value-of select="@id"/></xsl:otherwise></xsl:choose>','width'=>'100%'),'name'=>'SoundCloud','scrape'=>array(array('extract'=>'@soundcloud:tracks:(?\'track_id\'\\d+)@','match'=>'@soundcloud\\.com/(?!playlists|tracks)[-\\w]+/[-\\w]+/s-@'),array('extract'=>'@soundcloud://playlists:(?\'playlist_id\'\\d+)@','match'=>'@soundcloud\\.com/\\w+/sets/@')),'tags'=>array('music')),
		'sportsnet'=>array('host'=>'sportsnet.ca','iframe'=>array('src'=>'https://images.rogersdigitalmedia.com/video_service.php?videoId={@id}&playerKey=AQ~~,AAAAAGWRwLc~,cRCmKE8Utf7OFWP38XQcokFZ80fR-u_y&autoStart=false&width=100%25&height=100%25'),'name'=>'Sportsnet','scrape'=>array('extract'=>array('/vid(?:eoId)?=(?\'id\'\\d+)/','/param name="@videoPlayer" value="(?\'id\'\\d+)"/')),'tags'=>array('.ca','sports')),
		'spotify'=>array('extract'=>array('!(?\'uri\'spotify:(?:album|artist|user|track(?:set)?):[-,:\\w]+)!','!(?:open|play)\\.spotify\\.com/(?\'path\'(?:album|artist|track|user)/[-/\\w]+)!'),'host'=>array('open.spotify.com','play.spotify.com'),'iframe'=>array('height'=>'480','src'=>'https://embed.spotify.com/?view=coverart&amp;uri=<xsl:choose><xsl:when test="@uri"><xsl:value-of select="@uri"/></xsl:when><xsl:otherwise>spotify:<xsl:value-of select="translate(@path,\'/\',\':\')"/></xsl:otherwise></xsl:choose>','width'=>'400'),'name'=>'Spotify','scheme'=>'spotify','tags'=>array('music')),
		'steamstore'=>array('extract'=>'!store.steampowered.com/app/(?\'id\'\\d+)!','host'=>'store.steampowered.com','iframe'=>array('height'=>'190','max-width'=>'900','src'=>'//store.steampowered.com/widget/{@id}','width'=>'100%'),'name'=>'Steam store','tags'=>array('gaming')),
		'stitcher'=>array('host'=>'stitcher.com','iframe'=>array('height'=>'150','max-width'=>'900','src'=>'//app.stitcher.com/splayer/f/{@fid}/{@eid}','width'=>'100%'),'name'=>'Stitcher','scrape'=>array('extract'=>array('!data-eid="(?\'eid\'\\d+)!','!data-fid="(?\'fid\'\\d+)!'),'match'=>'!/podcast/!'),'tags'=>array('podcasts')),
		'strawpoll'=>array('extract'=>'!strawpoll\\.me/(?\'id\'\\d+)!','host'=>'strawpoll.me','iframe'=>array('height'=>'360','scrolling'=>'','src'=>'//www.strawpoll.me/embed_1/{@id}','width'=>'640'),'name'=>'Straw Poll'),
		'streamable'=>array('extract'=>'!streamable\\.com/(?\'id\'\\w+)!','host'=>'streamable.com','iframe'=>array('src'=>'//streamable.com/e/{@id}'),'name'=>'Streamable','tags'=>array('videos')),
		'teamcoco'=>array('extract'=>'!teamcoco\\.com/video/(?\'id\'\\d+)!','host'=>'teamcoco.com','iframe'=>array('height'=>'415','src'=>'//teamcoco.com/embed/v/{@id}','width'=>'640'),'name'=>'Team Coco','scrape'=>array('extract'=>'!"id":(?\'id\'\\d+)!','match'=>'!teamcoco\\.com/video/.!'),'tags'=>array('entertainment')),
		'ted'=>array('extract'=>'#ted\\.com/(?\'id\'(?:talk|playlist)s/[-\\w]+(?:\\.html)?)(?![-\\w]|/transcript)#i','host'=>'ted.com','iframe'=>array('src'=>'//embed.ted.com/<xsl:value-of select="@id"/><xsl:if test="not(contains(@id,\'.html\'))">.html</xsl:if>'),'name'=>'TED Talks','tags'=>array('presentations')),
		'theatlantic'=>array('extract'=>'!theatlantic\\.com/video/index/(?\'id\'\\d+)!','host'=>'theatlantic.com','iframe'=>array('height'=>'360','src'=>'//www.theatlantic.com/video/iframe/{@id}/','width'=>'640'),'name'=>'The Atlantic Video','tags'=>array('news')),
		'theguardian'=>array('extract'=>'!theguardian\\.com/(?\'id\'\\w+/video/[-/\\w]+)!','host'=>'theguardian.com','iframe'=>array('src'=>'//embed.theguardian.com/embed/video/{@id}'),'name'=>'The Guardian','tags'=>array('news')),
		'theonion'=>array('extract'=>'!theonion\\.com/video/[-\\w]+[-,](?\'id\'\\d+)!','host'=>'theonion.com','iframe'=>array('src'=>'//www.theonion.com/video_embed/?id={@id}'),'name'=>'The Onion','tags'=>array('entertainment')),
		'tinypic'=>array('extract'=>array('!tinypic\\.com/player\\.php\\?v=(?\'id\'\\w+)&s=(?\'s\'\\d+)!','!tinypic\\.com/r/(?\'id\'\\w+)/(?\'s\'\\d+)!'),'flash'=>array('padding-height'=>'30','src'=>'//tinypic.com/player.swf?file={@id}&s={@s}'),'host'=>'tinypic.com','name'=>'TinyPic videos','tags'=>array('images')),
		'tmz'=>array('extract'=>'@tmz\\.com/videos/(?\'id\'\\w+)@','host'=>'tmz.com','iframe'=>array('src'=>'//www.kaltura.com/index.php/kwidget/cache_st/133592691/wid/_591531/partner_id/591531/uiconf_id/9071262/entry_id/{@id}'),'name'=>'TMZ','tags'=>array('gossip')),
		'traileraddict'=>array('host'=>'traileraddict.com','iframe'=>array('src'=>'//v.traileraddict.com/{@id}'),'name'=>'Trailer Addict','scrape'=>array('extract'=>'@v\\.traileraddict\\.com/(?\'id\'\\d+)@','match'=>'@traileraddict\\.com/(?!tags/)[^/]+/.@'),'tags'=>array('movies')),
		'tumblr'=>array('extract'=>'!(?\'name\'[-\\w]+)\\.tumblr\\.com/post/(?\'id\'\\d+)!','host'=>'tumblr.com','iframe'=>array('height'=>'180','onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/tumblr.min.html#{@key}/{@id}','width'=>'520'),'name'=>'Tumblr','scrape'=>array('extract'=>array('!did=\\\\u0022(?\'did\'[-\\w]+)!','!embed\\\\/post\\\\/(?\'key\'[-\\w]+)!'),'match'=>'!\\w\\.tumblr\\.com/post/\\d!','url'=>'http://www.tumblr.com/oembed/1.0?url=http://{@name}.tumblr.com/post/{@id}'),'tags'=>array('social')),
		'twitch'=>array('extract'=>array('#twitch\\.tv/(?\'channel\'\\w+)(?:/b/(?\'archive_id\'\\d+)|/c/(?\'chapter_id\'\\d+)|/v/(?\'video_id\'\\d+))?#','#t=(?\'t\'(?:(?:\\d+h)?\\d+m)?\\d+s)#','#clips\\.twitch\\.tv/(?\'channel\'\\w+)/(?\'clip_id\'\\w+)#'),'host'=>'twitch.tv','iframe'=>array('src'=>'<xsl:choose><xsl:when test="@clip_id">//clips.twitch.tv/embed?autoplay=false&amp;clip=<xsl:value-of select="@channel"/>/<xsl:value-of select="@clip_id"/></xsl:when><xsl:otherwise>//player.twitch.tv/?autoplay=false&amp;<xsl:choose><xsl:when test="@archive_id">video=a<xsl:value-of select="@archive_id"/></xsl:when><xsl:when test="@chapter_id">video=c<xsl:value-of select="@chapter_id"/></xsl:when><xsl:when test="@video_id">video=v<xsl:value-of select="@video_id"/></xsl:when><xsl:otherwise>channel=<xsl:value-of select="@channel"/></xsl:otherwise></xsl:choose><xsl:if test="@t">&amp;time=<xsl:value-of select="@t"/></xsl:if></xsl:otherwise></xsl:choose>'),'name'=>'Twitch','tags'=>array('gaming')),
		'twitter'=>array('extract'=>'@twitter\\.com/(?:#!/)?\\w+/status(?:es)?/(?\'id\'\\d+)@','host'=>'twitter.com','iframe'=>array('height'=>'186','onload'=>'var a=Math.random();window.addEventListener(\'message\',function(b){{if(b.data.id==a)style.height=b.data.height+\'px\'}});contentWindow.postMessage(\'s9e:\'+a,\'https://s9e.github.io\')','src'=>'https://s9e.github.io/iframe/twitter.min.html#{@id}','style'=>array('background'=>'url(https://abs.twimg.com/favicons/favicon.ico) no-repeat 50% 50%'),'width'=>'500'),'name'=>'Twitter','tags'=>array('social')),
		'ustream'=>array('choose'=>array('otherwise'=>array('iframe'=>array('src'=>'//www.ustream.tv/embed/{@cid}?html5ui')),'when'=>array('iframe'=>array('src'=>'//www.ustream.tv/embed/recorded/{@vid}?html5ui'),'test'=>'@vid')),'extract'=>'!ustream\\.tv/recorded/(?\'vid\'\\d+)!','host'=>'ustream.tv','name'=>'Ustream','scrape'=>array('extract'=>'!embed/(?\'cid\'\\d+)!','match'=>'#ustream\\.tv/(?!explore/|platform/|recorded/|search\\?|upcoming$|user/)(?:channel/)?[-\\w]+#'),'tags'=>array('gaming')),
		'vbox7'=>array('extract'=>'!vbox7\\.com/play:(?\'id\'[\\da-f]+)!','host'=>'vbox7.com','iframe'=>array('src'=>'//vbox7.com/emb/external.php?vid={@id}'),'name'=>'VBOX7','tags'=>array('.bg')),
		'veoh'=>array('extract'=>'!veoh\\.com/(?:m/watch\\.php\\?v=|watch/)v(?\'id\'\\w+)!','flash'=>array('padding-height'=>'40','src'=>'//www.veoh.com/swf/webplayer/WebPlayer.swf?version=AFrontend.5.7.0.1509&permalinkId=v{@id}&player=videodetailsembedded&videoAutoPlay=0&id=anonymous'),'host'=>'veoh.com','name'=>'Veoh','tags'=>array('videos')),
		'vevo'=>array('extract'=>'!vevo\\.com/watch/([-/\\w]+/)?(?\'id\'[A-Z0-9]+)!','host'=>'vevo.com','iframe'=>array('height'=>'324','src'=>'//cache.vevo.com/m/html/embed.html?video={@id}','width'=>'575'),'name'=>'VEVO','tags'=>array('music')),
		'viagame'=>array('extract'=>'!viagame\\.com/channels/[^/]+/(?\'id\'\\d+)!','host'=>'viagame.com','iframe'=>array('height'=>'392','src'=>'//www.viagame.com/embed/{@id}','width'=>'640'),'name'=>'Viagame','tags'=>array('gaming')),
		'videodetective'=>array('extract'=>'!videodetective\\.com/\\w+/[-\\w]+/(?:trailer/P0*)?(?\'id\'\\d+)!','host'=>'videodetective.com','iframe'=>array('src'=>'//www.videodetective.com/embed/video/?options=false&autostart=false&playlist=none&publishedid={@id}'),'name'=>'Video Detective'),
		'videomega'=>array('extract'=>'!videomega\\.tv/\\?ref=(?\'id\'\\w+)!','host'=>'videomega.tv','iframe'=>array('src'=>'//videomega.tv/iframe.php?ref={@id}'),'name'=>'Videomega','tags'=>array('videos')),
		'vidme'=>array('attributes'=>array('height'=>array('defaultValue'=>'360'),'width'=>array('defaultValue'=>'640')),'extract'=>'!vid\\.me/(?\'id\'\\w+)!','host'=>'vid.me','iframe'=>array('height'=>'{@height}','src'=>'https://vid.me/e/{@id}','width'=>'{@width}'),'name'=>'vidme','scrape'=>array('extract'=>'!meta property="og:video:type" content="video/\\w+">\\s*<meta property="og:video:height" content="(?\'height\'\\d+)">\\s*<meta property="og:video:width" content="(?\'width\'\\d+)!'),'tags'=>array('videos')),
		'vimeo'=>array('extract'=>'!vimeo\\.com/(?:channels/[^/]+/|video/)?(?\'id\'\\d+)!','host'=>'vimeo.com','iframe'=>array('src'=>'//player.vimeo.com/video/{@id}'),'name'=>'Vimeo','tags'=>array('videos')),
		'vine'=>array('extract'=>'!vine\\.co/v/(?\'id\'[^/]+)!','host'=>'vine.co','iframe'=>array('height'=>'480','src'=>'https://vine.co/v/{@id}/embed/simple?audio=1','width'=>'480'),'name'=>'Vine','tags'=>array('social','videos')),
		'vk'=>array('extract'=>array('!vk(?:\\.com|ontakte\\.ru)/(?:[\\w.]+\\?z=)?video(?\'oid\'-?\\d+)_(?\'vid\'\\d+)!','!vk(?:\\.com|ontakte\\.ru)/video_ext\\.php\\?oid=(?\'oid\'-?\\d+)&id=(?\'vid\'\\d+)&hash=(?\'hash\'[0-9a-f]+)!'),'host'=>array('vk.com','vkontakte.ru'),'iframe'=>array('height'=>'360','src'=>'//vk.com/video_ext.php?oid={@oid}&id={@vid}&hash={@hash}&hd=1','width'=>'607'),'name'=>'VK','scrape'=>array('extract'=>'!embed_hash=(?\'hash\'[0-9a-f]+)!','match'=>'!vk.*?video-?\\d+_\\d+!','url'=>'http://vk.com/video{@oid}_{@vid}'),'tags'=>array('.ru')),
		'vocaroo'=>array('extract'=>'!vocaroo\\.com/i/(?\'id\'\\w+)!','flash'=>array('height'=>'44','src'=>'//vocaroo.com/player.swf?playMediaID={@id}&autoplay=0','width'=>'148'),'host'=>'vocaroo.com','name'=>'Vocaroo'),
		'vox'=>array('extract'=>'!vox.com/.*#ooid=(?\'id\'[-\\w]+)!','host'=>'vox.com','iframe'=>array('src'=>'//player.ooyala.com/iframe.html#pbid=a637d53c5c0a43c7bf4e342886b9d8b0&ec={@id}'),'name'=>'Vox'),
		'washingtonpost'=>array('extract'=>array('#washingtonpost\\.com/video/c/\\w+/(?\'id\'[-0-9a-f]+)#','#washingtonpost\\.com/video/[-/\\w]+/(?\'id\'[-0-9a-f]+)_video\\.html#'),'host'=>'washingtonpost.com','iframe'=>array('src'=>'//www.washingtonpost.com/video/c/embed/{@id}'),'name'=>'Washington Post Video','tags'=>array('news')),
		'wshh'=>array('extract'=>'!worldstarhiphop\\.com/featured/(?\'id\'\\d+)!','host'=>'worldstarhiphop.com','iframe'=>array('height'=>'360','src'=>'//www.worldstarhiphop.com/embed/{@id}','width'=>'640'),'name'=>'WorldStarHipHop','scrape'=>array('extract'=>'!disqus_identifier[ =\']+(?\'id\'\\d+)!','match'=>'!worldstarhiphop\\.com/(?:\\w+/)?video\\.php\\?v=\\w+!'),'tags'=>array('videos')),
		'wsj'=>array('extract'=>array('@wsj\\.com/[^#]*#!(?\'id\'[-0-9A-F]{36})@','@wsj\\.com/video/[^/]+/(?\'id\'[-0-9A-F]{36})@'),'host'=>'wsj.com','iframe'=>array('height'=>'288','src'=>'//video-api.wsj.com/api-video/player/iframe.html?guid={@id}','width'=>'512'),'name'=>'The Wall Street Journal Online','scrape'=>array('extract'=>'@guid=(?\'id\'[-0-9A-F]{36})@','match'=>'@on\\.wsj\\.com/\\w@'),'tags'=>array('news')),
		'xboxclips'=>array('extract'=>'@xboxclips\\.com/(?\'user\'[^/]+)/(?!screenshots/)(?\'id\'[-0-9a-f]+)@','host'=>'xboxclips.com','iframe'=>array('src'=>'//xboxclips.com/{@user}/{@id}/embed'),'name'=>'XboxClips','tags'=>array('gaming')),
		'xboxdvr'=>array('extract'=>'!xboxdvr\\.com/gamer/(?\'user\'[^/]+)/video/(?\'id\'\\d+)!','host'=>'xboxdvr.com','iframe'=>array('height'=>'360','src'=>'//xboxdvr.com/gamer/{@user}/video/{@id}/embed','width'=>'640'),'name'=>'Xbox DVR','tags'=>array('gaming')),
		'yahooscreen'=>array('extract'=>'!screen\\.yahoo\\.com/(?:[-\\w]+/)?(?\'id\'[-\\w]+)\\.html!','host'=>'screen.yahoo.com','iframe'=>array('height'=>'360','src'=>'https://screen.yahoo.com/{@id}.html?format=embed','width'=>'640'),'name'=>'Yahoo! Screen','tags'=>array('movies')),
		'youku'=>array('extract'=>'!youku\\.com/v_show/id_(?\'id\'\\w+)!','flash'=>array('padding-height'=>'40','src'=>'https://players.youku.com/player.php/sid/{@id}/v.swf'),'host'=>'youku.com','name'=>'Youku','tags'=>array('.cn')),
		'youtube'=>array('extract'=>array('!youtube\\.com/(?:watch.*?v=|v/)(?\'id\'[-\\w]+)!','!youtu\\.be/(?\'id\'[-\\w]+)!','![#&?]t=(?:(?:(?\'h\'\\d+)h)?(?\'m\'\\d+)m(?\'s\'\\d+)|(?\'t\'\\d+))!','!&list=(?\'list\'[-\\w]+)!'),'host'=>array('youtube.com','youtu.be'),'iframe'=>array('src'=>'https://www.youtube.com/embed/<xsl:value-of select="@id"/><xsl:if test="@list">?list=<xsl:value-of select="@list"/></xsl:if><xsl:if test="@t or@m"><xsl:choose><xsl:when test="@list">&amp;</xsl:when><xsl:otherwise>?</xsl:otherwise></xsl:choose>start=<xsl:choose><xsl:when test="@t"><xsl:value-of select="@t"/></xsl:when><xsl:when test="@h"><xsl:value-of select="@h*3600+@m*60+@s"/></xsl:when><xsl:otherwise><xsl:value-of select="@m*60+@s"/></xsl:otherwise></xsl:choose></xsl:if>','style'=>array('background'=>'url(https://i.ytimg.com/vi/{@id}/hqdefault.jpg) 50% 50% / cover')),'name'=>'YouTube','tags'=>array('videos')),
		'zippyshare'=>array('flash'=>array('flashvars'=>'file={@file}&server={@server}&autostart=false','height'=>'80','max-width'=>'900','src'=>'//api.zippyshare.com/api/player.swf','width'=>'100%'),'host'=>'zippyshare.com','name'=>'Zippyshare audio files','scrape'=>array('extract'=>'!file=(?\'file\'\\w+)&amp;server=(?\'server\'\\d+)!','match'=>'!/v/!'),'tags'=>array('file sharing'))
	);
}