<?php
require_once dirname(__DIR__).'/library/config.php';
require_once dirname(__DIR__).'/library/functionGlobal.php';
require_once dirname(__DIR__).'/library/basic.php';
require_once dirname(__DIR__).'/library/member.php';
require_once dirname(__DIR__).'/library/question.php';
define('TA_PATH', dirname(dirname(dirname(dirname(dirname(__FILE__))))) . DIRECTORY_SEPARATOR);
//Wind::import('EXT:targetany.library.functionGlobal');
/**
 * 应用前台入口
 */
class IndexController extends PwBaseController {

    private $file = 'EXT:targetany.conf';
    private $default = array();

    public function beforeAction($handlerAdapter) {
            parent::beforeAction($handlerAdapter);
            $this->file = Wind::getRealPath($this->file, false);
            set_error_handler(array(&$this,"appError"));
    }

    public function appError() {

    }

    public function detailsAction() {
        $forumService = $this->_getFroumService();
        $map = $forumService->getForumMap();
        $catedb = $map[0];
        $detail = array();

        foreach ($catedb as $key => $value) {
            $forumList[$value['fid']] = $forumService->getForumsByLevel($value['fid'], $map);
        }

        foreach ($map[0] as $forum) {
            //$detail[] = array('value' => $forum['fid'], 'text' => urlencode($forum['name']));
            if (isset($forumList[$forum['fid']])) {
                foreach ($forumList[$forum['fid']] as $k => $v) {
                    $detail[] = array('value' => $v['fid'], 'text' => urlencode($v['name'] . '(' . $v['fupname'] . ')'));
                }
            }
        }

        ta_success($detail);
    }

    public function versionAction() {
        $postData = $this->getRequest()->getPost();
        $this->ta_validation($postData);
        $reply = ta_get_version();
        ta_success($reply);
    }

    public function postAction() {
        $postData = $this->getRequest()->getPost();
        $this->ta_validation($postData);
        $question = new targetany_question($postData);
        $question->processData();
    }

    private function ta_validation($postData) {
        $conf = @include $this->file;
        $conf || $conf = $this->default;
        if (!($postData && isset($postData['__sign']) && $postData['__sign']) || !(isset($conf['anytarget_token']) && isset($conf['anytarget_token']) && $conf['anytarget_token'] == $postData['__sign'])) {
            ta_fail(TA_ERROR_INVALID_PWD, "password is wrong", "发布密码填写错误");
        }
    }

    protected function _getFroumService() {
        return Wekit::load('forum.srv.PwForumService');
    }

}

?>