<?php

defined('WEKIT_VERSION') or exit(403);
Wind::import('SRV:forum.srv.post.do.PwPostDoBase');

class App_EmailnoticeDoReply extends PwPostDoBase {
	
public $user;
private $_content;
private $_rpid;
private $info;

public function __construct(PwPost $pwpost) {
$this->user = $pwpost->user;
$this->info = $pwpost->action->getInfo();	 
}
 

public function dataProcessing($postDm) {
$atc_content = $postDm->getField('content');
$this->_rpid = $postDm->getField('rpid');
$this->_content = Pw::substrs(Pw::stripWindCode($atc_content,true),30);
return $postDm;
}
	
public function addPost($pid,$tid) {
$service = Wekit::load('config.PwConfig');
$config = $service->getValues('emailnotice');
if ($config[lock] == '1') {	 
	
if ($config[infloor] == '1' && $this->_rpid) {	
$this->_emailSend($pid,$tid);
} 
	
	//if ($config[remind] == '1') {	
	//$this->_emailremindSend(); 
	//}	
	
} 
} 

	
private function _emailSend($pid,$tid) {

//n组织数据	
$serve = Wekit::load('thread.PwThread');
$info = $serve->getPost($this->_rpid);  //层主信息
$param = $info['pid'];
$params = array();
$params['replyUserid'] = $this->user->uid;     //回复人的uid
$params['replyUsername'] = $this->user->username;
 
$reply =  $serve->getPost($pid);   
$replyed = $serve->getPost($reply['npid']);  //调用被回复人回复信息,先回复的人
	
//获取邮箱地址
$user = new PwUserBo($info['created_userid'], true);	
$toEmail = $user->info['email'];		
	
if ($replyed) {	 
$info['created_userid'] = $replyed['created_userid'];    //篡改接收人   
$user2 = new PwUserBo($replyed['created_userid'], true);	
$toEmail = $user2->info['email'];	
//$replyed['content'] = iconv("utf-8","gbk",$replyed['content']);  //先转换成gbk替换中文
$info['content'] = preg_replace('/回复(.*?)：/is', '',$replyed['content']); //篡改回复内容
//$info['content'] = iconv("gbk","utf-8",$info['content']);  //编码转换成utf8，坑爹的中文正则匹配，暂时先这样了

$reply['content'] = preg_replace('/回复(.*?)：/is', '',$reply['content']);  
}
	
if (!$toEmail) exit();	 
$params['postTitle'] = Wekit::load('forum.srv.PwThreadService')->displayContent($info['content'],1,array(),30);
$params['threadId'] = $info['tid'];
$params['pid'] = $pid; 
	
//回复自己不提醒	
if (!$info['reply_notice'] || $this->user->uid == $info['created_userid']) return false; 
//黑名单不提醒	
$blackUid = Wekit::load('user.PwUserBlack')->checkUserBlack($this->user->uid, $info['created_userid']);
if ($blackUid) return false;


//n发送邮件,邮件内容可以自行美化	
date_default_timezone_set('Asia/Shanghai');	
Wind::import('LIB:utility.PwMail');
$emailconfig = $this->_getEmailConfig();
if (!$emailconfig['mail.from']) print_r ('[SMTP设置不正确,邮件提醒失败]');
$mail = new PwMail();
$title = $params['replyUsername'].' 回复了你的回帖“'.$params['postTitle'].'”';
$content = "<a href='".WindUrlHelper::createUrl('space/index/run/', array('uid' => $params['replyUserid']))."'  target='_blank' >".$params['replyUsername']."</a> 回复了你的回帖“".$params['postTitle'].'”';		 
$content .="<p>具体回复内容：<a href='".WindUrlHelper::createUrl('bbs/read/jump/', array('tid' => $params['threadId'],'pid' => $reply['pid']))."'  target='_blank' >".Pw::substrs($reply['content'],30)."</a></p>";
$content .="<p>".Wekit::C('site','info.name')."      ".date("Y-m-d H:i:s")."</p>";
$result = $mail->sendMail($toEmail, $title, $content);	

}

private function _emailremindSend($pid,$tid) {
//这个没有时间写了~~

	
}		
	
	
private function _getEmailConfig() { 
return Wekit::C()->getValues('email');
}


}



?>