<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class category_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
		$this->check_admin_group();
	}
	
	// 列表
	public function on_index() {
		$this->on_list();
	}	
	
	public function on_list() {
		$this->_title[] = '贴吧分类';
		$this->_nav[] = '<a href="./">贴吧分类</a>';
		
		$error = array();
		if($this->form_submit()) {
			
			// 修改
			$namearr = core::gpc('name', 'P');
			$rankarr = core::gpc('rank', 'P');
			
			// hook admin_forum_list_gpc_after.php
			
			if(!empty($namearr)) {
				foreach($namearr as $cid=>$name) {
					$cid = intval($cid);
					$cate = $this->category->read($cid);
					$cate['rank'] = intval($rankarr[$cid]);
					$cate['name'] = $namearr[$cid];
					$this->category->update($cate);
					$this->mcache->clear('category', $cid);
					$this->mcache->clear('cateforum', $cid);
				}
				//$this->mcache->clear('forumarr');
				$this->mcache->clear('catelist');
				$this->mcache->clear('miscarr');
			}
			
			// 新增
			$newnamearr = core::gpc('newname', 'P');
			$newrankarr = core::gpc('newrank', 'P');
			$newfuparr = core::gpc('newfup', 'P');
			if(!empty($newnamearr)) {
				
				foreach($newnamearr as $cid=>$name) {
					$cid = intval($cid);
					!isset($newfuparr[$cid]) && $newfuparr[$cid] = 0;
					!isset($newrankarr[$cid]) && $newrankarr[$cid] = 0;
					$cate = array(
						'name'=>$name,
						'rank'=>intval($newrankarr[$cid]),
						'pid'=>intval($newfuparr[$cid]),
						'description'=>'',
						'keywords'=>'',
					);
					
					// hook admin_forum_create_before.htm
					
					$forum = $this->category->create($cate);
				}
			}
			
		}
		
		$page = misc::page();
		$cates = $this->category->count();
		$catelist = $this->category->get_category_list();
		//foreach($forumlist as &$forum) {
		//	$this->forum->format($forum);
		//}
		
		// hook admin_forum_list_view_before.php
		
		$this->view->assign('error', $error);
		$this->view->assign('catelist', $catelist);
		$this->view->display('forum_category.html');
	}
	
	// 修改
	public function on_update() {
		$this->_title[] = '修改分类';
		$this->_nav[] = '修改分类';
		
		$cid = intval(core::gpc('cid'));

		$cate = $this->category->get($cid);
		$this->check_category_exists($cate);
		
		$input = $error = array();
		if($this->form_submit()) {
			
			// 准备更新数据
			$post = array();
			
			$post['pid'] = intval(core::gpc('pid', 'P'));
			$post['name'] = core::gpc('name', 'P');
			$post['rank'] = intval(core::gpc('rank', 'P'));
			$post['description'] = trim(core::gpc('description', 'P'));
			$post['keywords'] = trim(core::gpc('keywords', 'P'));
			
			//$error['fup'] = $this->forum->check_fup($fid, $post['fup']);
			$error['name'] = $this->category->check_name($post['name']);

			if(!array_filter($error)) {
				$error = array();

				$cate = array_merge($cate, $post);
				
				// hook admin_forum_update_after.php
				
				$this->category->update($cate);
			}
		}

		$cateoptions = $this->category->get_category_options($cate['pid'], 1);
		$this->view->assign('cateoptions', $cateoptions);

		
		$admin_auth = core::gpc($this->conf['cookie_pre'].'admin_auth', 'C');

		$this->view->assign('admin_auth', $admin_auth);

		$this->view->assign('cid', $cate['id']);
		$this->view->assign('cate', $cate);
		$this->view->assign('error', $error);
		
		// hook admin_forum_update_before.php
		
		$this->view->display('forum_cate_update.html');
	}
	
	
	public function on_delete() {
		$this->_title[] = '删除分类';
		$this->_nav[] = '删除分类';
		
		$cid = intval(core::gpc('cid'));
	
		$limit = 200;

		$cate = $this->category->get($cid);
		
		if(empty($cate)) {
			$this->message('分类已经被删除。', 1, '?category-list.htm');
		}
		
		// 查找子分类删除...
		if(empty($cids)) {
			$cids = '';
			$catelist = $this->category->index_fetch(array('pid'=>$cid), array(), 0, 1000);
			foreach($catelist as $_cate) {
				$this->category->_delete($_cate['id']);
			}
		}
		$this->category->_delete($cid);
		// hook admin_forum_delete_after.php
		
		// 删除首页的缓存
		$this->message('删除完毕', 1, '?category-list.htm');
		
	}
	
}
?>