<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class content_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
		$this->check_admin_group();
	}
    public function on_index(){
		$this->on_topic();
	}
	public function on_topic(){
		$this->_title[] = '管理帖子';
		$this->_nav[] = '<a href="./">管理帖子</a>';
		
		$error = array();
		$fid=core::gpc('fid', 'G');
		if($this->form_submit()) {
			$uid = core::gpc('uid', 'R');// 用户名/email/uid
		    if(!empty($uid)) {
			if(is_numeric($uid)) {
				$uid = intval($uid);
				$user = $this->member->read($uid);
				$this->check_user_exists($user);
				$uid = $user['uid'];
			} elseif(strpos($uid, '@') !== FALSE) {
				$uid = $this->member->get_uid_by_email($uid);
				$user = $this->member->read($uid);
				$this->check_user_exists($user);
			} elseif($uid){
				$user = $this->member->get_user_by_username($uid);
				$this->check_user_exists($user);
				$uid = $user['uid'];
			}
		    }
		
		    $keyword = urldecode(core::gpc('keyword', 'R'));
		    misc::safe_str($keyword);
		    $keyword_url = urlencode($keyword);
			
			$maxtid = $this->topic->maxid();
		    $tidfrom = max(0, intval(core::gpc('tidfrom', 'R')));
		    $tidto = max(0, intval(core::gpc('tidto', 'R')));
		
		    // 根据UID，关键词查找主题，列出100个，两列排版，第二步，删除，批量替换，一次100个。
		
		    // 数据量大的情况下，此处可能会导致性能问题。
		    $topiclist = array();
		    if($uid) {
			    // 扫描定长表
			    $topiclist = $this->topic->index_fetch(array('authorid'=>$uid), array(), 0, 2000);
		    } elseif($tidfrom) {
			    $topiclist = $this->topic->index_fetch(array('tid'=>array('>='=>$tidfrom, '<='=>$tidto)), array(), 0, 2000);
		    } elseif($keyword){
			   // 标题 like
			   $topiclist = $this->topic->index_fetch(array('subject'=>array('LIKE'=>$keyword)), array(), 0, 2000);
		    }
		
		    empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		    $miscarr = $_SERVER['miscarr'];
		    foreach($topiclist as &$thread) {
			    $thread['fname'] = isset($miscarr['forum'][$thread['fid']]) ? $miscarr['forum'][$thread['fid']] : '';
			    $thread['dateline'] = misc::minidate($thread['dateline'], $this->conf['timeoffset']);
			    if($keyword) $thread['subject'] = str_replace($keyword, '<span class="red">'.$keyword.'</span>', $thread['subject']);
		    }
		
		    $srchstring = core::gpc('srchstring', 'R');
		    $replacestring = core::gpc('replacestring', 'R');
		
		    // 默认值
		    if(empty($tidto) && empty($tidfrom)) {
			    $tidfrom = 1;
			    $tidto = $maxtid;
			    if($tidfrom - $tidto > 2000) $tidfrom = $tidto - 2000;
		    }
		
		    if(empty($srchstring) && !empty($keyword)) {
			    $srchstring = $keyword;
			}
			$this->view->assign('fid', $fid);
			$this->view->assign('srchstring', $srchstring);
		    $this->view->assign('replacestring', $replacestring);
		    $this->view->assign('uid', $uid);
		    $this->view->assign('tidfrom', $tidfrom);
		    $this->view->assign('tidto', $tidto);
		    $this->view->assign('keyword', $keyword);
		    $this->view->assign('keyword_url', $keyword_url);
		    $this->view->assign('list', $topiclist);
		
		    // hook admin_thread_list_view_before.php
		
		    $this->view->display('content_topic.html');
			return;
		}
		
		$page = misc::page();
		$pagesize = 15;
		$start=($page-1)*$pagesize;
		if($fid){
			$forum = $this->forum->read($fid);
			$topics=$forum['topics'];
		    $list = $this->topic->index_fetch(array('fid'=>$fid), array('dateline'=>2), $start, $pagesize);	
			$pages = misc::pages("?content-topic-fid-$fid.htm", $topics, $page, $pagesize);
		}else{
		    $topics = $this->topic->count();
		    $list = $this->topic->index_fetch('',array('dateline'=>2),$start, $pagesize);
			$pages = misc::pages("?content-topic.htm", $topics, $page, $pagesize);
		}
		foreach($list as &$f) {
			$this->topic->format($f);
		}
		
		$this->view->assign('pages', $pages);
		// hook admin_forum_list_view_before.php
		
		$this->view->assign('error', $error);
		$this->view->assign('fid', $fid);
		$this->view->assign('list', $list);
		$this->view->assign('topics',$topics);
		$this->view->display('content_topic.html');
	}
    public function on_topic_delete() {
		$this->_title[] = '删除主题';
		$this->_nav[] = '删除主题';
		
		$uid = intval(core::gpc('uid', 'P'));
		$tidfrom = intval(core::gpc('tidfrom', 'P'));
		$tidto = intval(core::gpc('tidto', 'P'));
		
		$fidtids = core::gpc('fidtids', 'P');
		foreach((array)$fidtids as $v) {
			list($fid, $tid) = explode('_', $v);
			$fid = intval($fid);
			$tid = intval($tid);
			$topic = $this->topic->read($fid, $tid);
			if(empty($topic)) continue;
			
			// hook admin_thread_delete_after.php
			
			$this->topic->xdelete($fid, $tid, TRUE);
		}
		
		// hook admin_thread_delete_complete.php
		$this->message('删除完毕', 1,'?content-topic.htm');
		//$this->message('删除完毕', 1, "?thread-list-uid-$uid-tidfrom-$tidfrom-tidto-$tidto.htm");
	}
	public function on_report(){
		$this->_title[] = '举报管理';
		$this->_nav[] = '举报管理';
		if($this->form_submit()){
			$rids = core::gpc('rids', 'P');
			foreach((array)$rids as $v) {
			   $this->report->_delete($v);
			}
		}
		
		$page = misc::page();
		$pagesize = 15;
		$start=($page-1)*$pagesize;
		$count = $this->report->count();
		$list=$this->report->get_report_list($start,$pagesize);
		foreach($list as &$f) {
			$this->report->format($f);
		}
		$pages = misc::pages("?content-report.htm", $count, $page, $pagesize);
		
		$this->view->assign('pages', $pages);
		
		$this->view->assign('error', $error);
		$this->view->assign('list', $list);
		$this->view->assign('pages',$pages);
		$this->view->display('content_report.html');
		
	}
    public function on_message(){
		$this->_title[] = '站内消息';
		$this->_nav[] = '站内消息';
		$t = core::gpc('t', 'G');
		if($t=='system'){
			$where=array('uid'=>2);
		}elseif($t=='user'){
		    $where=array('uid'=>array('>'=>2));
		}else{
			$where=array();
		}
		if($this->form_submit()){
			$mids = core::gpc('mid', 'P');
			foreach((array)$mids as $v) {
			   $v=intval($v);
			   $this->pm->xdelete($v);
			}
		}
		
		$page = misc::page();
		$pagesize = 15;
		$start=($page-1)*$pagesize;
		
		$count = $this->pm->count();
		$list=$this->pm->index_fetch($where,array('dateline'=>-1),$start,$pagesize);
		
		foreach($list as &$f) {
			$this->pm->format($f);
		}
		$pages = misc::pages("?content-message-t-$t.htm", $count, $page, $pagesize);
		
		$this->view->assign('pages', $pages);
		
		$this->view->assign('error', $error);
		$this->view->assign('list', $list);
		$this->view->assign('t', $t);
		$this->view->assign('pages',$pages);
		$this->view->display('content_message.html');
	}
	public function on_attachment(){
		$this->_title[] = '附件管理';
		$this->_nav[] = '附件管理';
		$t = core::gpc('t', 'G');
		
		if($this->form_submit()){
			$aids = core::gpc('aid', 'P');
			$fids = core::gpc('fid', 'P');
			$pids = core::gpc('pid', 'P');
			foreach((array)$aids as $k=>$v) {
				$attach=$this->attachment->read($fids[$k],$v);
			    $this->attachment->unlink($attach);
			    $this->attachment->delete($attach['fid'],$v);
			}
		}
		
		$page = misc::page();
		$pagesize = 15;
		
		$count = $this->attachment->count();
		$map=array();
		if($t=='image'){
			
			$map=array('isimage'=>1);
			$count = $this->attachment->up_count("`isimage`=1");
		}elseif($t=='file'){
		    $map=array('isimage'=>0);	
			$count = $this->attachment->up_count("`isimage`=0");
		}
		$list=$this->attachment->get_attachment_list($map,$page,$pagesize);
		$pages = misc::pages("?content-attachment-t-$t.htm", $count, $page, $pagesize);
		
		$this->view->assign('pages', $pages);
		
		$this->view->assign('error', $error);
		$this->view->assign('list', $list);
		$this->view->assign('t', $t);
		$this->view->assign('pages',$pages);
		$this->view->display('content_attachment.html');
	}
	public function on_attach_trash(){
		$page = misc::page();
		    $pagesize = 100;//每次更新200
		    $start1=($page-1)*$pagesize;
			
			$cond=array('tid'=>0);
			$postlist=$this->attachment->index_fetch($cond,array('aid'=>1),0,$pagesize);
			if(empty($postlist)) $this->message('残余文件删除完成',0,'?content-attachment.htm');
			
			foreach($postlist as $k=>$v){
				$this->attachment->unlink($v);
			    $this->attachment->delete($v['fid'],$v['aid']);
			}
			$url='?content-attach_trash-page-'.($page+1).'.htm';
			$this->message('正在删除:'.$start1.'-'.($start1+$pagesize),1,$url);
		
	}
}
?>