<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'admin/control/admin_control.class.php';

class type_control extends admin_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
		$this->check_admin_group();
	}
	public function on_index(){
		$this->_title[] = '主题分类';
		$this->_nav[] = '<a href="./">主题分类</a>';
		$error = array();
		if($this->form_submit()) {
			
			// 修改
			$namearr = core::gpc('name', 'P');
			$rankarr = core::gpc('rank', 'P');
			
			if(!empty($namearr)) {
				foreach($namearr as $cid=>$name) {
					$cid = intval($cid);
					$cate = $this->type->read($cid);
					$cate['rank'] = intval($rankarr[$cid]);
					$cate['name'] = $namearr[$cid];
					$this->type->update($cate);
				}
			}
			
			// 新增
			$newnamearr = core::gpc('newname', 'P');
			$newrankarr = core::gpc('newrank', 'P');
			$newfuparr = core::gpc('newfup', 'P');
			if(!empty($newnamearr)) {
				
				foreach($newnamearr as $cid=>$name) {
					$cid = intval($cid);
					!isset($newfuparr[$cid]) && $newfuparr[$cid] = 0;
					!isset($newrankarr[$cid]) && $newrankarr[$cid] = 0;
					$cate = array(
						'name'=>$name,
						'rank'=>intval($newrankarr[$cid]),
						'pid'=>intval($newfuparr[$cid]),
					);
					
					$this->type->create($cate);
				}
			}
			
		}
		$catelist = $this->type->get_list();
		$this->view->assign('error', $error);
		$this->view->assign('catelist', $catelist);
		$this->view->display('type_index.html');
	}
	
}

?>