<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class forum_control extends common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		
		$this->_checked = array('bbs'=>' class="checked"');
	}
	public function on_index(){
		
		// hook forum_index_before.php
		// fid
		$typeid=intval(core::gpc('typeid'));
		$fn=core::gpc('fn');
		if($fn){
			$fn=urldecode($fn);
			$fn=misc::safe_str($fn,'&=');
			$fnarr=misc::explode('=', '&', 'fn='.$fn);
			$fn=$fnarr['fn'];
			$type=isset($fnarr['type'])?$fnarr['type']:'';
			$page=isset($fnarr['page'])?$fnarr['page']:1;
			
			$forum = $this->mcache->read('forum_fn', $fn);
			if(!$forum){
				$url="?search-index-q-".urlencode($fn).".htm";
				$this->location($url);
				exit;
			}
			$fid=$forum['fid'];
			$url_page=$url=$this->conf['app_url'].'fn='.urlencode($fn);
			$type && $url_page.="&type=$type";
			$url_page.='&page=[page]';
			
			$url_digest=$url.'&type=digest';
			$url_pic=$url.'&type=pic';

		}else{
			$fid =intval(core::gpc('fid'));
			$type=core::gpc('type');
			$page = misc::page();
			$forum = $this->mcache->read('forum', $fid);
			if($this->conf['urlrewrite']){	
				$url=substr($this->conf['url_forum'],stripos($this->conf['url_forum'],'|')+1);
				$url=$this->conf['app_url'].$url;
				$url_page=str_replace(array('[fid]','[name]','[type]'),array($fid,$forum['name'],$type),$url);
				$url_digest=str_replace(array('[fid]','[name]','[type]','[page]'),array($fid,$forum['name'],'digest',1),$url);
				$url_pic=str_replace(array('[fid]','[name]','[type]','[page]'),array($fid,$forum['name'],'pic',1),$url);
			}else{
				$url_page='?forum-index-fid-'.$fid.'-type-'.$type.'.htm';
				$url_digest='?forum-index-fid-'.$fid.'-type-digest.htm';
				$url_pic='?forum-index-fid-'.$fid.'-type-pic.htm';
			}
			$typeid && $url_page=$url_page.'?typeid='.$typeid;
		}
		
		$this->check_forum_exists($forum);
		$this->check_forum_status($forum);
		$this->check_access($forum, 'read');
		if($type==''){
			$type=$forum['type_default'];
		}
		// hook forum_topic_index_before.php
		
		$this->_title[]=$forum['name'];
		$this->_seo_keywords = $forum['keywords'] ? $forum['keywords'] : $forum['name'];
		$this->_seo_description=$forum['description'];
		
		$pagesize =$this->conf['forum_index_pagesize'];
		
		misc::setcookie($this->conf['cookie_pre'].'page', $page, $_SERVER['time'] + 86400 * 7, '/');
		// hook forum_index_get_list_before.php

		$start = ($page - 1) * $pagesize;
		$limit = $pagesize;
		$topics = $forum['topics'];
        
		
		//主题分类
		$typearr=array();
		if($forum['typeid']){
			$typearr=$this->type->get_typearr($forum['typeid']);
		}

		// 从 tidcache 取数据
		if($type=='digest'){
			$this->_checked['topic_digest']=" class='ui-tab-active'";
			$topics=$forum['digests'];
			$condition = array('fid'=>$fid,'digest'=>1);
			$orderbyadd = array('lasttime'=>-1);
			//hook forum_index_digest_fetch_before.php
			//$topiclist = $this->topic->index_fetch($condition, $orderbyadd, $start, $limit);
			$topiclist = $this->topic_digest->get_list_by_fid($fid, $start, $limit);
		}elseif($type=='pic'){
			$this->_checked['topic_pic']=" class='ui-tab-active'";
			$topics=$forum['topic_pic'];
			$topiclist = $this->topic_pic->get_list_by_fid($fid, $start, $limit);
			
		}else {
			$this->_checked['topic_all']=" class='ui-tab-active'";
			$condition = array('fid'=>$fid);
			$orderby = array('lasttime'=>-1);
			if(!$typeid){
				$topiclist = $this->topic->get_topiclist_by_fid($fid, $orderby, $start, $limit, $topics);
			}else{
				$topics=$this->type_count->read($fid,$typeid);
				$topics && $topics=$topics['topics'];
				!$topics && $topics=0;
				$topiclist = $this->topic->index_fetch(array('fid'=>$fid,'typeid'=>$typeid),$orderby,$start, $limit);
			}
		}
		
		$toplist = $page == 1 && empty($typeid) ? $this->get_toplist($forum) : array();

		$toplist = array_filter($toplist);
		$threadlist = array_diff_key($topiclist, $toplist);
		$threadlist = array_filter($topiclist);
		// hook forum_index_get_list_after.php
		// 点击次数
		$readtids = '';
		foreach($toplist as &$topic) {

			$readtids .= ','.$topic['tid'];
			$this->topic->format($topic);
		}
		foreach($topiclist as $k=>&$topic) {
			if($topic['top'] > 0 ) {
				unset($topiclist[$k]);
				continue;
			}
			$readtids .= ','.$topic['tid'];
			
			$this->topic->format($topic,1,$forum);
		}
		$readtids = substr($readtids, 1); 
		$click_server = $this->conf['click_server']."?db=tid&r=$readtids";

		$pages = misc::pages($url_page, $topics, $page, $pagesize,'page',$this->conf['urlrewrite']);
		
		$ismod = $this->is_mod($forum, $this->_user);
		//是否本吧成员
		$forum_follow=0;
		$this->_user['uid'] && $forum_follow=$this->forum_users->check_status($fid,$this->_user['uid']);
		//forum category
		$cate=array();
		empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		$miscarr = $_SERVER['miscarr'];
		$cate['pname']=isset($miscarr['category'][$forum['cat_tid']]) ? $miscarr['category'][$forum['cat_tid']] : '';
		$cate['name']=isset($miscarr['category'][$forum['cat_id']]) ? $miscarr['category'][$forum['cat_id']] : '';
		
		$this->view->assign('fid', $fid);
		$this->view->assign('type', $type);
		$this->view->assign('typeid', $typeid);
		$this->view->assign('typearr', $typearr);
		$this->view->assign('forum', $forum);
		$this->view->assign('c', $cate);
		$this->view->assign('page', $page);
		$this->view->assign('pages', $pages);
		$this->view->assign('limit', $limit);
		$this->view->assign('toplist', $toplist);
		$this->view->assign('threadlist', $topiclist);
		$this->view->assign('ismod', $ismod);
		$this->view->assign('forum_follow', $forum_follow);
		$this->view->assign('click_server', $click_server);
		$this->view->assign('url_digest', $url_digest);
		$this->view->assign('url_pic', $url_pic);
		// hook forum_index_after.php
		$this->view->display('forum.html');
		
		
	}
	//申请吧主
	public function on_apply(){
	    $userinfo=$this->_user;
		$uid=intval($userinfo['uid']);
		if($uid<1) $this->message('请先登录',0);
		// fid
		$fid =intval(core::gpc('fid'));
		$forum = $this->mcache->read('forum', $fid);
		$this->check_forum_exists($forum);
		$this->check_forum_status($forum);
		
		if($this->form_submit()){
			
			$ishave=$this->apply->get_by_uid_fid($fid,$uid);
			if(!empty($ishave)) $this->message('你已经申请过该吧吧主，请等待审核！',0);
			$message=core::gpc('message','P');
			
			$message = htmlspecialchars($message);
		    $message = misc::safe_str($message);
		    $message = utf8::safe_substr($message, 0, 200);	
			
			$data=array();
			$data['uid']=$userinfo['uid'];
			$data['uname']=$userinfo['username'];
			$data['fname']=$forum['name'];
			$data['fid']=$fid;
			$data['message']=$message;
			$data['dateline']=$_SERVER['time'];

			$this->apply->create($data);
			$this->message('申请成功，等待审核');
		}else{
			$this->view->assign('fid',$fid);
			$this->view->assign('forum',$forum);
			$this->view->display('forum_applymod.html');
		}
	
    }
	private function get_toplist($forum=array()) {
		$fidtids = array();
		// 3 级置顶
		$fidtids = $this->get_fidtids($this->conf['toptids']);
		
		// 1 级置顶
		$fidtids += $this->get_fidtids($forum['toptids']);
		$toplist = $this->topic->mget($fidtids);
		
		return $toplist;

	}
	// index_control.class copyed
	private function get_fidtids($s) {
		$fidtids = array();
		if($s) {
			$fidtidlist = explode(' ', trim($s));
			foreach($fidtidlist as $fidtid) {
				list($fid, $tid) = explode('-', $fidtid);
				$fidtids["$fid-$tid"] = array($fid, $tid);
			}
		}
		return $fidtids;
	}
	public function on_users(){
	    $fid=intval(core::gpc('fid'));
		/*$forum=$this->forum->read($fid);$forum['users']=0;
		$list=$this->member->index_fetch(array(),array('uid'=>-1),0,100);
		foreach($list as $u){
		    $forum['users']++;
			$this->forum_users->create(array('fid'=>$fid,'uid'=>$u['uid'],'dateline'=>$_SERVER['time']-rand(100,864000),'status'=>1));
	    }
		$this->forum->update($forum);
		$this->mcache->clear('forum',$fid);
		exit('ok');*/
			
		$forum=$this->mcache->read('forum',$fid);
		$this->check_forum_exists($forum);
		$this->check_forum_status($forum);
		
		$this->_title[]='本吧成员_'.$forum['name'];
		$this->_seo_keywords = $forum['keywords'] ? $forum['keywords'] : $forum['name'];
		$this->_seo_description=$forum['description'];
		
		$this->_checked['forum_users']=' class="ui-tab-active"';
		$rank=core::gpc('rank');
		$rank=misc::safe_str($rank);
		
		$page=misc::page();
		$limit=20;
		$start=($page-1)*$limit;
		
		$order=$rank=='posts'?array('posts'=>-1):($rank=='lastpost'?array('lastpost'=>-1):($rank=='signs'?array('sign_days'=>-1):array('dateline'=>-1)));
		
		$userlist=$this->forum_users->get_list(array('fid'=>$fid,'status'=>1),$order,$start,$limit);

		$pages=misc::pages("?forum-users-fid-$fid-rank-$rank.htm",$forum['users'],$page,$limit);
		
		$ismod = $this->is_mod($forum, $this->_user);
		//是否本吧成员
		$forum_follow=0;
		$this->_user['uid'] && $forum_follow=$this->forum_users->check_status($fid,$this->_user['uid']);
		//forum category
		$cate=array();
		empty($_SERVER['miscarr']) && $_SERVER['miscarr'] = $this->mcache->read('miscarr');
		$miscarr = $_SERVER['miscarr'];
		$cate['pname']=isset($miscarr['category'][$forum['cat_tid']]) ? $miscarr['category'][$forum['cat_tid']] : '';
		$cate['name']=isset($miscarr['category'][$forum['cat_id']]) ? $miscarr['category'][$forum['cat_id']] : '';
		
		
		$this->view->assign('ismod', $ismod);
		$this->view->assign('forum_follow', $forum_follow);
		$this->view->assign('forum',$forum);
		$this->view->assign('rank',$rank);
		$this->view->assign('userlist',$userlist);
		$this->view->assign('fid',$fid);
		$this->view->assign('c',$cate);
		$this->view->assign('pages',$pages);
		$this->view->display('forum_users.html');
	}
	
}



?>