<?php
!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class index_control extends common_control {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('post'=>' class="checked"');
	}
	
	public function on_index(){
		// hook index_post_before.php
		$this->on_post();
	}
	public function on_post(){
        $this->_checked['index_post']=" class='current'";
		$this->_title[] = $this->conf['seo_title'] ? $this->conf['seo_title'] :$this->conf['app_name'];
		$this->_seo_keywords = $this->conf['seo_keywords'];
		$this->_seo_description = $this->conf['seo_description'];
		
		$pagesize = 15;
		$toplist = array(); // only top 3
		$readtids = '';
		
		//推荐贴吧
		$forum_rec=$this->kv->get('index_forumrec');
		if(!$forum_rec){
			$forum_rec=$this->forum->get_list(array('recommend'=>1),array('rank'=>-1),0,7);
			foreach($forum_rec as &$fr){
				$this->forum->format($fr);
			}
			$this->kv->set('index_forumrec',$forum_rec,3600);
		}
		// 贴吧分类
		$catelist=$this->kv->get('index_catelist');
		if(!$catelist){
			$catelist = $this->mcache->read('catelist');
			foreach($catelist as &$cate){
				$cflist=$this->mcache->read('cateforum',$cate['id']);
				$cate['forumlist']=array_diff_key($cflist,$forum_rec);
				$cate['forumlist']=array_slice($cate['forumlist'],0,7);
				$cate=array('name'=>$cate['name'],'forumlist'=>$cate['forumlist']);
			}
			$this->kv->set('index_catelist',$catelist,3600);
		}
		
		//hook index_post_list_before.php
		//最新帖子
		$threadlist=$this->kv->get('index_newlist');
		if(!$threadlist){
			$cond=array();
			//hook index_post_newlist_before.php
			$threadlist = $this->topic->get_newlist($cond, $pagesize);
			foreach($threadlist as $k=>&$thread) {
				//$this->topic->format($thread);
				if($thread['top'] == 3) {
					unset($threadlist[$k]);
					$toplist[] = $thread;
					continue;
				}
			}
			$this->kv->set('index_newlist',$threadlist,300);
		}
		//最新回复
		$replylist=$this->kv->get('index_replylist');
		if(!$replylist){
			$cond=array();
			//hook index_post_replylist_before.php
			$replylist = $this->topic->index_fetch($cond,array('lasttime'=>-1),0, $pagesize);
			foreach($replylist as &$f) {
				$this->topic->format($f);
			}
			$this->kv->set('index_replylist',$replylist,300);
		}
		//置顶帖子
		$toplist = $this->get_toplist();
		$toplist = array_filter($toplist);
		foreach($toplist as $k=>&$thread2) {
			$this->topic->format($thread2);
        }

		
        
		
		// 活跃会员
		$hotuser=$this->kv->get('index_hotuser');
		if(!$hotuser){
		    $hotuser=$this->member->index_fetch(array(),array('posts'=>-1),0,12);
			foreach($hotuser as &$user){
				$this->member->format($user);	
			}
			$this->kv->set('index_hotuser',$hotuser,86400);
		}
		//热门标签
		$hot_tags=$this->kv->get('index_hottags');
		if(!$hot_tags){
		     $hot_tags=$this->tags->get_hots(20);
			 $this->kv->set('index_hottags',$hot_tags,3600);
		}
		//热点图文
		
		$hot_pic=$this->kv->get('index_hotpic');
		if(!$hot_pic){
			 $hot_pic=$this->topic_pic->get_list(6);
			 $this->kv->set('index_hotpic',$hot_pic,3600);
		}
		//hook index_post_list_after.php
		
		$ismod = ($this->_user['groupid'] > 0 && $this->_user['groupid'] <= 4);
		$fid = 0;
		
		$friendlinklist = $this->mcache->read('friendlink');
		
		$this->view->assign('friendlinklist', $friendlinklist);
		$this->view->assign('ismod', $ismod);
		$this->view->assign('fid', $fid);
		$this->view->assign('threadlist', $threadlist);
		$this->view->assign('replylist', $replylist);
		$this->view->assign('toplist', $toplist);
		$this->view->assign('catelist',$catelist);
		$this->view->assign('forum_rec', $forum_rec);
		$this->view->assign('hotuser',$hotuser);
		$this->view->assign('hot_tags',$hot_tags);
		$this->view->assign('hot_pic',$hot_pic);
		
		$this->view->display('index.html');
		
	}
	public function on_forum(){
		$this->_checked['index_forum']=" class='current'";
		$cid=intval(core::gpc('cid'));
		
		$catelist=$this->category->index_fetch(array('pid'=>0), array('rank'=>-1), 0, 100);
		$fcate=$scate=$catelist_son=$cond=array();
		if($cid){
			$cate=$this->category->read($cid);
			if($cate){
			   if($cate['pid']>0){
				   $scate=$cate;
				   $catelist_son=$this->category->index_fetch(array('pid'=>$cate['pid']), array('rank'=>-1), 0, 100);
				   $fcate=$this->category->read($cate['pid']);
				   $cond['cat_id']=$cid;
				   $title=$scate['name'].'-'.$fcate['name'].'-贴吧目录';
				   $keyword=$scate['name'].','.$scate['keywords'].','.$fcate['name'].','.$fcate['keywords'];
				   $desc=$scate['description'];
			   }else{
				   $fcate=$cate;
				   $catelist_son=$this->category->index_fetch(array('pid'=>$cid), array('rank'=>-1), 0, 100);
				   $cond['cat_tid']=$cid;
				   $title=$fcate['name'].'-贴吧目录';
				   $keyword=$fcate['name'].','.$fcate['keywords'];
				   $desc=$fcate['description'];
			   }
			   
			}
		}else{
			$title='贴吧目录';
			$keyword=$this->conf['seo_keywords'];;
			$desc=$this->conf['seo_description'];
		}
		$this->_title[] =$title;
		$this->_seo_keywords = $keyword;
		$this->_seo_description = $desc;
		
		//$catelist = $this->mcache->read('catelist');
		$page=misc::page();
		$pagesize=10;
		$start=($page-1)*$pagesize;
		$forumlist=$this->forum->get_list($cond,array('posts'=>-1),$start,$pagesize);
		foreach($forumlist as &$forum){
		   $this->forum->format($forum);	
		}
		$pages=misc::simple_pages("?index-forum-cid-$cid.htm",count($forumlist),$page,$pagesize);
		/*foreach($catelist as &$cate){
			//if(empty($cate['catelist_son'])) continue;
			foreach($cate['catelist_son'] as $son){
				$forumlist[$son['id']]=$this->forum->get_forum_list(array('cat_id'=>$son['id']));
			}
		}*/
		
		// hook index_forum_after.php

		$this->view->assign('catelist', $catelist);
		$this->view->assign('catelist_son', $catelist_son);
		$this->view->assign('cid', $cid);
		$this->view->assign('fcate', $fcate);
        $this->view->assign('scate', $scate);
		$this->view->assign('forumlist', $forumlist);
		$this->view->assign('pages', $pages);
		$this->view->display('forum_list.html');
		
	}
	//生成验证码
	public function on_verify()
	{
		require_once(POST_PATH.'core/xgcms/Image.class.php');
		VerifyImage::buildImageVerify();
	}
	public function on_region(){
		$t=intval(core::gpc('t','G'));
		if($t==1){
			$l=intval(core::gpc('level','R'));
			$list=$this->area->index_fetch(array('level'=>$l),array('listorder'=>1),0,1000);
			$arr=array();
			foreach($list as $v){
				$arr[]=array('regId'=>$v['areaid'],'regNm'=>$v['name']);
				
			}
			$rs=core::json_encode($arr);
		}else{
		    $id=intval(core::gpc('regId','R'));
			$list=$this->area->index_fetch(array('parentid'=>$id),array('listorder'=>1),0,1000);
			$arr=array();
			foreach($list as $v){
				$arr[]=array('regId'=>$v['areaid'],'regNm'=>$v['name']);
				
			}
			$rs=core::json_encode($arr);
		}
		echo $rs;
	
	}
	private function get_toplist($forum = array()) {
		$fidtids = array();
		// 3 级置顶
		$fidtids = $this->get_fidtids($this->conf['toptids']);
		
		// 1 级置顶
		if($forum) {
			$fidtids += $this->get_fidtids($forum['toptids']);
		}
		
		$toplist = $this->topic->mget($fidtids);
		return $toplist;
	}
	
	private function get_fidtids($s) {
		$fidtids = array();
		if($s) {
			$fidtidlist = explode(' ', trim($s));
			foreach($fidtidlist as $fidtid) {
				list($fid, $tid) = explode('-', $fidtid);
				$fidtids["$fid-$tid"] = array($fid, $tid);
			}
		}
		return $fidtids;
	}

}
?>