<?php

/*
 * Copyright (C) xgcms.com
 */

!defined('FRAMEWORK_PATH') && exit('FRAMEWORK_PATH not defined.');

include POST_PATH.'core/control/common_control.class.php';

class rss_control extends common_control {
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->_checked = array('bbs'=>' class="checked"');
	}

	public function on_topic(){
		$fid=core::gpc('fid');
		if( isset($fid) && is_numeric($fid) && $fid >= 1 )
{

// 板块权限检查
		$ForumArr=$forum = $this->mcache->read('forum', $fid);
		$this->check_forum_exists($forum);
		$this->check_forum_status($forum);
		$this->check_access($forum, 'read');

	if( !empty($ForumArr['fid']) )
	{
		header("Content-Type: text/xml");

		echo '<?xml version="1.0" encoding="utf-8"?>';

		echo '<rss version="2.0">';

		echo '<channel>';

		echo '<title>'.$this->conf['app_name'].' - '.stripslashes($ForumArr['fname']).'</title>';

		if($this->conf['urlrewrite'])
			echo '<link>'.$this->conf['app_url'].'forum-index-fid-'.$ForumArr['fid'].'.html</link>';
		else
			echo '<link>'.$this->conf['app_url'].'?forum-index-fid-'.$ForumArr['fid'].'.html</link>';

		echo '<description>'.stripslashes($ForumArr['description']).'</description>';

		echo '<copyright>Copyright(C) xgcms.com</copyright>';

		echo '<generator>kami</generator>';

		echo '<lastBuildDate>'.date('r').'</lastBuildDate>';

		echo '<ttl>120</ttl>';

		echo '<image>';

		echo '<url>'.$this->conf['app_url'].'/view/images/logo.gif</url>';

		echo '<title>'.$this->conf['app_name'].'</title>';

		echo '<link>'.$this->conf['app_url'].'</link>';

		echo '</image>';

		$condition = array('fid'=>$fid);
			$orderbyadd = array('lasttime'=>-1);
			$Result = $this->topic->index_fetch($condition, $orderbyadd, 0, 100);

		if($Result)foreach($Result as $k=>$Re)
		{   
			echo '<item>';
			
			echo '<title>'.$Re['subject'].'</title>';
			
			if($this->conf['urlrewrite'])
				echo '<link>'.$this->conf['app_url'].'topic-index-fid-'.$Re['fid'].'-tid-'.$Re['tid'].'.html</link>';
			else
				echo '<link>'.$this->conf['app_url'].'?topic-index-fid-'.$Re['fid'].'-tid-'.$Re['tid'].'.html</link>';
			
			echo '<description><![CDATA['.$Re['brief'].']]></description>';
			
			echo '<category>'.stripslashes($ForumArr['fname']).'</category>';
			
			echo '<author>'.stripslashes($Re['author']).'</author>';
			
			echo '<pubDate>'.date('r',$Re['dateline']).'</pubDate>';
			
			echo '</item>';
			
		}

		echo '</channel>';

		echo '</rss>';
	}
		
	}
	
}
public function on_index(){
	$app_url=$this->conf['app_url'];
	$list=$this->topic->index_fetch(array(),array('tid'=>-1),0,1000);
	$str='<?xml version="1.0" encoding="UTF-8"?>
   <urlset>';
   
   foreach($list as $v){
	   $this->topic->format($v);
       $str.=' <url>
          <loc>'.$app_url.$v['url'].'</loc>
          <lastmod>'.date('Y-m-d',$v['dateline']).'</lastmod>
          <changefreq>always</changefreq>
          <priority>1.0</priority>
        </url>';
   }
   $str.='
   </urlset>';
	@file_put_contents(POST_PATH.'sitemap.xml',$str);	
}
}
?>