<?php

/*
 * Copyright (C) xgcms.com
 */

class mypost extends base_model {
	
	function __construct(&$conf) {
		parent::__construct($conf);
		$this->table = 'mypost';
		$this->primarykey = array('uid', 'fid', 'pid');
		
	}

	/*
		$arr = array(
			'uid'=>1,
			'fid'=>123,
			'tid'=>123,
			'pid'=>123,
		);
	*/

	
	public function read_by_tid($uid, $fid, $tid) {
		$mypost = $this->index_fetch(array('uid'=>$uid, 'fid'=>$fid, 'tid'=>$tid), array(), 0, 1);
		return count($mypost) > 0 ? array_pop($mypost) : array();
	}
	
	// 判断某个 tid 是否已经被加入过了
	public function have_tid($uid, $fid, $tid) {
		$havetid = $this->index_fetch(array('uid'=>$uid, 'fid'=>$fid, 'tid'=>$tid), array(), 0, 1);
		return count($havetid);
	}

	public function _delete($uid, $fid, $pid) {
		$return = $this->delete($uid, $fid, $pid);
		if($return) {
			$this->count('-1');
		}
		return $return;
	}
	
	public function get_list_by_uid($uid, $page = 1, $pagesize = 30) {
		$mypostlist = $this->index_fetch(array('uid'=>$uid), array('pid'=>-1), ($page - 1) * $pagesize, $pagesize);
		return $mypostlist;
	}
	
	/*
	foreach($mypostlist as &$mypost) {
		$this->format($mypost);
	}
	*/
	public function format(&$mypost) {
		$thread = $this->topic->read($mypost['fid'], $mypost['tid']);
		$post = $this->post->read($mypost['fid'], $mypost['pid']);
        if($thread&&$post){
		  $this->topic->format($thread);
		  $this->post->format($post);
          $mypost=array('topic'=>$thread,'post'=>$post);
          $mypost['type']=$thread['firstpid']==$post['pid']?'发布主题':'回复帖子';
        }else{
            $mypost=array();
        }
	}
	public function sim_format(&$mypost) {
		$thread = $this->topic->read($mypost['fid'], $mypost['tid']);
		$this->topic->format($thread);
		$mypost['topic'] = $thread;
	}
}
?>