<?php

/*
 * Copyright (C) xgcms.com
 */

class xctag extends base_model {
	function __construct(&$conf) {
		parent::__construct($conf);
	}
	public function api($data=array()){
		$id=intval($data['id']);
		$api=$this->api->read($id);
		if(!$api ) return array();
		
		$this->api->format($api);
		if($api['cache'] && $_SERVER['time']<$api['updatetime']){
			$tids=json_decode($api['data']);
			$list=$this->topic->mget($tids);
		}else{
			$cond=array();
			intval($api['fid'])>0 && $cond['fid']=$api['fid'];
			if($api['digest']>0){
				if($api['digest']==1){
					$cond['digest']=array('digest'=>array('>'=>0));
				}else{
					$cond['digest']=$api['digest']-1;
				}
			}
			$api['top']>0 && $cond['top']=$api['top'];
			$api['typeid']>0 && $cond['typeid']=$typeid;
			
			$order=$api['rank']==1?'lasttime':($api['rank']==2?'posts':'dateline');
			$order=array($order=>-1);
			$limit=$api['num']>0?$api['num']:10;
			$list=$this->topic->index_fetch($cond,$order,0,$limit);
		}
		
		$nlist=$tids=array();
		foreach($list as &$v){
			$this->topic->format($v);
			$tids[]=array($v['fid'],$v['tid']);
		}
		
		if($api['cache'] && $_SERVER['time']>$api['updatetime']){
			$api2=$this->api->read($id);
			$api2['data']=core::json_encode($tids);
			$api2['updatetime']=$_SERVER['time']+$api['cache'];
			$this->api->update($api2);
		}
		return $list;
	}
	public function topic($data=array()){
		if($data['cache']){
			isset($data['fid']) && $data['tagid'].=$data['fid'];
			$list=$this->cache($data['tagid']);
			if($list) return $list;
		}
		$map=$order=array();
		//$map['status']=99;
		
        if(isset($data['asc'])&&in_array($data['asc'],array('dateline','lasttime','posts'))){
			$col=$data['asc'];
			$asc=1;
			$order=array($data['asc']=>'1');
		}elseif(isset($data['desc'])&&in_array($data['desc'],array('dateline','lasttime','posts'))){
			$col=$data['desc'];
			$asc=0;
			$order=array($data['desc']=>'-1');
		}else{
			$col='id';
			$asc=0;
			$order=array('dateline'=>-1);
		}

		if(isset($data['fid'])) $map['fid']=intval($data['fid']);
		if(isset($data['typeid'])) $map['typeid']=intval($data['typeid']);
		if(isset($data['digest'])) $map['digest']=array('>'=>0);
		if(isset($data['top'])) $map['top']=intval($data['top']);
		if(isset($data['uid'])) $map['authorid']=intval($data['authorid']);
		

		$list=$this->topic->index_fetch($map,$order,$data['start'],$data['num']);
		foreach($list as &$v){
			$this->topic->format($v);
		}
		if($data['cache']) $this->runtime->set('xctag_'.$data['tagid'],$list,$data['cache']);
		return $list;	
	}
	public function topic_pic($data=array()){
		if($data['cache']){
			isset($data['fid']) && $data['tagid'].=$data['fid'];
			$list=$this->cache($data['tagid']);
			if($list) return $list;
		}
		$order=array('tid'=>-1);
		if(isset($data['fid'])){
			$fid=intval($data['fid']);
			$list=$this->topic_pic->get_list_by_fid($fid,$data['start'],$data['num']);
		}else{
			$list=$this->topic_pic->get_list($data['num']);
		}
		if($data['cache']) $this->runtime->set('xctag_'.$data['tagid'],$list,$data['cache']);
		return $list;	
	}
	public function user($data=array()){
		if($data['cache']){
			$list=$this->cache($data['tagid']);
			if($list) return $list;
		}
		if(isset($data['desc']) && in_array($data['desc'],array('regdate','credits','golds','topics','posts','digests','followeds','onlinetime','lastactive'))){
			$order=array($data['desc']=>-1);
		}else{
			$order=array('regdate'=>-1);
		}
		$map=array();
		if(isset($data['sex'])) $map['sex']=intval($data['sex']);
		isset($data['city']) && $map['city']=intval($data['city']);
		isset($data['avatar']) && $map['avatar']=array('>'=>0);
		$list=$this->member->index_fetch($map,$order,$data['start'],$data['num']);
		foreach($list as &$v){
		   $this->member->format($v);	
		}
		if($data['cache']) $this->runtime->set('xctag_'.$data['tagid'],$list,$data['cache']);
		return $list;
	}
	private function cache($tagid){
		$list=$this->runtime->get('xctag_'.$tagid);
		return $list;
	}
}
?>